/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.content.Context;
import android.view.LayoutInflater;
import android.widget.BaseAdapter;
import io.realm.RealmChangeListener;
import io.realm.RealmObject;
import io.realm.RealmResults;

public abstract class RealmBaseAdapter<T extends RealmObject>
extends BaseAdapter {
    protected LayoutInflater inflater;
    protected RealmResults<T> realmResults;
    protected Context context;

    public RealmBaseAdapter(Context context, RealmResults<T> realmResults, boolean automaticUpdate) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        if (realmResults == null) {
            throw new IllegalArgumentException("RealmResults cannot be null");
        }
        this.context = context;
        this.realmResults = realmResults;
        this.inflater = LayoutInflater.from((Context)context);
        if (automaticUpdate) {
            realmResults.getRealm().addChangeListener(new RealmChangeListener(){

                @Override
                public void onChange() {
                    RealmBaseAdapter.this.notifyDataSetChanged();
                }
            });
        }
    }

    public int getCount() {
        return this.realmResults.size();
    }

    public T getItem(int i) {
        return (T)this.realmResults.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public void updateRealmResults(RealmResults<T> realmResults) {
        this.realmResults = realmResults;
        this.notifyDataSetChanged();
    }
}

