/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.JsonReader;
import io.realm.RealmChangeListener;
import io.realm.RealmMigration;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.exceptions.RealmException;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.ColumnIndices;
import io.realm.internal.ColumnType;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.RealmJson;
import io.realm.internal.Row;
import io.realm.internal.SharedGroup;
import io.realm.internal.Table;
import io.realm.internal.TableView;
import io.realm.internal.android.ReleaseAndroidLogger;
import io.realm.internal.log.RealmLog;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Realm
implements Closeable {
    public static final String DEFAULT_REALM_NAME = "default.realm";
    private static final String TAG = "REALM";
    private static final String TABLE_PREFIX = "class_";
    protected static final ThreadLocal<Map<Integer, Realm>> realmsCache = new ThreadLocal<Map<Integer, Realm>>(){

        @Override
        @SuppressLint(value={"UseSparseArrays"})
        protected Map<Integer, Realm> initialValue() {
            return new HashMap<Integer, Realm>();
        }
    };
    private static final ThreadLocal<Map<Integer, Integer>> referenceCount = new ThreadLocal<Map<Integer, Integer>>(){

        @Override
        @SuppressLint(value={"UseSparseArrays"})
        protected Map<Integer, Integer> initialValue() {
            return new HashMap<Integer, Integer>();
        }
    };
    private static final int REALM_CHANGED = 14930352;
    protected static final Map<Handler, Integer> handlers = new ConcurrentHashMap<Handler, Integer>();
    private static final Map<Integer, AtomicInteger> openRealms = new ConcurrentHashMap<Integer, AtomicInteger>();
    private static final String APT_NOT_EXECUTED_MESSAGE = "Annotation processor may not have been executed.";
    private static final String INCORRECT_THREAD_MESSAGE = "Realm access from incorrect thread. Realm objects can only be accessed on the thread they where created.";
    private static final String CLOSED_REALM_MESSAGE = "This Realm instance has already been closed, making it unusable.";
    private static final String INVALID_KEY_MESSAGE = "The provided key is invalid. It should either be null or be 64 bytes long.";
    private static final String DIFFERENT_KEY_MESSAGE = "Wrong key used to decrypt Realm.";
    private static SharedGroup.Durability defaultDurability = SharedGroup.Durability.FULL;
    private boolean autoRefresh;
    private Handler handler;
    private final byte[] key;
    private final int id;
    private final String path;
    private SharedGroup sharedGroup;
    private final ImplicitTransaction transaction;
    private final RealmJson realmJson = this.getRealmJson();
    private final Map<Class<?>, String> simpleClassNames = new HashMap();
    private final Map<String, Class<?>> generatedClasses = new HashMap();
    private final Map<Class<?>, Constructor> constructors = new HashMap();
    private final Map<Class<?>, Method> initTableMethods = new HashMap();
    private final Map<Class<?>, Method> insertOrUpdateMethods = new HashMap();
    private final Map<Class<?>, Constructor> generatedConstructors = new HashMap();
    private final Map<Class<?>, String> proxiedClassNames = new HashMap();
    private final List<RealmChangeListener> changeListeners = new ArrayList<RealmChangeListener>();
    private final Map<Class<?>, Table> tables = new HashMap();
    private static final Set<Class<? extends RealmObject>> customSchema = new HashSet<Class<? extends RealmObject>>();
    private static final long UNVERSIONED = -1L;
    final ColumnIndices columnIndices = new ColumnIndices();

    protected void checkIfValid() {
        if (this.sharedGroup == null) {
            throw new IllegalStateException(CLOSED_REALM_MESSAGE);
        }
        Realm currentRealm = realmsCache.get().get(this.id);
        if (currentRealm != this) {
            throw new IllegalStateException(INCORRECT_THREAD_MESSAGE);
        }
    }

    private Realm(String absolutePath, byte[] key, boolean autoRefresh) {
        if (key != null && key.length != 64) {
            throw new IllegalArgumentException(INVALID_KEY_MESSAGE);
        }
        this.sharedGroup = new SharedGroup(absolutePath, true, key);
        this.transaction = this.sharedGroup.beginImplicitTransaction();
        this.path = absolutePath;
        this.key = key;
        this.id = absolutePath.hashCode();
        this.setAutoRefresh(autoRefresh);
    }

    protected void finalize() throws Throwable {
        if (this.sharedGroup != null) {
            RealmLog.w("Remember to call close() on all Realm instances. Realm " + this.path + " is being finalized without being closed, " + "this can lead to running out of native memory.");
        }
        super.finalize();
    }

    @Override
    public void close() {
        int refCount;
        Map<Integer, Integer> localRefCount = referenceCount.get();
        Integer references = localRefCount.get(this.id);
        if (references == null) {
            references = 0;
        }
        if (this.sharedGroup != null && references == 1) {
            realmsCache.get().remove(this.id);
            this.sharedGroup.close();
            this.sharedGroup = null;
            AtomicInteger counter = openRealms.get(this.id);
            counter.decrementAndGet();
        }
        if ((refCount = references - 1) < 0) {
            RealmLog.w("Calling close() on a Realm that is already closed: " + this.getPath());
        }
        localRefCount.put(this.id, Math.max(0, refCount));
        if (this.handler != null && refCount <= 0) {
            this.removeHandler(this.handler);
        }
    }

    private void removeHandler(Handler handler) {
        handler.removeCallbacksAndMessages(null);
        handlers.remove(handler);
    }

    public RealmJson getRealmJson() {
        try {
            Class<?> clazz = Class.forName("io.realm.RealmJsonImpl");
            Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            return (RealmJson)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RealmException("Could not find io.realm.RealmJsonImpl", e);
        }
        catch (InvocationTargetException e) {
            throw new RealmException("Could not create an instance of io.realm.RealmJsonImpl", e);
        }
        catch (InstantiationException e) {
            throw new RealmException("Could not create an instance of io.realm.RealmJsonImpl", e);
        }
        catch (IllegalAccessException e) {
            throw new RealmException("Could not create an instance of io.realm.RealmJsonImpl", e);
        }
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        if (autoRefresh && Looper.myLooper() == null) {
            throw new IllegalStateException("Cannot set auto-refresh in a Thread without a Looper");
        }
        if (autoRefresh && !this.autoRefresh) {
            this.handler = new Handler((Handler.Callback)new RealmCallback());
            handlers.put(this.handler, this.id);
        } else if (!autoRefresh && this.autoRefresh && this.handler != null) {
            this.removeHandler(this.handler);
        }
        this.autoRefresh = autoRefresh;
    }

    public Table getTable(Class<?> clazz) {
        String proxySuffix = "RealmProxy";
        String proxiedClassName = this.proxiedClassNames.get(clazz);
        if (proxiedClassName == null) {
            String classSimpleName = clazz.getSimpleName();
            proxiedClassName = classSimpleName.replace("RealmProxy", "");
            this.proxiedClassNames.put(clazz, proxiedClassName);
        }
        return this.transaction.getTable(TABLE_PREFIX + proxiedClassName);
    }

    public static Realm getInstance(Context context) {
        return Realm.getInstance(context, DEFAULT_REALM_NAME);
    }

    public static Realm getInstance(Context context, String fileName) {
        return Realm.getInstance(context, fileName, null);
    }

    public static Realm getInstance(Context context, byte[] key) {
        return Realm.getInstance(context, DEFAULT_REALM_NAME, key);
    }

    public static Realm getInstance(Context context, String fileName, byte[] key) {
        return Realm.create(context.getFilesDir(), fileName, key);
    }

    public static Realm getInstance(File writeableFolder) {
        return Realm.create(writeableFolder, DEFAULT_REALM_NAME, null);
    }

    public static Realm getInstance(File writeableFolder, String fileName) {
        return Realm.create(writeableFolder, fileName, null);
    }

    public static Realm getInstance(File writeableFolder, byte[] key) {
        return Realm.create(writeableFolder, DEFAULT_REALM_NAME, key);
    }

    public static Realm getInstance(File writeableFolder, String fileName, byte[] key) {
        return Realm.create(writeableFolder, fileName, key);
    }

    private static Realm create(File writableFolder, String filename, byte[] key) {
        Realm.checkValidRealmPath(writableFolder, filename);
        String absolutePath = new File(writableFolder, filename).getAbsolutePath();
        if (Looper.myLooper() != null) {
            return Realm.createAndValidate(absolutePath, key, true, true);
        }
        return Realm.createAndValidate(absolutePath, key, true, false);
    }

    private static synchronized Realm createAndValidate(String absolutePath, byte[] key, boolean validateSchema, boolean autoRefresh) {
        Map<Integer, Realm> realms;
        Realm realm;
        int id = absolutePath.hashCode();
        Map<Integer, Integer> localRefCount = referenceCount.get();
        Integer references = localRefCount.get(id);
        if (references == null) {
            references = 0;
        }
        if ((realm = (realms = realmsCache.get()).get(absolutePath.hashCode())) != null) {
            if (!Arrays.equals(realm.key, key)) {
                throw new IllegalStateException(DIFFERENT_KEY_MESSAGE);
            }
            localRefCount.put(id, references + 1);
            return realm;
        }
        realm = new Realm(absolutePath, key, autoRefresh);
        realms.put(absolutePath.hashCode(), realm);
        realmsCache.set(realms);
        localRefCount.put(id, references + 1);
        if (references == 0) {
            AtomicInteger counter = openRealms.get(id);
            if (counter == null) {
                openRealms.put(id, new AtomicInteger(1));
            } else {
                counter.incrementAndGet();
            }
        }
        if (validateSchema) {
            try {
                Realm.initializeRealm(realm);
            }
            catch (RuntimeException e) {
                realm.close();
                throw e;
            }
        }
        return realm;
    }

    private static void checkValidRealmPath(File writableFolder, String filename) {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("Non-empty filename must be provided");
        }
        if (writableFolder == null || !writableFolder.isDirectory()) {
            throw new IllegalArgumentException("An existing folder must be provided. Yours was " + (writableFolder != null ? writableFolder.getAbsolutePath() : "null"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeRealm(Realm realm) {
        ArrayList<String> proxyClasses;
        Method getProxyClassesMethod;
        Class<?> validationClass;
        try {
            validationClass = Class.forName("io.realm.ValidationList");
        }
        catch (ClassNotFoundException e) {
            throw new RealmException("Could not find the generated ValidationList class: Annotation processor may not have been executed.");
        }
        try {
            getProxyClassesMethod = validationClass.getMethod("getProxyClasses", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RealmException("Could not find the getProxyClasses method in the ValidationList class: Annotation processor may not have been executed.");
        }
        try {
            proxyClasses = (ArrayList<String>)getProxyClassesMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RealmException("Could not execute the getProxyClasses method in the ValidationList class: Annotation processor may not have been executed.");
        }
        catch (InvocationTargetException e) {
            throw new RealmException("An exception was thrown in the getProxyClasses method in the ValidationList class: Annotation processor may not have been executed.");
        }
        if (customSchema.size() > 0) {
            proxyClasses = new ArrayList<String>();
            for (Class<? extends RealmObject> clazz : customSchema) {
                proxyClasses.add(clazz.getName());
            }
        }
        long version = realm.getVersion();
        boolean commitNeeded = false;
        try {
            realm.beginTransaction();
            if (version == -1L) {
                realm.setVersion(0L);
                commitNeeded = true;
            }
            for (String className : proxyClasses) {
                Map indices;
                Method columnIndiciesMethod;
                Method validateMethod;
                Class<?> generatedClass;
                String[] splitted = className.split("\\.");
                String modelClassName = splitted[splitted.length - 1];
                String generatedClassName = Realm.getProxyClassName(modelClassName);
                try {
                    generatedClass = Class.forName(generatedClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RealmException("Could not find the generated " + generatedClassName + " class: " + APT_NOT_EXECUTED_MESSAGE);
                }
                if (version == -1L) {
                    Method initTableMethod;
                    try {
                        initTableMethod = generatedClass.getMethod("initTable", ImplicitTransaction.class);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RealmException("Could not find the initTable method in the generated " + generatedClassName + " class: " + APT_NOT_EXECUTED_MESSAGE);
                    }
                    try {
                        initTableMethod.invoke(null, realm.transaction);
                        commitNeeded = true;
                    }
                    catch (IllegalAccessException e) {
                        throw new RealmException("Could not execute the initTable method in the " + generatedClassName + " class: " + APT_NOT_EXECUTED_MESSAGE);
                    }
                    catch (InvocationTargetException e) {
                        throw new RealmException("An exception was thrown in the initTable method in the " + generatedClassName + " class: " + APT_NOT_EXECUTED_MESSAGE);
                    }
                }
                try {
                    validateMethod = generatedClass.getMethod("validateTable", ImplicitTransaction.class);
                }
                catch (NoSuchMethodException e) {
                    throw new RealmException("Could not find the validateTable method in the generated " + generatedClassName + " class: " + APT_NOT_EXECUTED_MESSAGE);
                }
                try {
                    validateMethod.invoke(null, realm.transaction);
                }
                catch (IllegalAccessException e) {
                    throw new RealmException("Could not execute the validateTable method in the " + generatedClassName + " class: " + APT_NOT_EXECUTED_MESSAGE);
                }
                catch (InvocationTargetException e) {
                    throw new RealmMigrationNeededException(e.getMessage(), e);
                }
                try {
                    columnIndiciesMethod = generatedClass.getMethod("getColumnIndices", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new RealmException("Could not find the getColumnIndices method in the generated " + generatedClassName + " class: " + APT_NOT_EXECUTED_MESSAGE);
                }
                try {
                    indices = (Map)columnIndiciesMethod.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new RealmException("Could not execute the getColumnIndices method in the generated " + generatedClassName + " class", e);
                }
                catch (InvocationTargetException e) {
                    throw new RealmException("An exception was thrown in the getColumnIndices method in the generated " + generatedClassName + " class", e);
                }
                realm.columnIndices.addClass(generatedClass.getSuperclass(), indices);
            }
        }
        finally {
            if (commitNeeded) {
                realm.commitTransaction();
            } else {
                realm.cancelTransaction();
            }
        }
    }

    public <E extends RealmObject> void createAllFromJson(Class<E> clazz, JSONArray json) {
        if (clazz == null || json == null) {
            return;
        }
        for (int i = 0; i < json.length(); ++i) {
            try {
                this.realmJson.createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), false);
                continue;
            }
            catch (Exception e) {
                throw new RealmException("Could not map Json", e);
            }
        }
    }

    public <E extends RealmObject> void createOrUpdateAllFromJson(Class<E> clazz, JSONArray json) {
        if (clazz == null || json == null) {
            return;
        }
        this.checkHasPrimaryKey(clazz);
        for (int i = 0; i < json.length(); ++i) {
            try {
                this.realmJson.createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), true);
                continue;
            }
            catch (Exception e) {
                throw new RealmException("Could not map Json", e);
            }
        }
    }

    public <E extends RealmObject> void createAllFromJson(Class<E> clazz, String json) {
        JSONArray arr;
        if (clazz == null || json == null || json.length() == 0) {
            return;
        }
        try {
            arr = new JSONArray(json);
        }
        catch (Exception e) {
            throw new RealmException("Could not create JSON array from string", e);
        }
        this.createAllFromJson(clazz, arr);
    }

    public <E extends RealmObject> void createOrUpdateAllFromJson(Class<E> clazz, String json) {
        JSONArray arr;
        if (clazz == null || json == null || json.length() == 0) {
            return;
        }
        this.checkHasPrimaryKey(clazz);
        try {
            arr = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new RealmException("Could not create JSON array from string", e);
        }
        this.createOrUpdateAllFromJson(clazz, arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public <E extends RealmObject> void createAllFromJson(Class<E> clazz, InputStream inputStream) throws IOException {
        if (clazz == null || inputStream == null) {
            return;
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
        try {
            reader.beginArray();
            while (reader.hasNext()) {
                this.realmJson.createUsingJsonStream(clazz, this, reader);
            }
            reader.endArray();
        }
        finally {
            reader.close();
        }
    }

    @TargetApi(value=11)
    public <E extends RealmObject> void createOrUpdateAllFromJson(Class<E> clazz, InputStream in) throws IOException {
        if (clazz == null || in == null) {
            return;
        }
        this.checkHasPrimaryKey(clazz);
        Scanner scanner = null;
        try {
            scanner = this.getFullStringScanner(in);
            JSONArray json = new JSONArray(scanner.next());
            for (int i = 0; i < json.length(); ++i) {
                this.realmJson.createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), true);
            }
        }
        catch (JSONException e) {
            throw new RealmException("Failed to read JSON", e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    public <E extends RealmObject> E createObjectFromJson(Class<E> clazz, JSONObject json) {
        if (clazz == null || json == null) {
            return null;
        }
        try {
            return this.realmJson.createOrUpdateUsingJsonObject(clazz, this, json, false);
        }
        catch (Exception e) {
            throw new RealmException("Could not map Json", e);
        }
    }

    public <E extends RealmObject> E createOrUpdateObjectFromJson(Class<E> clazz, JSONObject json) {
        if (clazz == null || json == null) {
            return null;
        }
        this.checkHasPrimaryKey(clazz);
        try {
            return this.realmJson.createOrUpdateUsingJsonObject(clazz, this, json, true);
        }
        catch (JSONException e) {
            throw new RealmException("Could not map Json", e);
        }
    }

    public <E extends RealmObject> E createObjectFromJson(Class<E> clazz, String json) {
        JSONObject obj;
        if (clazz == null || json == null || json.length() == 0) {
            return null;
        }
        try {
            obj = new JSONObject(json);
        }
        catch (Exception e) {
            throw new RealmException("Could not create Json object from string", e);
        }
        return this.createObjectFromJson(clazz, obj);
    }

    public <E extends RealmObject> E createOrUpdateObjectFromJson(Class<E> clazz, String json) {
        JSONObject obj;
        if (clazz == null || json == null || json.length() == 0) {
            return null;
        }
        this.checkHasPrimaryKey(clazz);
        try {
            obj = new JSONObject(json);
        }
        catch (Exception e) {
            throw new RealmException("Could not create Json object from string", e);
        }
        return this.createOrUpdateObjectFromJson(clazz, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public <E extends RealmObject> E createObjectFromJson(Class<E> clazz, InputStream inputStream) throws IOException {
        if (clazz == null || inputStream == null) {
            return null;
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
        try {
            E e = this.realmJson.createUsingJsonStream(clazz, this, reader);
            return e;
        }
        finally {
            reader.close();
        }
    }

    @TargetApi(value=11)
    public <E extends RealmObject> E createOrUpdateObjectFromJson(Class<E> clazz, InputStream in) throws IOException {
        if (clazz == null || in == null) {
            return null;
        }
        this.checkHasPrimaryKey(clazz);
        Scanner scanner = null;
        try {
            scanner = this.getFullStringScanner(in);
            JSONObject json = new JSONObject(scanner.next());
            E e = this.realmJson.createOrUpdateUsingJsonObject(clazz, this, json, true);
            return e;
        }
        catch (JSONException e) {
            throw new RealmException("Failed to read JSON", e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private Scanner getFullStringScanner(InputStream in) {
        return new Scanner(in, "UTF-8").useDelimiter("\\A");
    }

    public void writeCopyTo(File destination) throws IOException {
        this.writeEncryptedCopyTo(destination, null);
    }

    public void writeEncryptedCopyTo(File destination, byte[] key) throws IOException {
        if (destination == null) {
            throw new IllegalArgumentException("The destination argument cannot be null");
        }
        this.checkIfValid();
        this.transaction.writeToFile(destination, key);
    }

    public <E extends RealmObject> E createObject(Class<E> clazz) {
        Table table = this.initTable(clazz);
        long rowIndex = table.addEmptyRow();
        return this.get(clazz, rowIndex);
    }

    <E extends RealmObject> E createObject(Class<E> clazz, Object primaryKeyValue) {
        Table table = this.initTable(clazz);
        long rowIndex = table.addEmptyRowWithPrimaryKey(primaryKeyValue);
        return this.get(clazz, rowIndex);
    }

    private <E extends RealmObject> Table initTable(Class<E> clazz) {
        Table table = this.tables.get(clazz);
        if (table == null) {
            Class<?> generatedClass = this.getProxyClass(clazz);
            Method method = this.initTableMethods.get(generatedClass);
            if (method == null) {
                try {
                    method = generatedClass.getMethod("initTable", ImplicitTransaction.class);
                }
                catch (NoSuchMethodException e) {
                    throw new RealmException("Could not find the initTable() method in generated proxy class: Annotation processor may not have been executed.");
                }
                this.initTableMethods.put(generatedClass, method);
            }
            try {
                table = (Table)method.invoke(null, this.transaction);
                this.tables.put(clazz, table);
            }
            catch (IllegalAccessException e) {
                throw new RealmException("Could not launch the initTable method: Annotation processor may not have been executed.");
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new RealmException("An exception occurred while running the initTable method: Annotation processor may not have been executed.");
            }
        }
        return table;
    }

    private Class<?> getProxyClass(Class<?> clazz) {
        String simpleClassName = this.getClassSimpleName(clazz);
        String generatedClassName = Realm.getProxyClassName(simpleClassName);
        Class<?> generatedClass = this.generatedClasses.get(generatedClassName);
        if (generatedClass == null) {
            try {
                generatedClass = Class.forName(generatedClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RealmException("Could not find the generated proxy class: Annotation processor may not have been executed.");
            }
            this.generatedClasses.put(generatedClassName, generatedClass);
        }
        return generatedClass;
    }

    <E> void remove(Class<E> clazz, long objectIndex) {
        this.getTable(clazz).moveLastOver(objectIndex);
    }

    <E extends RealmObject> E get(Class<E> clazz, long rowIndex) {
        RealmObject result;
        Table table = this.tables.get(clazz);
        if (table == null) {
            String simpleClassName = this.getClassSimpleName(clazz);
            table = this.transaction.getTable(TABLE_PREFIX + simpleClassName);
            this.tables.put(clazz, table);
        }
        Row row = table.getRow(rowIndex);
        Constructor<?> constructor = this.generatedConstructors.get(clazz);
        if (constructor == null) {
            String simpleClassName = this.getClassSimpleName(clazz);
            String generatedClassName = Realm.getProxyClassName(simpleClassName);
            Class<?> generatedClass = this.generatedClasses.get(generatedClassName);
            if (generatedClass == null) {
                try {
                    generatedClass = Class.forName(generatedClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RealmException("Could not find the generated proxy class: Annotation processor may not have been executed.");
                }
                this.generatedClasses.put(generatedClassName, generatedClass);
            }
            if ((constructor = this.constructors.get(generatedClass)) == null) {
                try {
                    constructor = generatedClass.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new RealmException("Could not find the constructor in generated proxy class: Annotation processor may not have been executed.");
                }
                this.constructors.put(generatedClass, constructor);
                this.generatedConstructors.put(clazz, constructor);
            }
        }
        try {
            result = (RealmObject)constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RealmException("Could not instantiate the proxy class");
        }
        catch (IllegalAccessException e) {
            throw new RealmException("Could not run the constructor of the proxy class");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new RealmException("An exception occurred while instantiating the proxy class");
        }
        result.row = row;
        result.realm = this;
        return (E)result;
    }

    public <E extends RealmObject> E copyToRealm(E object) {
        this.checkNotNullObject(object);
        return this.copyOrUpdate(object, false);
    }

    public <E extends RealmObject> E copyToRealmOrUpdate(E object) {
        this.checkNotNullObject(object);
        this.checkHasPrimaryKey(object);
        return this.copyOrUpdate(object, true);
    }

    public <E extends RealmObject> List<E> copyToRealm(Iterable<E> objects) {
        if (objects == null) {
            return new ArrayList();
        }
        ArrayList<RealmObject> realmObjects = new ArrayList<RealmObject>();
        for (RealmObject object : objects) {
            realmObjects.add(this.copyToRealm(object));
        }
        return realmObjects;
    }

    public <E extends RealmObject> List<E> copyToRealmOrUpdate(Iterable<E> objects) {
        if (objects == null) {
            return new ArrayList();
        }
        ArrayList<RealmObject> realmObjects = new ArrayList<RealmObject>();
        for (RealmObject object : objects) {
            realmObjects.add(this.copyToRealmOrUpdate(object));
        }
        return realmObjects;
    }

    private static String getProxyClassName(String simpleClassName) {
        return "io.realm." + simpleClassName + "RealmProxy";
    }

    boolean contains(Class<?> clazz) {
        return this.transaction.hasTable(TABLE_PREFIX + this.getClassSimpleName(clazz));
    }

    public <E extends RealmObject> RealmQuery<E> where(Class<E> clazz) {
        this.checkIfValid();
        return new RealmQuery<E>(this, clazz);
    }

    public <E extends RealmObject> RealmResults<E> allObjects(Class<E> clazz) {
        return this.where(clazz).findAll();
    }

    public <E extends RealmObject> RealmResults<E> allObjectsSorted(Class<E> clazz, String fieldName, boolean sortAscending) {
        this.checkIfValid();
        Table table = this.getTable(clazz);
        TableView.Order order = sortAscending ? TableView.Order.ascending : TableView.Order.descending;
        long columnIndex = this.columnIndices.getColumnIndex(clazz, fieldName);
        if (columnIndex < 0L) {
            throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
        }
        TableView tableView = table.getSortedView(columnIndex, order);
        return new RealmResults<E>(this, tableView, clazz);
    }

    public <E extends RealmObject> RealmResults<E> allObjectsSorted(Class<E> clazz, String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2) {
        return this.allObjectsSorted(clazz, new String[]{fieldName1, fieldName2}, new boolean[]{sortAscending1, sortAscending2});
    }

    public <E extends RealmObject> RealmResults<E> allObjectsSorted(Class<E> clazz, String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2, String fieldName3, boolean sortAscending3) {
        return this.allObjectsSorted(clazz, new String[]{fieldName1, fieldName2, fieldName3}, new boolean[]{sortAscending1, sortAscending2, sortAscending3});
    }

    public <E extends RealmObject> RealmResults<E> allObjectsSorted(Class<E> clazz, String[] fieldNames, boolean[] sortAscending) {
        if (fieldNames == null) {
            throw new IllegalArgumentException("fieldNames must be provided.");
        }
        if (sortAscending == null) {
            throw new IllegalArgumentException("sortAscending must be provided.");
        }
        Table table = this.getTable(clazz);
        long[] columnIndices = new long[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            long columnIndex = table.getColumnIndex(fieldName);
            if (columnIndex == -1L) {
                throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
            }
            columnIndices[i] = columnIndex;
        }
        TableView tableView = table.getSortedView(columnIndices, sortAscending);
        return new RealmResults<E>(this, tableView, clazz);
    }

    public void addChangeListener(RealmChangeListener listener) {
        this.checkIfValid();
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(RealmChangeListener listener) {
        this.checkIfValid();
        this.changeListeners.remove(listener);
    }

    public void removeAllChangeListeners() {
        this.checkIfValid();
        this.changeListeners.clear();
    }

    void sendNotifications() {
        ArrayList<RealmChangeListener> defensiveCopy = new ArrayList<RealmChangeListener>(this.changeListeners);
        for (RealmChangeListener listener : defensiveCopy) {
            listener.onChange();
        }
    }

    boolean hasChanged() {
        return this.sharedGroup.hasChanged();
    }

    public void refresh() {
        this.checkIfValid();
        this.transaction.advanceRead();
    }

    public void beginTransaction() {
        this.checkIfValid();
        this.transaction.promoteToWrite();
    }

    public void commitTransaction() {
        this.checkIfValid();
        this.transaction.commitAndContinueAsRead();
        for (Map.Entry<Handler, Integer> handlerIntegerEntry : handlers.entrySet()) {
            Handler handler = handlerIntegerEntry.getKey();
            int realmId = handlerIntegerEntry.getValue();
            if (realmId != this.id || handler.hasMessages(14930352) || !handler.getLooper().getThread().isAlive() || handler.equals(this.handler)) continue;
            handler.sendEmptyMessage(14930352);
        }
        this.sendNotifications();
    }

    public void cancelTransaction() {
        this.checkIfValid();
        this.transaction.rollbackAndContinueAsRead();
    }

    public void executeTransaction(Transaction transaction) {
        if (transaction == null) {
            return;
        }
        this.beginTransaction();
        try {
            transaction.execute(this);
            this.commitTransaction();
        }
        catch (RuntimeException e) {
            this.cancelTransaction();
            throw new RealmException("Error during transaction.", e);
        }
        catch (Error e) {
            this.cancelTransaction();
            throw e;
        }
    }

    public void clear(Class<?> classSpec) {
        this.getTable(classSpec).clear();
    }

    int getId() {
        return this.id;
    }

    Handler getHandler() {
        for (Map.Entry<Handler, Integer> entry : handlers.entrySet()) {
            if (entry.getValue() != this.id) continue;
            return entry.getKey();
        }
        return null;
    }

    long getVersion() {
        if (!this.transaction.hasTable("metadata")) {
            return -1L;
        }
        Table metadataTable = this.transaction.getTable("metadata");
        return metadataTable.getLong(0L, 0L);
    }

    void setVersion(long version) {
        Table metadataTable = this.transaction.getTable("metadata");
        if (metadataTable.getColumnCount() == 0L) {
            metadataTable.addColumn(ColumnType.INTEGER, "version");
            metadataTable.addEmptyRow();
        }
        metadataTable.setLong(0L, 0L, version);
    }

    private <E extends RealmObject> Class<? extends RealmObject> getRealmClassFromObject(E object) {
        if (object.realm != null) {
            return object.getClass().getSuperclass();
        }
        return object.getClass();
    }

    private <E extends RealmObject> E copyOrUpdate(E object, boolean update) {
        Class<RealmObject> realmClass = this.getRealmClassFromObject(object);
        Class<?> proxyClass = this.getProxyClass(realmClass);
        Method method = this.insertOrUpdateMethods.get(realmClass);
        if (method == null) {
            try {
                method = proxyClass.getMethod("copyOrUpdate", Realm.class, realmClass, Boolean.TYPE, Map.class);
            }
            catch (NoSuchMethodException e) {
                throw new RealmException("Could not find the copyOrUpdate() method in generated proxy class for " + proxyClass.getName() + ": " + APT_NOT_EXECUTED_MESSAGE, e);
            }
            this.insertOrUpdateMethods.put(proxyClass, method);
        }
        try {
            Object result = method.invoke(null, this, object, update, new HashMap());
            return (E)((RealmObject)result);
        }
        catch (IllegalAccessException e) {
            throw new RealmException("Could not execute the copyToRealm method : Annotation processor may not have been executed.", e);
        }
        catch (InvocationTargetException e) {
            throw new RealmException("An exception was thrown in the copyToRealm method in the proxy class  " + proxyClass.getName() + ": " + APT_NOT_EXECUTED_MESSAGE, e);
        }
    }

    private <E extends RealmObject> void checkNotNullObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Null objects cannot be copied into Realm.");
        }
    }

    private <E extends RealmObject> void checkHasPrimaryKey(E object) {
        Class<?> objectClass = object.getClass();
        if (!this.getTable(objectClass).hasPrimaryKey()) {
            throw new IllegalArgumentException("RealmObject has no @PrimaryKey defined: " + this.getClassSimpleName(objectClass));
        }
    }

    private <E extends RealmObject> void checkHasPrimaryKey(Class<E> clazz) {
        if (!this.getTable(clazz).hasPrimaryKey()) {
            throw new IllegalArgumentException("A RealmObject with no @PrimaryKey cannot be updated: " + clazz.toString());
        }
    }

    public static void migrateRealmAtPath(String realmPath, RealmMigration migration) {
        Realm.migrateRealmAtPath(realmPath, null, migration, true);
    }

    public static void migrateRealmAtPath(String realmPath, byte[] key, RealmMigration migration) {
        Realm.migrateRealmAtPath(realmPath, key, migration, true);
    }

    public static void migrateRealmAtPath(String realmPath, RealmMigration migration, boolean autoRefresh) {
        Realm.migrateRealmAtPath(realmPath, null, migration, autoRefresh);
    }

    public static synchronized void migrateRealmAtPath(String realmPath, byte[] key, RealmMigration migration, boolean autoUpdate) {
        Realm realm = Realm.createAndValidate(realmPath, key, false, autoUpdate);
        realm.beginTransaction();
        realm.setVersion(migration.execute(realm, realm.getVersion()));
        realm.commitTransaction();
        realm.close();
        realmsCache.remove();
    }

    public static boolean deleteRealmFile(Context context) {
        return Realm.deleteRealmFile(context, DEFAULT_REALM_NAME);
    }

    public static boolean deleteRealmFile(Context context, String fileName) {
        return Realm.deleteRealmFile(new File(context.getFilesDir(), fileName));
    }

    public static synchronized boolean deleteRealmFile(File realmFile) {
        boolean result = true;
        File realmFolder = realmFile.getParentFile();
        String fileName = realmFile.getName();
        int realmId = realmFile.getAbsolutePath().hashCode();
        AtomicInteger counter = openRealms.get(realmId);
        if (counter != null && counter.get() > 0) {
            throw new IllegalStateException("It's not allowed to delete the file associated with an open Realm. Remember to close() all the instances of the Realm before deleting its file.");
        }
        List<File> filesToDelete = Arrays.asList(realmFile, new File(realmFolder, fileName + ".lock"), new File(realmFolder, fileName + ".lock_a"), new File(realmFolder, fileName + ".lock_b"), new File(realmFolder, fileName + ".log"));
        for (File fileToDelete : filesToDelete) {
            boolean deleteResult;
            if (!fileToDelete.exists() || (deleteResult = fileToDelete.delete())) continue;
            result = false;
            RealmLog.w("Could not delete the file " + fileToDelete);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean compactRealmFile(Context context, String fileName, byte[] key) {
        if (key != null) {
            throw new IllegalArgumentException("Cannot currently compact an encrypted Realm.");
        }
        File realmFile = new File(context.getFilesDir(), fileName);
        String path = realmFile.getAbsolutePath();
        if (openRealms.get(path.hashCode()).get() > 0) {
            throw new IllegalStateException("Cannot compact an open Realm");
        }
        SharedGroup sharedGroup = null;
        boolean result = false;
        try {
            sharedGroup = new SharedGroup(path, false, key);
            result = sharedGroup.compact();
        }
        finally {
            if (sharedGroup != null) {
                sharedGroup.close();
            }
        }
        return result;
    }

    public static boolean compactRealmFile(Context context) {
        return Realm.compactRealmFile(context, DEFAULT_REALM_NAME, null);
    }

    public static synchronized boolean compactRealmFile(Context context, String fileName) {
        return Realm.compactRealmFile(context, fileName, null);
    }

    public String getPath() {
        return this.path;
    }

    @SafeVarargs
    static void setSchema(Class<? extends RealmObject> ... schemaClass) {
        customSchema.clear();
        if (schemaClass != null) {
            Collections.addAll(customSchema, schemaClass);
        }
    }

    private String getClassSimpleName(Class<?> clazz) {
        String simpleName = this.simpleClassNames.get(clazz);
        if (simpleName == null) {
            simpleName = clazz.getSimpleName();
            this.simpleClassNames.put(clazz, simpleName);
        }
        return simpleName;
    }

    static {
        RealmLog.add(new ReleaseAndroidLogger());
    }

    public static interface Transaction {
        public void execute(Realm var1);
    }

    private class RealmCallback
    implements Handler.Callback {
        private RealmCallback() {
        }

        public boolean handleMessage(Message message) {
            if (message.what == 14930352) {
                Realm.this.transaction.advanceRead();
                Realm.this.sendNotifications();
            }
            return true;
        }
    }
}

