/*
 * Decompiled with CFR 0.152.
 */
package io.realm.log;

import io.realm.internal.Keep;
import io.realm.internal.Util;
import io.realm.log.Logger;
import java.util.ArrayList;
import java.util.List;

@Keep
public final class RealmLog {
    private static final Logger[] NO_LOGGERS = new Logger[0];
    private static final List<Logger> LOGGERS = new ArrayList<Logger>();
    private static volatile Logger[] loggersAsArray = NO_LOGGERS;
    private static int minimumNativeLogLevel = Integer.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("A non-null logger has to be provided");
        }
        List<Logger> list = LOGGERS;
        synchronized (list) {
            LOGGERS.add(logger);
            int minimumLogLevel = logger.getMinimumNativeDebugLevel();
            if (minimumLogLevel < minimumNativeLogLevel) {
                RealmLog.setMinimumNativeDebugLevel(minimumLogLevel);
            }
            loggersAsArray = LOGGERS.toArray(new Logger[LOGGERS.size()]);
        }
    }

    private static void setMinimumNativeDebugLevel(int nativeDebugLevel) {
        minimumNativeLogLevel = nativeDebugLevel;
        Util.setDebugLevel(nativeDebugLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean remove(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("A non-null logger has to be provided");
        }
        List<Logger> list = LOGGERS;
        synchronized (list) {
            LOGGERS.remove(logger);
            int newMinLevel = Integer.MAX_VALUE;
            for (int i = 0; i < LOGGERS.size(); ++i) {
                int logMin = LOGGERS.get(i).getMinimumNativeDebugLevel();
                if (logMin >= newMinLevel) continue;
                newMinLevel = logMin;
            }
            RealmLog.setMinimumNativeDebugLevel(newMinLevel);
            loggersAsArray = LOGGERS.toArray(new Logger[LOGGERS.size()]);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        List<Logger> list = LOGGERS;
        synchronized (list) {
            LOGGERS.clear();
            RealmLog.setMinimumNativeDebugLevel(Integer.MAX_VALUE);
            loggersAsArray = NO_LOGGERS;
        }
    }

    public static void trace(Throwable throwable) {
        RealmLog.trace(throwable, null, new Object[0]);
    }

    public static void trace(String message, Object ... args) {
        RealmLog.trace(null, message, args);
    }

    public static void trace(Throwable throwable, String message, Object ... args) {
        Logger[] loggers = loggersAsArray;
        for (int i = 0; i < loggers.length; ++i) {
            loggers[i].trace(throwable, message, args);
        }
    }

    public static void debug(Throwable throwable) {
        RealmLog.debug(throwable, null, new Object[0]);
    }

    public static void debug(String message, Object ... args) {
        RealmLog.debug(null, message, args);
    }

    public static void debug(Throwable throwable, String message, Object ... args) {
        Logger[] loggers = loggersAsArray;
        for (int i = 0; i < loggers.length; ++i) {
            loggers[i].debug(throwable, message, args);
        }
    }

    public static void info(Throwable throwable) {
        RealmLog.info(throwable, null, new Object[0]);
    }

    public static void info(String message, Object ... args) {
        RealmLog.info(null, message, args);
    }

    public static void info(Throwable throwable, String message, Object ... args) {
        Logger[] loggers = loggersAsArray;
        for (int i = 0; i < loggers.length; ++i) {
            loggers[i].info(throwable, message, args);
        }
    }

    public static void warn(Throwable throwable) {
        RealmLog.warn(throwable, null, new Object[0]);
    }

    public static void warn(String message, Object ... args) {
        RealmLog.warn(null, message, args);
    }

    public static void warn(Throwable throwable, String message, Object ... args) {
        Logger[] loggers = loggersAsArray;
        for (int i = 0; i < loggers.length; ++i) {
            loggers[i].warn(throwable, message, args);
        }
    }

    public static void error(Throwable throwable) {
        RealmLog.error(throwable, null, new Object[0]);
    }

    public static void error(String message, Object ... args) {
        RealmLog.error(null, message, args);
    }

    public static void error(Throwable throwable, String message, Object ... args) {
        Logger[] loggers = loggersAsArray;
        for (int i = 0; i < loggers.length; ++i) {
            loggers[i].error(throwable, message, args);
        }
    }

    public static void fatal(Throwable throwable) {
        RealmLog.fatal(throwable, null, new Object[0]);
    }

    public static void fatal(String message, Object ... args) {
        RealmLog.fatal(null, message, args);
    }

    public static void fatal(Throwable throwable, String message, Object ... args) {
        Logger[] loggers = loggersAsArray;
        for (int i = 0; i < loggers.length; ++i) {
            loggers[i].fatal(throwable, message, args);
        }
    }
}

