/*
 * Decompiled with CFR 0.152.
 */
package io.realm.log;

import android.util.Log;
import io.realm.log.Logger;

public class AndroidLogger
implements Logger {
    private static final int LOG_ENTRY_MAX_LENGTH = 4000;
    private final int minimumLogLevel;
    private volatile String logTag = "REALM";

    public AndroidLogger(int androidLogLevel) {
        if (androidLogLevel < 2 || androidLogLevel > 7) {
            throw new IllegalArgumentException("Unknown android log level: " + androidLogLevel);
        }
        this.minimumLogLevel = androidLogLevel;
    }

    public void setTag(String tag) {
        this.logTag = tag;
    }

    @Override
    public int getMinimumNativeDebugLevel() {
        switch (this.minimumLogLevel) {
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
        }
        throw new IllegalStateException("Unknown log level: " + this.minimumLogLevel);
    }

    private void log(int androidLogLevel, Throwable t, String message, Object ... args) {
        if (androidLogLevel < this.minimumLogLevel) {
            return;
        }
        if (message == null) {
            if (t == null) {
                return;
            }
            message = Log.getStackTraceString((Throwable)t);
        } else {
            if (args != null && args.length > 0) {
                message = String.format(message, args);
            }
            if (t != null) {
                message = message + "\n" + Log.getStackTraceString((Throwable)t);
            }
        }
        if (message.length() < 4000) {
            Log.println((int)androidLogLevel, (String)this.logTag, (String)message);
            return;
        }
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = message.indexOf(10, i);
            newline = newline != -1 ? newline : length;
            do {
                end = Math.min(newline, i + 4000);
                String part = message.substring(i, end);
                Log.println((int)androidLogLevel, (String)this.logTag, (String)part);
            } while ((i = end) < newline);
        }
    }

    @Override
    public void trace(Throwable throwable, String message, Object ... args) {
        this.log(2, throwable, message, args);
    }

    @Override
    public void debug(Throwable throwable, String message, Object ... args) {
        this.log(3, throwable, message, args);
    }

    @Override
    public void info(Throwable throwable, String message, Object ... args) {
        this.log(4, throwable, message, args);
    }

    @Override
    public void warn(Throwable throwable, String message, Object ... args) {
        this.log(5, throwable, message, args);
    }

    @Override
    public void error(Throwable throwable, String message, Object ... args) {
        this.log(6, throwable, message, args);
    }

    @Override
    public void fatal(Throwable throwable, String message, Object ... args) {
        this.log(7, throwable, message, args);
    }
}

