/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import android.os.Build;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.log.RealmLog;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class Util {
    public static long getNativeMemUsage() {
        return Util.nativeGetMemUsage();
    }

    static native long nativeGetMemUsage();

    public static void setDebugLevel(int level) {
        Util.nativeSetDebugLevel(level);
    }

    static native void nativeSetDebugLevel(int var0);

    static void javaPrint(String txt) {
        System.out.print(txt);
    }

    public static String getTablePrefix() {
        return Util.nativeGetTablePrefix();
    }

    static native String nativeGetTablePrefix();

    public static Class<? extends RealmModel> getOriginalModelClass(Class<? extends RealmModel> clazz) {
        Class<? extends RealmModel> superclass = clazz.getSuperclass();
        if (!superclass.equals(Object.class) && !superclass.equals(RealmObject.class)) {
            clazz = superclass;
        }
        return clazz;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    public static boolean deleteRealm(String canonicalPath, File realmFolder, String realmFileName) {
        boolean realmDeleted = true;
        String management = ".management";
        File managementFolder = new File(realmFolder, realmFileName + ".management");
        File[] files = managementFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                realmDeleted = realmDeleted && file.delete();
            }
        }
        realmDeleted = realmDeleted && managementFolder.delete();
        return realmDeleted && Util.deletes(canonicalPath, realmFolder, realmFileName);
    }

    private static boolean deletes(String canonicalPath, File rootFolder, String realmFileName) {
        AtomicBoolean realmDeleted = new AtomicBoolean(true);
        List<File> filesToDelete = Arrays.asList(new File(rootFolder, realmFileName), new File(rootFolder, realmFileName + ".lock"), new File(rootFolder, realmFileName + ".log_a"), new File(rootFolder, realmFileName + ".log_b"), new File(rootFolder, realmFileName + ".log"), new File(canonicalPath));
        for (File fileToDelete : filesToDelete) {
            boolean deleteResult;
            if (!fileToDelete.exists() || (deleteResult = fileToDelete.delete())) continue;
            realmDeleted.set(false);
            RealmLog.warn("Could not delete the file %s", fileToDelete);
        }
        return realmDeleted.get();
    }
}

