/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.internal.CheckedRow;
import io.realm.internal.Context;
import io.realm.internal.LinkView;
import io.realm.internal.NativeObject;
import io.realm.internal.Row;
import io.realm.internal.Table;
import java.util.Date;

public class UncheckedRow
extends NativeObject
implements Row {
    final Context context;
    final Table parent;

    protected UncheckedRow(Context context, Table parent, long nativePtr) {
        this.context = context;
        this.parent = parent;
        this.nativePointer = nativePtr;
        context.executeDelayedDisposal();
    }

    public static UncheckedRow getByRowIndex(Context context, Table table, long index) {
        long nativeRowPointer = table.nativeGetRowPtr(table.nativePtr, index);
        UncheckedRow row = new UncheckedRow(context, table, nativeRowPointer);
        context.addReference(1, row);
        return row;
    }

    public static UncheckedRow getByRowPointer(Context context, Table table, long nativeRowPointer) {
        UncheckedRow row = new UncheckedRow(context, table, nativeRowPointer);
        context.addReference(1, row);
        return row;
    }

    public static UncheckedRow getByRowIndex(Context context, LinkView linkView, long index) {
        long nativeRowPointer = linkView.nativeGetRow(linkView.nativePointer, index);
        UncheckedRow row = new UncheckedRow(context, linkView.getTargetTable(), nativeRowPointer);
        context.addReference(1, row);
        return row;
    }

    @Override
    public long getColumnCount() {
        return this.nativeGetColumnCount(this.nativePointer);
    }

    @Override
    public String getColumnName(long columnIndex) {
        return this.nativeGetColumnName(this.nativePointer, columnIndex);
    }

    @Override
    public long getColumnIndex(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name can not be null.");
        }
        return this.nativeGetColumnIndex(this.nativePointer, columnName);
    }

    @Override
    public RealmFieldType getColumnType(long columnIndex) {
        return RealmFieldType.fromNativeValue(this.nativeGetColumnType(this.nativePointer, columnIndex));
    }

    @Override
    public Table getTable() {
        return this.parent;
    }

    @Override
    public long getIndex() {
        return this.nativeGetIndex(this.nativePointer);
    }

    @Override
    public long getLong(long columnIndex) {
        return this.nativeGetLong(this.nativePointer, columnIndex);
    }

    @Override
    public boolean getBoolean(long columnIndex) {
        return this.nativeGetBoolean(this.nativePointer, columnIndex);
    }

    @Override
    public float getFloat(long columnIndex) {
        return this.nativeGetFloat(this.nativePointer, columnIndex);
    }

    @Override
    public double getDouble(long columnIndex) {
        return this.nativeGetDouble(this.nativePointer, columnIndex);
    }

    @Override
    public Date getDate(long columnIndex) {
        return new Date(this.nativeGetTimestamp(this.nativePointer, columnIndex));
    }

    @Override
    public String getString(long columnIndex) {
        return this.nativeGetString(this.nativePointer, columnIndex);
    }

    @Override
    public byte[] getBinaryByteArray(long columnIndex) {
        return this.nativeGetByteArray(this.nativePointer, columnIndex);
    }

    @Override
    public long getLink(long columnIndex) {
        return this.nativeGetLink(this.nativePointer, columnIndex);
    }

    @Override
    public boolean isNullLink(long columnIndex) {
        return this.nativeIsNullLink(this.nativePointer, columnIndex);
    }

    @Override
    public LinkView getLinkList(long columnIndex) {
        long nativeLinkViewPtr = this.nativeGetLinkView(this.nativePointer, columnIndex);
        return new LinkView(this.context, this.parent, columnIndex, nativeLinkViewPtr);
    }

    @Override
    public void setLong(long columnIndex, long value) {
        this.parent.checkImmutable();
        this.getTable().checkIntValueIsLegal(columnIndex, this.getIndex(), value);
        this.nativeSetLong(this.nativePointer, columnIndex, value);
    }

    @Override
    public void setBoolean(long columnIndex, boolean value) {
        this.parent.checkImmutable();
        this.nativeSetBoolean(this.nativePointer, columnIndex, value);
    }

    @Override
    public void setFloat(long columnIndex, float value) {
        this.parent.checkImmutable();
        this.nativeSetFloat(this.nativePointer, columnIndex, value);
    }

    @Override
    public void setDouble(long columnIndex, double value) {
        this.parent.checkImmutable();
        this.nativeSetDouble(this.nativePointer, columnIndex, value);
    }

    @Override
    public void setDate(long columnIndex, Date date) {
        this.parent.checkImmutable();
        if (date == null) {
            throw new IllegalArgumentException("Null Date is not allowed.");
        }
        long timestamp = date.getTime();
        this.nativeSetTimestamp(this.nativePointer, columnIndex, timestamp);
    }

    @Override
    public void setString(long columnIndex, String value) {
        this.parent.checkImmutable();
        if (value == null) {
            this.getTable().checkDuplicatedNullForPrimaryKeyValue(columnIndex, this.getIndex());
            this.nativeSetNull(this.nativePointer, columnIndex);
        } else {
            this.getTable().checkStringValueIsLegal(columnIndex, this.getIndex(), value);
            this.nativeSetString(this.nativePointer, columnIndex, value);
        }
    }

    @Override
    public void setBinaryByteArray(long columnIndex, byte[] data) {
        this.parent.checkImmutable();
        this.nativeSetByteArray(this.nativePointer, columnIndex, data);
    }

    @Override
    public void setLink(long columnIndex, long value) {
        this.parent.checkImmutable();
        this.nativeSetLink(this.nativePointer, columnIndex, value);
    }

    @Override
    public void nullifyLink(long columnIndex) {
        this.parent.checkImmutable();
        this.nativeNullifyLink(this.nativePointer, columnIndex);
    }

    @Override
    public boolean isNull(long columnIndex) {
        return this.nativeIsNull(this.nativePointer, columnIndex);
    }

    @Override
    public void setNull(long columnIndex) {
        this.parent.checkImmutable();
        this.getTable().checkDuplicatedNullForPrimaryKeyValue(columnIndex, this.getIndex());
        this.nativeSetNull(this.nativePointer, columnIndex);
    }

    public CheckedRow convertToChecked() {
        return CheckedRow.getFromRow(this);
    }

    @Override
    public boolean isAttached() {
        return this.nativePointer != 0L && this.nativeIsAttached(this.nativePointer);
    }

    @Override
    public boolean hasColumn(String fieldName) {
        return this.nativeHasColumn(this.nativePointer, fieldName);
    }

    protected native long nativeGetColumnCount(long var1);

    protected native String nativeGetColumnName(long var1, long var3);

    protected native long nativeGetColumnIndex(long var1, String var3);

    protected native int nativeGetColumnType(long var1, long var3);

    protected native long nativeGetIndex(long var1);

    protected native long nativeGetLong(long var1, long var3);

    protected native boolean nativeGetBoolean(long var1, long var3);

    protected native float nativeGetFloat(long var1, long var3);

    protected native double nativeGetDouble(long var1, long var3);

    protected native long nativeGetTimestamp(long var1, long var3);

    protected native String nativeGetString(long var1, long var3);

    protected native boolean nativeIsNullLink(long var1, long var3);

    protected native byte[] nativeGetByteArray(long var1, long var3);

    protected native long nativeGetLinkView(long var1, long var3);

    protected native void nativeSetLong(long var1, long var3, long var5);

    protected native void nativeSetBoolean(long var1, long var3, boolean var5);

    protected native void nativeSetFloat(long var1, long var3, float var5);

    protected native long nativeGetLink(long var1, long var3);

    protected native void nativeSetDouble(long var1, long var3, double var5);

    protected native void nativeSetTimestamp(long var1, long var3, long var5);

    protected native void nativeSetString(long var1, long var3, String var5);

    protected native void nativeSetByteArray(long var1, long var3, byte[] var5);

    protected native void nativeSetLink(long var1, long var3, long var5);

    protected native void nativeNullifyLink(long var1, long var3);

    static native void nativeClose(long var0);

    protected native boolean nativeIsAttached(long var1);

    protected native boolean nativeHasColumn(long var1, String var3);

    protected native boolean nativeIsNull(long var1, long var3);

    protected native void nativeSetNull(long var1, long var3);
}

