/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.exceptions.RealmException;
import io.realm.exceptions.RealmPrimaryKeyConstraintException;
import io.realm.internal.CheckedRow;
import io.realm.internal.Context;
import io.realm.internal.SharedRealm;
import io.realm.internal.TableOrView;
import io.realm.internal.TableQuery;
import io.realm.internal.TableSchema;
import io.realm.internal.TableView;
import io.realm.internal.UncheckedRow;
import io.realm.internal.Util;
import java.util.Date;

public class Table
implements TableOrView,
TableSchema {
    public static final int TABLE_MAX_LENGTH = 56;
    public static final String TABLE_PREFIX = Util.getTablePrefix();
    public static final long INFINITE = -1L;
    public static final boolean NULLABLE = true;
    public static final boolean NOT_NULLABLE = false;
    private static final String PRIMARY_KEY_TABLE_NAME = "pk";
    private static final String PRIMARY_KEY_CLASS_COLUMN_NAME = "pk_table";
    private static final long PRIMARY_KEY_CLASS_COLUMN_INDEX = 0L;
    private static final String PRIMARY_KEY_FIELD_COLUMN_NAME = "pk_property";
    private static final long PRIMARY_KEY_FIELD_COLUMN_INDEX = 1L;
    private static final long NO_PRIMARY_KEY = -2L;
    long nativePtr;
    private final Context context;
    private final SharedRealm sharedRealm;
    private long cachedPrimaryKeyColumnIndex = -1L;

    public Table() {
        this.context = new Context();
        this.nativePtr = this.createNative();
        if (this.nativePtr == 0L) {
            throw new OutOfMemoryError("Out of native memory.");
        }
        this.sharedRealm = null;
    }

    Table(Table parent, long nativePointer) {
        this(parent.sharedRealm, nativePointer);
    }

    Table(SharedRealm sharedRealm, long nativePointer) {
        this.context = sharedRealm.context;
        this.sharedRealm = sharedRealm;
        this.nativePtr = nativePointer;
    }

    @Override
    public Table getTable() {
        return this;
    }

    public long getNativeTablePointer() {
        return this.nativePtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                this.context.asyncDisposeTable(this.nativePtr, this.sharedRealm == null);
                this.nativePtr = 0L;
            }
        }
        super.finalize();
    }

    public boolean isValid() {
        return this.nativePtr != 0L && this.nativeIsValid(this.nativePtr);
    }

    private void verifyColumnName(String name) {
        if (name.length() > 63) {
            throw new IllegalArgumentException("Column names are currently limited to max 63 characters.");
        }
    }

    public long addColumn(RealmFieldType type, String name, boolean isNullable) {
        this.verifyColumnName(name);
        return this.nativeAddColumn(this.nativePtr, type.getNativeValue(), name, isNullable);
    }

    @Override
    public long addColumn(RealmFieldType type, String name) {
        return this.addColumn(type, name, false);
    }

    public long addColumnLink(RealmFieldType type, String name, Table table) {
        this.verifyColumnName(name);
        return this.nativeAddColumnLink(this.nativePtr, type.getNativeValue(), name, table.nativePtr);
    }

    @Override
    public void removeColumn(long columnIndex) {
        long oldPkColumnIndex = this.getPrimaryKey();
        this.nativeRemoveColumn(this.nativePtr, columnIndex);
        if (oldPkColumnIndex >= 0L) {
            if (oldPkColumnIndex == columnIndex) {
                this.setPrimaryKey(null);
            } else if (oldPkColumnIndex > columnIndex) {
                this.invalidateCachedPrimaryKeyIndex();
            }
        }
    }

    @Override
    public void renameColumn(long columnIndex, String newName) {
        this.verifyColumnName(newName);
        String oldName = this.nativeGetColumnName(this.nativePtr, columnIndex);
        long oldPkColumnIndex = this.getPrimaryKey();
        this.nativeRenameColumn(this.nativePtr, columnIndex, newName);
        if (oldPkColumnIndex == columnIndex) {
            try {
                String className = Table.tableNameToClassName(this.getName());
                Table pkTable = this.getPrimaryKeyTable();
                if (pkTable == null) {
                    throw new IllegalStateException("Table is not created from a SharedRealm, primary key is not available");
                }
                long pkRowIndex = pkTable.findFirstString(0L, className);
                if (pkRowIndex == -1L) {
                    throw new IllegalStateException("Non-existent PrimaryKey column cannot be renamed");
                }
                Table.nativeSetString(pkTable.nativePtr, 1L, pkRowIndex, newName, false);
            }
            catch (Exception e) {
                this.nativeRenameColumn(this.nativePtr, columnIndex, oldName);
                throw e;
            }
        }
    }

    public boolean isColumnNullable(long columnIndex) {
        return this.nativeIsColumnNullable(this.nativePtr, columnIndex);
    }

    public void convertColumnToNullable(long columnIndex) {
        this.nativeConvertColumnToNullable(this.nativePtr, columnIndex);
    }

    public void convertColumnToNotNullable(long columnIndex) {
        this.nativeConvertColumnToNotNullable(this.nativePtr, columnIndex);
    }

    @Override
    public long size() {
        return this.nativeSize(this.nativePtr);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public void clear() {
        this.checkImmutable();
        this.nativeClear(this.nativePtr);
    }

    @Override
    public long getColumnCount() {
        return this.nativeGetColumnCount(this.nativePtr);
    }

    @Override
    public String getColumnName(long columnIndex) {
        return this.nativeGetColumnName(this.nativePtr, columnIndex);
    }

    @Override
    public long getColumnIndex(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name can not be null.");
        }
        return this.nativeGetColumnIndex(this.nativePtr, columnName);
    }

    @Override
    public RealmFieldType getColumnType(long columnIndex) {
        return RealmFieldType.fromNativeValue(this.nativeGetColumnType(this.nativePtr, columnIndex));
    }

    @Override
    public void remove(long rowIndex) {
        this.checkImmutable();
        this.nativeRemove(this.nativePtr, rowIndex);
    }

    @Override
    public void removeFirst() {
        this.checkImmutable();
        this.remove(0L);
    }

    @Override
    public void removeLast() {
        this.checkImmutable();
        this.nativeRemoveLast(this.nativePtr);
    }

    public void moveLastOver(long rowIndex) {
        this.checkImmutable();
        this.nativeMoveLastOver(this.nativePtr, rowIndex);
    }

    public long addEmptyRow() {
        this.checkImmutable();
        return Table.nativeAddEmptyRow(this.nativePtr, 1L);
    }

    public long addEmptyRowWithPrimaryKey(Object primaryKeyValue) {
        return this.addEmptyRowWithPrimaryKey(primaryKeyValue, true);
    }

    public long addEmptyRowWithPrimaryKey(Object primaryKeyValue, boolean validation) {
        long rowIndex;
        block17: {
            RealmFieldType type;
            long primaryKeyColumnIndex;
            block16: {
                if (validation) {
                    this.checkImmutable();
                    this.checkHasPrimaryKey();
                }
                primaryKeyColumnIndex = this.getPrimaryKey();
                type = this.getColumnType(primaryKeyColumnIndex);
                if (primaryKeyValue != null) break block16;
                switch (type) {
                    case STRING: 
                    case INTEGER: {
                        if (validation && this.findFirstNull(primaryKeyColumnIndex) != -1L) {
                            Table.throwDuplicatePrimaryKeyException("null");
                        }
                        rowIndex = Table.nativeAddEmptyRow(this.nativePtr, 1L);
                        if (type == RealmFieldType.STRING) {
                            Table.nativeSetStringUnique(this.nativePtr, primaryKeyColumnIndex, rowIndex, null);
                        } else {
                            Table.nativeSetNullUnique(this.nativePtr, primaryKeyColumnIndex, rowIndex);
                        }
                        break block17;
                    }
                    default: {
                        throw new RealmException("Cannot check for duplicate rows for unsupported primary key type: " + (Object)((Object)type));
                    }
                }
            }
            switch (type) {
                case STRING: {
                    if (!(primaryKeyValue instanceof String)) {
                        throw new IllegalArgumentException("Primary key value is not a String: " + primaryKeyValue);
                    }
                    if (validation && this.findFirstString(primaryKeyColumnIndex, (String)primaryKeyValue) != -1L) {
                        Table.throwDuplicatePrimaryKeyException(primaryKeyValue);
                    }
                    rowIndex = Table.nativeAddEmptyRow(this.nativePtr, 1L);
                    Table.nativeSetStringUnique(this.nativePtr, primaryKeyColumnIndex, rowIndex, (String)primaryKeyValue);
                    break;
                }
                case INTEGER: {
                    long pkValue;
                    try {
                        pkValue = Long.parseLong(primaryKeyValue.toString());
                    }
                    catch (RuntimeException e) {
                        throw new IllegalArgumentException("Primary key value is not a long: " + primaryKeyValue);
                    }
                    if (validation && this.findFirstLong(primaryKeyColumnIndex, pkValue) != -1L) {
                        Table.throwDuplicatePrimaryKeyException(pkValue);
                    }
                    rowIndex = Table.nativeAddEmptyRow(this.nativePtr, 1L);
                    Table.nativeSetLongUnique(this.nativePtr, primaryKeyColumnIndex, rowIndex, pkValue);
                    break;
                }
                default: {
                    throw new RealmException("Cannot check for duplicate rows for unsupported primary key type: " + (Object)((Object)type));
                }
            }
        }
        return rowIndex;
    }

    public long addEmptyRows(long rows) {
        this.checkImmutable();
        if (rows < 1L) {
            throw new IllegalArgumentException("'rows' must be > 0.");
        }
        if (this.hasPrimaryKey()) {
            if (rows > 1L) {
                throw new RealmException("Multiple empty rows cannot be created if a primary key is defined for the table.");
            }
            return this.addEmptyRow();
        }
        return Table.nativeAddEmptyRow(this.nativePtr, rows);
    }

    protected long add(Object ... values) {
        long rowIndex = this.addEmptyRow();
        this.checkImmutable();
        int columns = (int)this.getColumnCount();
        if (columns != values.length) {
            throw new IllegalArgumentException("The number of value parameters (" + String.valueOf(values.length) + ") does not match the number of columns in the table (" + String.valueOf(columns) + ").");
        }
        RealmFieldType[] colTypes = new RealmFieldType[columns];
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            RealmFieldType colType;
            Object value = values[columnIndex];
            colTypes[columnIndex] = colType = this.getColumnType(columnIndex);
            if (colType.isValid(value)) continue;
            String providedType = value == null ? "null" : value.getClass().toString();
            throw new IllegalArgumentException("Invalid argument no " + String.valueOf(1 + columnIndex) + ". Expected a value compatible with column type " + (Object)((Object)colType) + ", but got " + providedType + ".");
        }
        block10: for (long columnIndex = 0L; columnIndex < (long)columns; ++columnIndex) {
            Object value = values[(int)columnIndex];
            switch (colTypes[(int)columnIndex]) {
                case BOOLEAN: {
                    Table.nativeSetBoolean(this.nativePtr, columnIndex, rowIndex, (Boolean)value, false);
                    continue block10;
                }
                case INTEGER: {
                    if (value == null) {
                        this.checkDuplicatedNullForPrimaryKeyValue(columnIndex, rowIndex);
                        Table.nativeSetNull(this.nativePtr, columnIndex, rowIndex, false);
                        continue block10;
                    }
                    long intValue = ((Number)value).longValue();
                    this.checkIntValueIsLegal(columnIndex, rowIndex, intValue);
                    Table.nativeSetLong(this.nativePtr, columnIndex, rowIndex, intValue, false);
                    continue block10;
                }
                case FLOAT: {
                    Table.nativeSetFloat(this.nativePtr, columnIndex, rowIndex, ((Float)value).floatValue(), false);
                    continue block10;
                }
                case DOUBLE: {
                    Table.nativeSetDouble(this.nativePtr, columnIndex, rowIndex, (Double)value, false);
                    continue block10;
                }
                case STRING: {
                    if (value == null) {
                        this.checkDuplicatedNullForPrimaryKeyValue(columnIndex, rowIndex);
                        Table.nativeSetNull(this.nativePtr, columnIndex, rowIndex, false);
                        continue block10;
                    }
                    String stringValue = (String)value;
                    this.checkStringValueIsLegal(columnIndex, rowIndex, stringValue);
                    Table.nativeSetString(this.nativePtr, columnIndex, rowIndex, (String)value, false);
                    continue block10;
                }
                case DATE: {
                    if (value == null) {
                        throw new IllegalArgumentException("Null Date is not allowed.");
                    }
                    Table.nativeSetTimestamp(this.nativePtr, columnIndex, rowIndex, ((Date)value).getTime(), false);
                    continue block10;
                }
                case BINARY: {
                    if (value == null) {
                        throw new IllegalArgumentException("Null Array is not allowed");
                    }
                    Table.nativeSetByteArray(this.nativePtr, columnIndex, rowIndex, (byte[])value, false);
                    continue block10;
                }
                default: {
                    throw new RuntimeException("Unexpected columnType: " + String.valueOf((Object)colTypes[(int)columnIndex]));
                }
            }
        }
        return rowIndex;
    }

    private boolean isPrimaryKeyColumn(long columnIndex) {
        return columnIndex == this.getPrimaryKey();
    }

    public long getPrimaryKey() {
        if (this.cachedPrimaryKeyColumnIndex >= 0L || this.cachedPrimaryKeyColumnIndex == -2L) {
            return this.cachedPrimaryKeyColumnIndex;
        }
        Table pkTable = this.getPrimaryKeyTable();
        if (pkTable == null) {
            return -2L;
        }
        String className = Table.tableNameToClassName(this.getName());
        long rowIndex = pkTable.findFirstString(0L, className);
        if (rowIndex != -1L) {
            String pkColumnName = pkTable.getUncheckedRow(rowIndex).getString(1L);
            this.cachedPrimaryKeyColumnIndex = this.getColumnIndex(pkColumnName);
        } else {
            this.cachedPrimaryKeyColumnIndex = -2L;
        }
        return this.cachedPrimaryKeyColumnIndex;
    }

    private boolean isPrimaryKey(long columnIndex) {
        return columnIndex >= 0L && columnIndex == this.getPrimaryKey();
    }

    public boolean hasPrimaryKey() {
        return this.getPrimaryKey() >= 0L;
    }

    void checkStringValueIsLegal(long columnIndex, long rowToUpdate, String value) {
        long rowIndex;
        if (this.isPrimaryKey(columnIndex) && (rowIndex = this.findFirstString(columnIndex, value)) != rowToUpdate && rowIndex != -1L) {
            Table.throwDuplicatePrimaryKeyException(value);
        }
    }

    void checkIntValueIsLegal(long columnIndex, long rowToUpdate, long value) {
        long rowIndex;
        if (this.isPrimaryKeyColumn(columnIndex) && (rowIndex = this.findFirstLong(columnIndex, value)) != rowToUpdate && rowIndex != -1L) {
            Table.throwDuplicatePrimaryKeyException(value);
        }
    }

    void checkDuplicatedNullForPrimaryKeyValue(long columnIndex, long rowToUpdate) {
        if (this.isPrimaryKeyColumn(columnIndex)) {
            RealmFieldType type = this.getColumnType(columnIndex);
            switch (type) {
                case STRING: 
                case INTEGER: {
                    long rowIndex = this.findFirstNull(columnIndex);
                    if (rowIndex == rowToUpdate || rowIndex == -1L) break;
                    Table.throwDuplicatePrimaryKeyException("null");
                    break;
                }
            }
        }
    }

    public static void throwDuplicatePrimaryKeyException(Object value) {
        throw new RealmPrimaryKeyConstraintException("Value already exists: " + value);
    }

    @Override
    public long getLong(long columnIndex, long rowIndex) {
        return this.nativeGetLong(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public boolean getBoolean(long columnIndex, long rowIndex) {
        return this.nativeGetBoolean(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public float getFloat(long columnIndex, long rowIndex) {
        return this.nativeGetFloat(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public double getDouble(long columnIndex, long rowIndex) {
        return this.nativeGetDouble(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public Date getDate(long columnIndex, long rowIndex) {
        return new Date(this.nativeGetTimestamp(this.nativePtr, columnIndex, rowIndex));
    }

    @Override
    public String getString(long columnIndex, long rowIndex) {
        return this.nativeGetString(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public byte[] getBinaryByteArray(long columnIndex, long rowIndex) {
        return this.nativeGetByteArray(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public long getLink(long columnIndex, long rowIndex) {
        return this.nativeGetLink(this.nativePtr, columnIndex, rowIndex);
    }

    public Table getLinkTarget(long columnIndex) {
        this.context.executeDelayedDisposal();
        long nativeTablePointer = this.nativeGetLinkTarget(this.nativePtr, columnIndex);
        try {
            return new Table(this.sharedRealm, nativeTablePointer);
        }
        catch (RuntimeException e) {
            Table.nativeClose(nativeTablePointer);
            throw e;
        }
    }

    @Override
    public boolean isNull(long columnIndex, long rowIndex) {
        return this.nativeIsNull(this.nativePtr, columnIndex, rowIndex);
    }

    public UncheckedRow getUncheckedRow(long index) {
        return UncheckedRow.getByRowIndex(this.context, this, index);
    }

    public UncheckedRow getUncheckedRowByPointer(long nativeRowPointer) {
        return UncheckedRow.getByRowPointer(this.context, this, nativeRowPointer);
    }

    public CheckedRow getCheckedRow(long index) {
        return CheckedRow.get(this.context, this, index);
    }

    @Override
    public void setLong(long columnIndex, long rowIndex, long value, boolean isDefault) {
        this.checkImmutable();
        this.checkIntValueIsLegal(columnIndex, rowIndex, value);
        Table.nativeSetLong(this.nativePtr, columnIndex, rowIndex, value, isDefault);
    }

    @Override
    public void setBoolean(long columnIndex, long rowIndex, boolean value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetBoolean(this.nativePtr, columnIndex, rowIndex, value, isDefault);
    }

    @Override
    public void setFloat(long columnIndex, long rowIndex, float value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetFloat(this.nativePtr, columnIndex, rowIndex, value, isDefault);
    }

    @Override
    public void setDouble(long columnIndex, long rowIndex, double value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetDouble(this.nativePtr, columnIndex, rowIndex, value, isDefault);
    }

    @Override
    public void setDate(long columnIndex, long rowIndex, Date date, boolean isDefault) {
        if (date == null) {
            throw new IllegalArgumentException("Null Date is not allowed.");
        }
        this.checkImmutable();
        Table.nativeSetTimestamp(this.nativePtr, columnIndex, rowIndex, date.getTime(), isDefault);
    }

    @Override
    public void setString(long columnIndex, long rowIndex, String value, boolean isDefault) {
        this.checkImmutable();
        if (value == null) {
            this.checkDuplicatedNullForPrimaryKeyValue(columnIndex, rowIndex);
            Table.nativeSetNull(this.nativePtr, columnIndex, rowIndex, isDefault);
        } else {
            this.checkStringValueIsLegal(columnIndex, rowIndex, value);
            Table.nativeSetString(this.nativePtr, columnIndex, rowIndex, value, isDefault);
        }
    }

    @Override
    public void setBinaryByteArray(long columnIndex, long rowIndex, byte[] data, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetByteArray(this.nativePtr, columnIndex, rowIndex, data, isDefault);
    }

    @Override
    public void setLink(long columnIndex, long rowIndex, long value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetLink(this.nativePtr, columnIndex, rowIndex, value, isDefault);
    }

    @Override
    public void setNull(long columnIndex, long rowIndex, boolean isDefault) {
        this.checkImmutable();
        this.checkDuplicatedNullForPrimaryKeyValue(columnIndex, rowIndex);
        Table.nativeSetNull(this.nativePtr, columnIndex, rowIndex, isDefault);
    }

    public void addSearchIndex(long columnIndex) {
        this.checkImmutable();
        this.nativeAddSearchIndex(this.nativePtr, columnIndex);
    }

    public void removeSearchIndex(long columnIndex) {
        this.checkImmutable();
        this.nativeRemoveSearchIndex(this.nativePtr, columnIndex);
    }

    public void setPrimaryKey(String columnName) {
        Table pkTable = this.getPrimaryKeyTable();
        if (pkTable == null) {
            throw new RealmException("Primary keys are only supported if Table is part of a Group");
        }
        this.cachedPrimaryKeyColumnIndex = this.nativeSetPrimaryKey(pkTable.nativePtr, this.nativePtr, columnName);
    }

    public void setPrimaryKey(long columnIndex) {
        this.setPrimaryKey(this.nativeGetColumnName(this.nativePtr, columnIndex));
    }

    private Table getPrimaryKeyTable() {
        if (this.sharedRealm == null) {
            return null;
        }
        Table pkTable = this.sharedRealm.getTable(PRIMARY_KEY_TABLE_NAME);
        if (pkTable.getColumnCount() == 0L) {
            this.checkImmutable();
            long columnIndex = pkTable.addColumn(RealmFieldType.STRING, PRIMARY_KEY_CLASS_COLUMN_NAME);
            pkTable.addSearchIndex(columnIndex);
            pkTable.addColumn(RealmFieldType.STRING, PRIMARY_KEY_FIELD_COLUMN_NAME);
        }
        return pkTable;
    }

    private void invalidateCachedPrimaryKeyIndex() {
        this.cachedPrimaryKeyColumnIndex = -1L;
    }

    public static boolean migratePrimaryKeyTableIfNeeded(SharedRealm sharedRealm) {
        if (sharedRealm == null || !sharedRealm.isInTransaction()) {
            Table.throwImmutable();
        }
        if (!sharedRealm.hasTable(PRIMARY_KEY_TABLE_NAME)) {
            return false;
        }
        Table pkTable = sharedRealm.getTable(PRIMARY_KEY_TABLE_NAME);
        return Table.nativeMigratePrimaryKeyTableIfNeeded(sharedRealm.getGroupNative(), pkTable.nativePtr);
    }

    public static boolean primaryKeyTableNeedsMigration(SharedRealm sharedRealm) {
        if (!sharedRealm.hasTable(PRIMARY_KEY_TABLE_NAME)) {
            return false;
        }
        Table pkTable = sharedRealm.getTable(PRIMARY_KEY_TABLE_NAME);
        return Table.nativePrimaryKeyTableNeedsMigration(pkTable.nativePtr);
    }

    public boolean hasSearchIndex(long columnIndex) {
        return this.nativeHasSearchIndex(this.nativePtr, columnIndex);
    }

    @Override
    public boolean isNullLink(long columnIndex, long rowIndex) {
        return this.nativeIsNullLink(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public void nullifyLink(long columnIndex, long rowIndex) {
        Table.nativeNullifyLink(this.nativePtr, columnIndex, rowIndex);
    }

    boolean isImmutable() {
        return this.sharedRealm != null && !this.sharedRealm.isInTransaction();
    }

    void checkImmutable() {
        if (this.isImmutable()) {
            Table.throwImmutable();
        }
    }

    private void checkHasPrimaryKey() {
        if (!this.hasPrimaryKey()) {
            throw new IllegalStateException(this.getName() + " has no primary key defined");
        }
    }

    @Override
    public long sumLong(long columnIndex) {
        return this.nativeSumInt(this.nativePtr, columnIndex);
    }

    @Override
    public Long maximumLong(long columnIndex) {
        return this.nativeMaximumInt(this.nativePtr, columnIndex);
    }

    @Override
    public Long minimumLong(long columnIndex) {
        return this.nativeMinimumInt(this.nativePtr, columnIndex);
    }

    @Override
    public double averageLong(long columnIndex) {
        return this.nativeAverageInt(this.nativePtr, columnIndex);
    }

    @Override
    public double sumFloat(long columnIndex) {
        return this.nativeSumFloat(this.nativePtr, columnIndex);
    }

    @Override
    public Float maximumFloat(long columnIndex) {
        return Float.valueOf(this.nativeMaximumFloat(this.nativePtr, columnIndex));
    }

    @Override
    public Float minimumFloat(long columnIndex) {
        return Float.valueOf(this.nativeMinimumFloat(this.nativePtr, columnIndex));
    }

    @Override
    public double averageFloat(long columnIndex) {
        return this.nativeAverageFloat(this.nativePtr, columnIndex);
    }

    @Override
    public double sumDouble(long columnIndex) {
        return this.nativeSumDouble(this.nativePtr, columnIndex);
    }

    @Override
    public Double maximumDouble(long columnIndex) {
        return this.nativeMaximumDouble(this.nativePtr, columnIndex);
    }

    @Override
    public Double minimumDouble(long columnIndex) {
        return this.nativeMinimumDouble(this.nativePtr, columnIndex);
    }

    @Override
    public double averageDouble(long columnIndex) {
        return this.nativeAverageDouble(this.nativePtr, columnIndex);
    }

    @Override
    public Date maximumDate(long columnIndex) {
        return new Date(this.nativeMaximumTimestamp(this.nativePtr, columnIndex));
    }

    @Override
    public Date minimumDate(long columnIndex) {
        return new Date(this.nativeMinimumTimestamp(this.nativePtr, columnIndex));
    }

    public long count(long columnIndex, long value) {
        return this.nativeCountLong(this.nativePtr, columnIndex, value);
    }

    public long count(long columnIndex, float value) {
        return this.nativeCountFloat(this.nativePtr, columnIndex, value);
    }

    public long count(long columnIndex, double value) {
        return this.nativeCountDouble(this.nativePtr, columnIndex, value);
    }

    @Override
    public long count(long columnIndex, String value) {
        return this.nativeCountString(this.nativePtr, columnIndex, value);
    }

    @Override
    public TableQuery where() {
        this.context.executeDelayedDisposal();
        long nativeQueryPtr = this.nativeWhere(this.nativePtr);
        try {
            return new TableQuery(this.context, this, nativeQueryPtr);
        }
        catch (RuntimeException e) {
            TableQuery.nativeClose(nativeQueryPtr);
            throw e;
        }
    }

    @Override
    public long sourceRowIndex(long rowIndex) {
        return rowIndex;
    }

    @Override
    public long findFirstLong(long columnIndex, long value) {
        return Table.nativeFindFirstInt(this.nativePtr, columnIndex, value);
    }

    @Override
    public long findFirstBoolean(long columnIndex, boolean value) {
        return this.nativeFindFirstBool(this.nativePtr, columnIndex, value);
    }

    @Override
    public long findFirstFloat(long columnIndex, float value) {
        return this.nativeFindFirstFloat(this.nativePtr, columnIndex, value);
    }

    @Override
    public long findFirstDouble(long columnIndex, double value) {
        return this.nativeFindFirstDouble(this.nativePtr, columnIndex, value);
    }

    @Override
    public long findFirstDate(long columnIndex, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("null is not supported");
        }
        return this.nativeFindFirstTimestamp(this.nativePtr, columnIndex, date.getTime());
    }

    @Override
    public long findFirstString(long columnIndex, String value) {
        if (value == null) {
            throw new IllegalArgumentException("null is not supported");
        }
        return Table.nativeFindFirstString(this.nativePtr, columnIndex, value);
    }

    public long findFirstNull(long columnIndex) {
        return Table.nativeFindFirstNull(this.nativePtr, columnIndex);
    }

    @Override
    public TableView findAllLong(long columnIndex, long value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllInt(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllBoolean(long columnIndex, boolean value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllBool(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllFloat(long columnIndex, float value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllFloat(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllDouble(long columnIndex, double value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllDouble(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllString(long columnIndex, String value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllString(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public long lowerBoundLong(long columnIndex, long value) {
        return this.nativeLowerBoundInt(this.nativePtr, columnIndex, value);
    }

    @Override
    public long upperBoundLong(long columnIndex, long value) {
        return this.nativeUpperBoundInt(this.nativePtr, columnIndex, value);
    }

    @Override
    public Table pivot(long stringCol, long intCol, TableOrView.PivotType pivotType) {
        if (!this.getColumnType(stringCol).equals((Object)RealmFieldType.STRING)) {
            throw new UnsupportedOperationException("Group by column must be of type String");
        }
        if (!this.getColumnType(intCol).equals((Object)RealmFieldType.INTEGER)) {
            throw new UnsupportedOperationException("Aggregation column must be of type Int");
        }
        Table result = new Table();
        this.nativePivot(this.nativePtr, stringCol, intCol, pivotType.value, result.nativePtr);
        return result;
    }

    public TableView getDistinctView(long columnIndex) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeGetDistinctView(this.nativePtr, columnIndex);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    public String getName() {
        return this.nativeGetName(this.nativePtr);
    }

    @Override
    public String toJson() {
        return this.nativeToJson(this.nativePtr);
    }

    @Override
    public String toString() {
        long columnCount = this.getColumnCount();
        String name = this.getName();
        StringBuilder stringBuilder = new StringBuilder("The Table ");
        if (name != null && !name.isEmpty()) {
            stringBuilder.append(this.getName());
            stringBuilder.append(" ");
        }
        if (this.hasPrimaryKey()) {
            String pkFieldName = this.getColumnName(this.getPrimaryKey());
            stringBuilder.append("has '").append(pkFieldName).append("' field as a PrimaryKey, and ");
        }
        stringBuilder.append("contains ");
        stringBuilder.append(columnCount);
        stringBuilder.append(" columns: ");
        int i = 0;
        while ((long)i < columnCount) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.getColumnName(i));
            ++i;
        }
        stringBuilder.append(".");
        stringBuilder.append(" And ");
        stringBuilder.append(this.size());
        stringBuilder.append(" rows.");
        return stringBuilder.toString();
    }

    @Override
    public long syncIfNeeded() {
        throw new RuntimeException("Not supported for tables");
    }

    private static void throwImmutable() {
        throw new IllegalStateException("Changing Realm data can only be done from inside a transaction.");
    }

    public boolean hasSameSchema(Table table) {
        if (table == null) {
            throw new IllegalArgumentException("The argument cannot be null");
        }
        return this.nativeHasSameSchema(this.nativePtr, table.nativePtr);
    }

    public static boolean isModelTable(String tableName) {
        return tableName.startsWith(TABLE_PREFIX);
    }

    @Override
    public long getVersion() {
        return this.nativeVersion(this.nativePtr);
    }

    public static String tableNameToClassName(String tableName) {
        if (!tableName.startsWith(TABLE_PREFIX)) {
            return tableName;
        }
        return tableName.substring(TABLE_PREFIX.length());
    }

    protected native long createNative();

    static native void nativeClose(long var0);

    private native boolean nativeIsValid(long var1);

    private native long nativeAddColumn(long var1, int var3, String var4, boolean var5);

    private native long nativeAddColumnLink(long var1, int var3, String var4, long var5);

    private native void nativeRenameColumn(long var1, long var3, String var5);

    private native void nativeRemoveColumn(long var1, long var3);

    private native boolean nativeIsColumnNullable(long var1, long var3);

    private native void nativeConvertColumnToNullable(long var1, long var3);

    private native void nativeConvertColumnToNotNullable(long var1, long var3);

    private native long nativeSize(long var1);

    private native void nativeClear(long var1);

    private native long nativeGetColumnCount(long var1);

    private native String nativeGetColumnName(long var1, long var3);

    private native long nativeGetColumnIndex(long var1, String var3);

    private native int nativeGetColumnType(long var1, long var3);

    private native void nativeRemove(long var1, long var3);

    private native void nativeRemoveLast(long var1);

    private native void nativeMoveLastOver(long var1, long var3);

    public static native long nativeAddEmptyRow(long var0, long var2);

    private native long nativeGetSortedViewMulti(long var1, long[] var3, boolean[] var4);

    private native long nativeGetLong(long var1, long var3, long var5);

    private native boolean nativeGetBoolean(long var1, long var3, long var5);

    private native float nativeGetFloat(long var1, long var3, long var5);

    private native double nativeGetDouble(long var1, long var3, long var5);

    private native long nativeGetTimestamp(long var1, long var3, long var5);

    private native String nativeGetString(long var1, long var3, long var5);

    private native byte[] nativeGetByteArray(long var1, long var3, long var5);

    private native long nativeGetLink(long var1, long var3, long var5);

    public static native long nativeGetLinkView(long var0, long var2, long var4);

    private native long nativeGetLinkTarget(long var1, long var3);

    private native boolean nativeIsNull(long var1, long var3, long var5);

    native long nativeGetRowPtr(long var1, long var3);

    public static native void nativeSetLong(long var0, long var2, long var4, long var6, boolean var8);

    public static native void nativeSetLongUnique(long var0, long var2, long var4, long var6);

    public static native void nativeSetBoolean(long var0, long var2, long var4, boolean var6, boolean var7);

    public static native void nativeSetFloat(long var0, long var2, long var4, float var6, boolean var7);

    public static native void nativeSetDouble(long var0, long var2, long var4, double var6, boolean var8);

    public static native void nativeSetTimestamp(long var0, long var2, long var4, long var6, boolean var8);

    public static native void nativeSetString(long var0, long var2, long var4, String var6, boolean var7);

    public static native void nativeSetStringUnique(long var0, long var2, long var4, String var6);

    public static native void nativeSetNull(long var0, long var2, long var4, boolean var6);

    public static native void nativeSetNullUnique(long var0, long var2, long var4);

    public static native void nativeSetByteArray(long var0, long var2, long var4, byte[] var6, boolean var7);

    public static native void nativeSetLink(long var0, long var2, long var4, long var6, boolean var8);

    private native long nativeSetPrimaryKey(long var1, long var3, String var5);

    private static native boolean nativeMigratePrimaryKeyTableIfNeeded(long var0, long var2);

    private static native boolean nativePrimaryKeyTableNeedsMigration(long var0);

    private native void nativeAddSearchIndex(long var1, long var3);

    private native void nativeRemoveSearchIndex(long var1, long var3);

    private native boolean nativeHasSearchIndex(long var1, long var3);

    private native boolean nativeIsNullLink(long var1, long var3, long var5);

    public static native void nativeNullifyLink(long var0, long var2, long var4);

    private native long nativeSumInt(long var1, long var3);

    private native long nativeMaximumInt(long var1, long var3);

    private native long nativeMinimumInt(long var1, long var3);

    private native double nativeAverageInt(long var1, long var3);

    private native double nativeSumFloat(long var1, long var3);

    private native float nativeMaximumFloat(long var1, long var3);

    private native float nativeMinimumFloat(long var1, long var3);

    private native double nativeAverageFloat(long var1, long var3);

    private native double nativeSumDouble(long var1, long var3);

    private native double nativeMaximumDouble(long var1, long var3);

    private native double nativeMinimumDouble(long var1, long var3);

    private native double nativeAverageDouble(long var1, long var3);

    private native long nativeMaximumTimestamp(long var1, long var3);

    private native long nativeMinimumTimestamp(long var1, long var3);

    private native long nativeCountLong(long var1, long var3, long var5);

    private native long nativeCountFloat(long var1, long var3, float var5);

    private native long nativeCountDouble(long var1, long var3, double var5);

    private native long nativeCountString(long var1, long var3, String var5);

    private native long nativeWhere(long var1);

    public static native long nativeFindFirstInt(long var0, long var2, long var4);

    private native long nativeFindFirstBool(long var1, long var3, boolean var5);

    private native long nativeFindFirstFloat(long var1, long var3, float var5);

    private native long nativeFindFirstDouble(long var1, long var3, double var5);

    private native long nativeFindFirstTimestamp(long var1, long var3, long var5);

    public static native long nativeFindFirstString(long var0, long var2, String var4);

    public static native long nativeFindFirstNull(long var0, long var2);

    private native long nativeFindAllInt(long var1, long var3, long var5);

    private native long nativeFindAllBool(long var1, long var3, boolean var5);

    private native long nativeFindAllFloat(long var1, long var3, float var5);

    private native long nativeFindAllDouble(long var1, long var3, double var5);

    private native long nativeFindAllString(long var1, long var3, String var5);

    private native long nativeLowerBoundInt(long var1, long var3, long var5);

    private native long nativeUpperBoundInt(long var1, long var3, long var5);

    private native void nativePivot(long var1, long var3, long var5, int var7, long var8);

    private native long nativeGetDistinctView(long var1, long var3);

    private native String nativeGetName(long var1);

    private native String nativeToJson(long var1);

    private native boolean nativeHasSameSchema(long var1, long var3);

    private native long nativeVersion(long var1);
}

