/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmConfiguration;
import io.realm.RealmSchema;
import io.realm.internal.Context;
import io.realm.internal.ObjectServerFacade;
import io.realm.internal.RealmNotifier;
import io.realm.internal.Table;
import io.realm.internal.async.BadVersionException;
import java.io.Closeable;
import java.io.File;

public final class SharedRealm
implements Closeable {
    public static final byte FILE_EXCEPTION_KIND_ACCESS_ERROR = 0;
    public static final byte FILE_EXCEPTION_KIND_PERMISSION_DENIED = 1;
    public static final byte FILE_EXCEPTION_KIND_EXISTS = 2;
    public static final byte FILE_EXCEPTION_KIND_NOT_FOUND = 3;
    public static final byte FILE_EXCEPTION_KIND_IMCOMPATIBLE_LOCK_FILE = 4;
    public static final byte FILE_EXCEPTION_KIND_FORMAT_UPGRADE_REQUIRED = 5;
    public static final byte SCHEMA_MODE_VALUE_AUTOMATIC = 0;
    public static final byte SCHEMA_MODE_VALUE_READONLY = 1;
    public static final byte SCHEMA_MODE_VALUE_RESET_FILE = 2;
    public static final byte SCHEMA_MODE_VALUE_ADDITIVE = 3;
    public static final byte SCHEMA_MODE_VALUE_MANUAL = 4;
    public final RealmNotifier realmNotifier;
    public final ObjectServerFacade objectServerFacade;
    private long nativePtr;
    private RealmConfiguration configuration;
    final Context context;
    private long lastSchemaVersion;
    private final SchemaVersionListener schemaChangeListener;

    private SharedRealm(long nativePtr, RealmConfiguration configuration, RealmNotifier notifier, SchemaVersionListener schemaVersionListener) {
        this.nativePtr = nativePtr;
        this.configuration = configuration;
        this.realmNotifier = notifier;
        this.schemaChangeListener = schemaVersionListener;
        this.context = new Context();
        this.lastSchemaVersion = schemaVersionListener == null ? -1L : this.getSchemaVersion();
        this.objectServerFacade = null;
    }

    public static SharedRealm getInstance(RealmConfiguration config) {
        return SharedRealm.getInstance(config, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedRealm getInstance(RealmConfiguration config, RealmNotifier realmNotifier, SchemaVersionListener schemaVersionListener) {
        String[] userAndServer = ObjectServerFacade.getSyncFacadeIfPossible().getUserAndServerUrl(config);
        String rosServerUrl = userAndServer[0];
        String rosUserToken = userAndServer[1];
        boolean enable_caching = false;
        boolean disableFormatUpgrade = false;
        boolean autoChangeNotifications = true;
        long nativeConfigPtr = SharedRealm.nativeCreateConfig(config.getPath(), config.getEncryptionKey(), rosServerUrl != null ? SchemaMode.SCHEMA_MODE_ADDITIVE.getNativeValue() : SchemaMode.SCHEMA_MODE_MANUAL.getNativeValue(), config.getDurability() == Durability.MEM_ONLY, enable_caching, disableFormatUpgrade, autoChangeNotifications, rosServerUrl, rosUserToken);
        try {
            SharedRealm sharedRealm = new SharedRealm(SharedRealm.nativeGetSharedRealm(nativeConfigPtr, realmNotifier), config, realmNotifier, schemaVersionListener);
            return sharedRealm;
        }
        finally {
            SharedRealm.nativeCloseConfig(nativeConfigPtr);
        }
    }

    long getNativePtr() {
        return this.nativePtr;
    }

    public void beginTransaction() {
        SharedRealm.nativeBeginTransaction(this.nativePtr);
        this.invokeSchemaChangeListenerIfSchemaChanged();
    }

    public void commitTransaction() {
        SharedRealm.nativeCommitTransaction(this.nativePtr);
    }

    public void cancelTransaction() {
        SharedRealm.nativeCancelTransaction(this.nativePtr);
    }

    public boolean isInTransaction() {
        return SharedRealm.nativeIsInTransaction(this.nativePtr);
    }

    public void setSchemaVersion(long schemaVersion) {
        SharedRealm.nativeSetVersion(this.nativePtr, schemaVersion);
    }

    public long getSchemaVersion() {
        return SharedRealm.nativeGetVersion(this.nativePtr);
    }

    long getGroupNative() {
        return SharedRealm.nativeReadGroup(this.nativePtr);
    }

    public boolean hasTable(String name) {
        return SharedRealm.nativeHasTable(this.nativePtr, name);
    }

    public Table getTable(String name) {
        return new Table(this, SharedRealm.nativeGetTable(this.nativePtr, name));
    }

    public void renameTable(String oldName, String newName) {
        SharedRealm.nativeRenameTable(this.nativePtr, oldName, newName);
    }

    public void removeTable(String name) {
        SharedRealm.nativeRemoveTable(this.nativePtr, name);
    }

    public String getTableName(int index) {
        return SharedRealm.nativeGetTableName(this.nativePtr, index);
    }

    public long size() {
        return SharedRealm.nativeSize(this.nativePtr);
    }

    public String getPath() {
        return this.configuration.getPath();
    }

    public boolean isEmpty() {
        return SharedRealm.nativeIsEmpty(this.nativePtr);
    }

    public void refresh() {
        SharedRealm.nativeRefresh(this.nativePtr);
        this.invokeSchemaChangeListenerIfSchemaChanged();
    }

    public void refresh(VersionID version) throws BadVersionException {
        SharedRealm.nativeRefresh(this.nativePtr, version.version, version.index);
        this.invokeSchemaChangeListenerIfSchemaChanged();
    }

    public VersionID getVersionID() {
        long[] versionId = SharedRealm.nativeGetVersionID(this.nativePtr);
        return new VersionID(versionId[0], versionId[1]);
    }

    public long getLastSnapshotVersion() {
        return SharedRealm.nativeGetSnapshotVersion(this.nativePtr);
    }

    public boolean isClosed() {
        return this.nativePtr == 0L || SharedRealm.nativeIsClosed(this.nativePtr);
    }

    public void writeCopy(File file, byte[] key) {
        if (file.isFile() && file.exists()) {
            throw new IllegalArgumentException("The destination file must not exist");
        }
        SharedRealm.nativeWriteCopy(this.nativePtr, file.getAbsolutePath(), key);
    }

    public boolean waitForChange() {
        return SharedRealm.nativeWaitForChange(this.nativePtr);
    }

    public void stopWaitForChange() {
        SharedRealm.nativeStopWaitForChange(this.nativePtr);
    }

    public boolean compact() {
        return SharedRealm.nativeCompact(this.nativePtr);
    }

    public void updateSchema(RealmSchema schema, long version) {
        SharedRealm.nativeUpdateSchema(this.nativePtr, schema.getNativePtr(), version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.realmNotifier != null) {
            this.realmNotifier.close();
        }
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                SharedRealm.nativeCloseSharedRealm(this.nativePtr);
                this.nativePtr = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Context context = this.context;
        synchronized (context) {
            this.close();
        }
        super.finalize();
    }

    public void invokeSchemaChangeListenerIfSchemaChanged() {
        if (this.schemaChangeListener == null) {
            return;
        }
        long before = this.lastSchemaVersion;
        long current = this.getSchemaVersion();
        if (current != before) {
            this.lastSchemaVersion = current;
            this.schemaChangeListener.onSchemaVersionChanged(current);
        }
    }

    private static native long nativeCreateConfig(String var0, byte[] var1, byte var2, boolean var3, boolean var4, boolean var5, boolean var6, String var7, String var8);

    private static native void nativeCloseConfig(long var0);

    private static native long nativeGetSharedRealm(long var0, RealmNotifier var2);

    private static native void nativeCloseSharedRealm(long var0);

    private static native boolean nativeIsClosed(long var0);

    private static native void nativeBeginTransaction(long var0);

    private static native void nativeCommitTransaction(long var0);

    private static native void nativeCancelTransaction(long var0);

    private static native boolean nativeIsInTransaction(long var0);

    private static native long nativeGetVersion(long var0);

    private static native long nativeGetSnapshotVersion(long var0);

    private static native void nativeSetVersion(long var0, long var2);

    private static native long nativeReadGroup(long var0);

    private static native boolean nativeIsEmpty(long var0);

    private static native void nativeRefresh(long var0);

    private static native void nativeRefresh(long var0, long var2, long var4);

    private static native long[] nativeGetVersionID(long var0);

    private static native long nativeGetTable(long var0, String var2);

    private static native String nativeGetTableName(long var0, int var2);

    private static native boolean nativeHasTable(long var0, String var2);

    private static native void nativeRenameTable(long var0, String var2, String var3);

    private static native void nativeRemoveTable(long var0, String var2);

    private static native long nativeSize(long var0);

    private static native void nativeWriteCopy(long var0, String var2, byte[] var3);

    private static native boolean nativeWaitForChange(long var0);

    private static native void nativeStopWaitForChange(long var0);

    private static native boolean nativeCompact(long var0);

    private static native void nativeUpdateSchema(long var0, long var2, long var4);

    public static interface SchemaVersionListener {
        public void onSchemaVersionChanged(long var1);
    }

    public static class VersionID
    implements Comparable<VersionID> {
        public final long version;
        public final long index;

        VersionID(long version, long index) {
            this.version = version;
            this.index = index;
        }

        @Override
        public int compareTo(VersionID another) {
            if (another == null) {
                throw new IllegalArgumentException("Version cannot be compared to a null value.");
            }
            if (this.version > another.version) {
                return 1;
            }
            if (this.version < another.version) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "VersionID{version=" + this.version + ", index=" + this.index + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            VersionID versionID = (VersionID)object;
            return this.version == versionID.version && this.index == versionID.index;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (int)(this.version ^ this.version >>> 32);
            result = 31 * result + (int)(this.index ^ this.index >>> 32);
            return result;
        }
    }

    public static enum SchemaMode {
        SCHEMA_MODE_AUTOMATIC(0),
        SCHEMA_MODE_READONLY(1),
        SCHEMA_MODE_RESET_FILE(2),
        SCHEMA_MODE_ADDITIVE(3),
        SCHEMA_MODE_MANUAL(4);

        final byte value;

        private SchemaMode(byte value) {
            this.value = value;
        }

        public byte getNativeValue() {
            return this.value;
        }
    }

    public static enum Durability {
        FULL(0),
        MEM_ONLY(1);

        final int value;

        private Durability(int value) {
            this.value = value;
        }
    }
}

