/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import android.util.JsonReader;
import io.realm.Realm;
import io.realm.RealmModel;
import io.realm.RealmObjectSchema;
import io.realm.RealmSchema;
import io.realm.exceptions.RealmException;
import io.realm.internal.ColumnInfo;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.SharedRealm;
import io.realm.internal.Table;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class RealmProxyMediator {
    public abstract RealmObjectSchema createRealmObjectSchema(Class<? extends RealmModel> var1, RealmSchema var2);

    public abstract Table createTable(Class<? extends RealmModel> var1, SharedRealm var2);

    public abstract ColumnInfo validateTable(Class<? extends RealmModel> var1, SharedRealm var2, boolean var3);

    public abstract List<String> getFieldNames(Class<? extends RealmModel> var1);

    public abstract String getTableName(Class<? extends RealmModel> var1);

    public abstract <E extends RealmModel> E newInstance(Class<E> var1, Object var2, Row var3, ColumnInfo var4, boolean var5, List<String> var6);

    public abstract Set<Class<? extends RealmModel>> getModelClasses();

    public abstract <E extends RealmModel> E copyOrUpdate(Realm var1, E var2, boolean var3, Map<RealmModel, RealmObjectProxy> var4);

    public abstract void insert(Realm var1, RealmModel var2, Map<RealmModel, Long> var3);

    public abstract void insertOrUpdate(Realm var1, RealmModel var2, Map<RealmModel, Long> var3);

    public abstract void insertOrUpdate(Realm var1, Collection<? extends RealmModel> var2);

    public abstract void insert(Realm var1, Collection<? extends RealmModel> var2);

    public abstract <E extends RealmModel> E createOrUpdateUsingJsonObject(Class<E> var1, Realm var2, JSONObject var3, boolean var4) throws JSONException;

    public abstract <E extends RealmModel> E createUsingJsonStream(Class<E> var1, Realm var2, JsonReader var3) throws IOException;

    public abstract <E extends RealmModel> E createDetachedCopy(E var1, int var2, Map<RealmModel, RealmObjectProxy.CacheData<RealmModel>> var3);

    public boolean transformerApplied() {
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RealmProxyMediator)) {
            return false;
        }
        RealmProxyMediator other = (RealmProxyMediator)o;
        return this.getModelClasses().equals(other.getModelClasses());
    }

    public int hashCode() {
        return this.getModelClasses().hashCode();
    }

    protected static void checkClass(Class<? extends RealmModel> clazz) {
        if (clazz == null) {
            throw new NullPointerException("A class extending RealmObject must be provided");
        }
    }

    protected static RealmException getMissingProxyClassException(Class<? extends RealmModel> clazz) {
        return new RealmException(clazz + " is not part of the schema for this Realm.");
    }
}

