/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.CheckedRow;
import io.realm.internal.Context;
import io.realm.internal.NativeObject;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.UncheckedRow;

public class LinkView
extends NativeObject {
    private final Context context;
    final Table parent;
    final long columnIndexInParent;

    public LinkView(Context context, Table parent, long columnIndexInParent, long nativeLinkViewPtr) {
        this.context = context;
        this.parent = parent;
        this.columnIndexInParent = columnIndexInParent;
        this.nativePointer = nativeLinkViewPtr;
        context.executeDelayedDisposal();
        context.addReference(0, this);
    }

    public UncheckedRow getUncheckedRow(long index) {
        return UncheckedRow.getByRowIndex(this.context, this, index);
    }

    public CheckedRow getCheckedRow(long index) {
        return CheckedRow.get(this.context, this, index);
    }

    public long getTargetRowIndex(long linkViewIndex) {
        return this.nativeGetTargetRowIndex(this.nativePointer, linkViewIndex);
    }

    public void add(long rowIndex) {
        this.checkImmutable();
        LinkView.nativeAdd(this.nativePointer, rowIndex);
    }

    public void insert(long pos, long rowIndex) {
        this.checkImmutable();
        this.nativeInsert(this.nativePointer, pos, rowIndex);
    }

    public void set(long pos, long rowIndex) {
        this.checkImmutable();
        this.nativeSet(this.nativePointer, pos, rowIndex);
    }

    public void move(long oldPos, long newPos) {
        this.checkImmutable();
        this.nativeMove(this.nativePointer, oldPos, newPos);
    }

    public void remove(long pos) {
        this.checkImmutable();
        this.nativeRemove(this.nativePointer, pos);
    }

    public void clear() {
        this.checkImmutable();
        LinkView.nativeClear(this.nativePointer);
    }

    public boolean contains(long tableRowIndex) {
        long index = this.nativeFind(this.nativePointer, tableRowIndex);
        return index != -1L;
    }

    public long size() {
        return this.nativeSize(this.nativePointer);
    }

    public boolean isEmpty() {
        return this.nativeIsEmpty(this.nativePointer);
    }

    public TableQuery where() {
        this.context.executeDelayedDisposal();
        long nativeQueryPtr = this.nativeWhere(this.nativePointer);
        try {
            return new TableQuery(this.context, this.parent, nativeQueryPtr);
        }
        catch (RuntimeException e) {
            TableQuery.nativeClose(nativeQueryPtr);
            throw e;
        }
    }

    public boolean isAttached() {
        return this.nativeIsAttached(this.nativePointer);
    }

    public Table getTable() {
        return this.parent;
    }

    public void removeAllTargetRows() {
        this.checkImmutable();
        this.nativeRemoveAllTargetRows(this.nativePointer);
    }

    public void removeTargetRow(int index) {
        this.checkImmutable();
        this.nativeRemoveTargetRow(this.nativePointer, index);
    }

    public Table getTargetTable() {
        this.context.executeDelayedDisposal();
        long nativeTablePointer = this.nativeGetTargetTable(this.nativePointer);
        try {
            return new Table(this.parent, nativeTablePointer);
        }
        catch (RuntimeException e) {
            Table.nativeClose(nativeTablePointer);
            throw e;
        }
    }

    private void checkImmutable() {
        if (this.parent.isImmutable()) {
            throw new IllegalStateException("Changing Realm data can only be done from inside a write transaction.");
        }
    }

    public static native void nativeClose(long var0);

    native long nativeGetRow(long var1, long var3);

    private native long nativeGetTargetRowIndex(long var1, long var3);

    public static native void nativeAdd(long var0, long var2);

    private native void nativeInsert(long var1, long var3, long var5);

    private native void nativeSet(long var1, long var3, long var5);

    private native void nativeMove(long var1, long var3, long var5);

    private native void nativeRemove(long var1, long var3);

    public static native void nativeClear(long var0);

    private native long nativeSize(long var1);

    private native boolean nativeIsEmpty(long var1);

    protected native long nativeWhere(long var1);

    private native boolean nativeIsAttached(long var1);

    private native long nativeFind(long var1, long var3);

    private native void nativeRemoveTargetRow(long var1, long var3);

    private native void nativeRemoveAllTargetRows(long var1);

    private native long nativeGetTargetTable(long var1);
}

