/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmModel;
import io.realm.internal.ColumnInfo;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.Table;
import java.util.HashMap;
import java.util.Map;

public final class ColumnIndices
implements Cloneable {
    private long schemaVersion;
    private Map<Class<? extends RealmModel>, ColumnInfo> classes;

    public ColumnIndices(long schemaVersion, Map<Class<? extends RealmModel>, ColumnInfo> classes) {
        this.schemaVersion = schemaVersion;
        this.classes = classes;
    }

    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    public ColumnInfo getColumnInfo(Class<? extends RealmModel> clazz) {
        return this.classes.get(clazz);
    }

    public long getColumnIndex(Class<? extends RealmModel> clazz, String fieldName) {
        ColumnInfo columnInfo = this.classes.get(clazz);
        if (columnInfo != null) {
            Long index = columnInfo.getIndicesMap().get(fieldName);
            return index != null ? index : -1L;
        }
        return -1L;
    }

    public ColumnIndices clone() {
        try {
            ColumnIndices clone = (ColumnIndices)super.clone();
            clone.classes = this.duplicateColumnInfoMap();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<Class<? extends RealmModel>, ColumnInfo> duplicateColumnInfoMap() {
        HashMap<Class<? extends RealmModel>, ColumnInfo> copy = new HashMap<Class<? extends RealmModel>, ColumnInfo>();
        for (Map.Entry<Class<? extends RealmModel>, ColumnInfo> entry : this.classes.entrySet()) {
            copy.put(entry.getKey(), entry.getValue().clone());
        }
        return copy;
    }

    public void copyFrom(ColumnIndices other, RealmProxyMediator mediator) {
        for (Map.Entry<Class<? extends RealmModel>, ColumnInfo> entry : this.classes.entrySet()) {
            ColumnInfo otherColumnInfo = other.getColumnInfo(entry.getKey());
            if (otherColumnInfo == null) {
                throw new IllegalStateException("Failed to copy ColumnIndices cache: " + Table.tableNameToClassName(mediator.getTableName(entry.getKey())));
            }
            entry.getValue().copyColumnInfoFrom(otherColumnInfo);
        }
        this.schemaVersion = other.schemaVersion;
    }
}

