/*
 * Decompiled with CFR 0.152.
 */
package io.realm.exceptions;

import io.realm.internal.Keep;

@Keep
public class RealmFileException
extends RuntimeException {
    private final Kind kind;

    public RealmFileException(byte value, String message) {
        super(message);
        this.kind = Kind.getKind(value);
    }

    public RealmFileException(Kind kind, String message) {
        super(message);
        this.kind = kind;
    }

    public RealmFileException(Kind kind, Throwable cause) {
        super(cause);
        this.kind = kind;
    }

    public RealmFileException(Kind kind, String message, Throwable cause) {
        super(message, cause);
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    @Override
    public String toString() {
        return String.format("%s Kind: %s.", new Object[]{super.toString(), this.kind});
    }

    public static enum Kind {
        ACCESS_ERROR,
        PERMISSION_DENIED,
        EXISTS,
        NOT_FOUND,
        INCOMPATIBLE_LOCK_FILE,
        FORMAT_UPGRADE_REQUIRED;


        static Kind getKind(byte value) {
            switch (value) {
                case 0: {
                    return ACCESS_ERROR;
                }
                case 1: {
                    return PERMISSION_DENIED;
                }
                case 2: {
                    return EXISTS;
                }
                case 3: {
                    return NOT_FOUND;
                }
                case 4: {
                    return INCOMPATIBLE_LOCK_FILE;
                }
                case 5: {
                    return FORMAT_UPGRADE_REQUIRED;
                }
            }
            throw new RuntimeException("Unknown value for RealmFileException kind.");
        }
    }
}

