/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.RealmModel;
import io.realm.RealmObjectSchema;
import io.realm.internal.ColumnIndices;
import io.realm.internal.ColumnInfo;
import io.realm.internal.Table;
import io.realm.internal.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class RealmSchema {
    private static final String TABLE_PREFIX = Table.TABLE_PREFIX;
    private static final String EMPTY_STRING_MSG = "Null or empty class names are not allowed";
    private final Map<String, Table> dynamicClassToTable = new HashMap<String, Table>();
    private final Map<Class<? extends RealmModel>, Table> classToTable = new HashMap<Class<? extends RealmModel>, Table>();
    private final Map<Class<? extends RealmModel>, RealmObjectSchema> classToSchema = new HashMap<Class<? extends RealmModel>, RealmObjectSchema>();
    private final Map<String, RealmObjectSchema> dynamicClassToSchema = new HashMap<String, RealmObjectSchema>();
    private final BaseRealm realm;
    private long nativePtr;
    ColumnIndices columnIndices;

    RealmSchema(BaseRealm realm) {
        this.realm = realm;
        this.nativePtr = 0L;
    }

    RealmSchema() {
        this.realm = null;
        this.nativePtr = 0L;
    }

    RealmSchema(ArrayList<RealmObjectSchema> realmObjectSchemas) {
        long[] list = new long[realmObjectSchemas.size()];
        for (int i = 0; i < realmObjectSchemas.size(); ++i) {
            list[i] = realmObjectSchemas.get(i).getNativePtr();
        }
        this.nativePtr = RealmSchema.nativeCreateFromList(list);
        this.realm = null;
    }

    public long getNativePtr() {
        return this.nativePtr;
    }

    public void close() {
        if (this.nativePtr != 0L) {
            Set<RealmObjectSchema> schemas = this.getAll();
            for (RealmObjectSchema schema : schemas) {
                schema.close();
            }
            RealmSchema.nativeClose(this.nativePtr);
        }
    }

    public RealmObjectSchema get(String className) {
        this.checkEmpty(className, EMPTY_STRING_MSG);
        if (this.realm == null) {
            if (this.contains(className)) {
                return this.dynamicClassToSchema.get(className);
            }
            return null;
        }
        String internalClassName = TABLE_PREFIX + className;
        if (this.realm.sharedRealm.hasTable(internalClassName)) {
            Table table = this.realm.sharedRealm.getTable(internalClassName);
            RealmObjectSchema.DynamicColumnMap columnIndices = new RealmObjectSchema.DynamicColumnMap(table);
            return new RealmObjectSchema(this.realm, table, columnIndices);
        }
        return null;
    }

    public Set<RealmObjectSchema> getAll() {
        if (this.realm == null) {
            long[] ptrs = RealmSchema.nativeGetAll(this.nativePtr);
            LinkedHashSet<RealmObjectSchema> schemas = new LinkedHashSet<RealmObjectSchema>(ptrs.length);
            for (int i = 0; i < ptrs.length; ++i) {
                schemas.add(new RealmObjectSchema(ptrs[i]));
            }
            return schemas;
        }
        int tableCount = (int)this.realm.sharedRealm.size();
        LinkedHashSet<RealmObjectSchema> schemas = new LinkedHashSet<RealmObjectSchema>(tableCount);
        for (int i = 0; i < tableCount; ++i) {
            String tableName = this.realm.sharedRealm.getTableName(i);
            if (!Table.isModelTable(tableName)) continue;
            Table table = this.realm.sharedRealm.getTable(tableName);
            RealmObjectSchema.DynamicColumnMap columnIndices = new RealmObjectSchema.DynamicColumnMap(table);
            schemas.add(new RealmObjectSchema(this.realm, table, columnIndices));
        }
        return schemas;
    }

    public RealmObjectSchema create(String className) {
        this.checkEmpty(className, EMPTY_STRING_MSG);
        if (this.realm == null) {
            RealmObjectSchema realmObjectSchema = new RealmObjectSchema(className);
            this.dynamicClassToSchema.put(className, realmObjectSchema);
            return realmObjectSchema;
        }
        String internalTableName = TABLE_PREFIX + className;
        if (internalTableName.length() > 56) {
            throw new IllegalArgumentException("Class name is to long. Limit is 57 characters: " + className.length());
        }
        if (this.realm.sharedRealm.hasTable(internalTableName)) {
            throw new IllegalArgumentException("Class already exists: " + className);
        }
        Table table = this.realm.sharedRealm.getTable(internalTableName);
        RealmObjectSchema.DynamicColumnMap columnIndices = new RealmObjectSchema.DynamicColumnMap(table);
        return new RealmObjectSchema(this.realm, table, columnIndices);
    }

    public void remove(String className) {
        this.realm.checkNotInSync();
        this.checkEmpty(className, EMPTY_STRING_MSG);
        String internalTableName = TABLE_PREFIX + className;
        this.checkHasTable(className, "Cannot remove class because it is not in this Realm: " + className);
        Table table = this.getTable(className);
        if (table.hasPrimaryKey()) {
            table.setPrimaryKey(null);
        }
        this.realm.sharedRealm.removeTable(internalTableName);
    }

    public RealmObjectSchema rename(String oldClassName, String newClassName) {
        this.realm.checkNotInSync();
        this.checkEmpty(oldClassName, "Class names cannot be empty or null");
        this.checkEmpty(newClassName, "Class names cannot be empty or null");
        String oldInternalName = TABLE_PREFIX + oldClassName;
        String newInternalName = TABLE_PREFIX + newClassName;
        this.checkHasTable(oldClassName, "Cannot rename class because it doesn't exist in this Realm: " + oldClassName);
        if (this.realm.sharedRealm.hasTable(newInternalName)) {
            throw new IllegalArgumentException(oldClassName + " cannot be renamed because the new class already exists: " + newClassName);
        }
        Table oldTable = this.getTable(oldClassName);
        String pkField = null;
        if (oldTable.hasPrimaryKey()) {
            pkField = oldTable.getColumnName(oldTable.getPrimaryKey());
            oldTable.setPrimaryKey(null);
        }
        this.realm.sharedRealm.renameTable(oldInternalName, newInternalName);
        Table table = this.realm.sharedRealm.getTable(newInternalName);
        if (pkField != null) {
            table.setPrimaryKey(pkField);
        }
        RealmObjectSchema.DynamicColumnMap columnIndices = new RealmObjectSchema.DynamicColumnMap(table);
        return new RealmObjectSchema(this.realm, table, columnIndices);
    }

    public boolean contains(String className) {
        if (this.realm == null) {
            return this.dynamicClassToSchema.containsKey(className);
        }
        return this.realm.sharedRealm.hasTable(Table.TABLE_PREFIX + className);
    }

    private void checkEmpty(String str, String error) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException(error);
        }
    }

    private void checkHasTable(String className, String errorMsg) {
        String internalTableName = TABLE_PREFIX + className;
        if (!this.realm.sharedRealm.hasTable(internalTableName)) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    ColumnInfo getColumnInfo(Class<? extends RealmModel> clazz) {
        ColumnInfo columnInfo = this.columnIndices.getColumnInfo(clazz);
        if (columnInfo == null) {
            throw new IllegalStateException("No validated schema information found for " + this.realm.configuration.getSchemaMediator().getTableName(clazz));
        }
        return columnInfo;
    }

    Table getTable(String className) {
        className = Table.TABLE_PREFIX + className;
        Table table = this.dynamicClassToTable.get(className);
        if (table == null) {
            if (!this.realm.sharedRealm.hasTable(className)) {
                throw new IllegalArgumentException("The class " + className + " doesn't exist in this Realm.");
            }
            table = this.realm.sharedRealm.getTable(className);
            this.dynamicClassToTable.put(className, table);
        }
        return table;
    }

    Table getTable(Class<? extends RealmModel> clazz) {
        Table table = this.classToTable.get(clazz);
        if (table == null) {
            Class<? extends RealmModel> originalClass = Util.getOriginalModelClass(clazz);
            if (RealmSchema.isProxyClass(originalClass, clazz)) {
                table = this.classToTable.get(originalClass);
            }
            if (table == null) {
                table = this.realm.sharedRealm.getTable(this.realm.configuration.getSchemaMediator().getTableName(originalClass));
                this.classToTable.put(originalClass, table);
            }
            if (RealmSchema.isProxyClass(originalClass, clazz)) {
                this.classToTable.put(clazz, table);
            }
        }
        return table;
    }

    RealmObjectSchema getSchemaForClass(Class<? extends RealmModel> clazz) {
        RealmObjectSchema classSchema = this.classToSchema.get(clazz);
        if (classSchema == null) {
            Class<? extends RealmModel> originalClass = Util.getOriginalModelClass(clazz);
            if (RealmSchema.isProxyClass(originalClass, clazz)) {
                classSchema = this.classToSchema.get(originalClass);
            }
            if (classSchema == null) {
                Table table = this.getTable(clazz);
                classSchema = new RealmObjectSchema(this.realm, table, this.columnIndices.getColumnInfo(originalClass).getIndicesMap());
                this.classToSchema.put(originalClass, classSchema);
            }
            if (RealmSchema.isProxyClass(originalClass, clazz)) {
                this.classToSchema.put(clazz, classSchema);
            }
        }
        return classSchema;
    }

    private static boolean isProxyClass(Class<? extends RealmModel> modelClass, Class<? extends RealmModel> testee) {
        return modelClass != testee;
    }

    RealmObjectSchema getSchemaForClass(String className) {
        className = Table.TABLE_PREFIX + className;
        RealmObjectSchema dynamicSchema = this.dynamicClassToSchema.get(className);
        if (dynamicSchema == null) {
            if (!this.realm.sharedRealm.hasTable(className)) {
                throw new IllegalArgumentException("The class " + className + " doesn't exist in this Realm.");
            }
            Table table = this.realm.sharedRealm.getTable(className);
            RealmObjectSchema.DynamicColumnMap columnIndices = new RealmObjectSchema.DynamicColumnMap(table);
            dynamicSchema = new RealmObjectSchema(this.realm, table, columnIndices);
            this.dynamicClassToSchema.put(className, dynamicSchema);
        }
        return dynamicSchema;
    }

    static String getSchemaForTable(Table table) {
        return table.getName().substring(Table.TABLE_PREFIX.length());
    }

    static native long nativeCreateFromList(long[] var0);

    static native void nativeClose(long var0);

    static native long[] nativeGetAll(long var0);
}

