/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.OrderedRealmCollection;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmFieldType;
import io.realm.RealmModel;
import io.realm.RealmQuery;
import io.realm.Sort;
import io.realm.internal.InvalidRow;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Table;
import io.realm.internal.TableOrView;
import io.realm.internal.TableQuery;
import io.realm.internal.TableView;
import io.realm.internal.async.BadVersionException;
import io.realm.log.RealmLog;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import rx.Observable;

public final class RealmResults<E extends RealmModel>
extends AbstractList<E>
implements OrderedRealmCollection<E> {
    private static final String NOT_SUPPORTED_MESSAGE = "This method is not supported by RealmResults.";
    final BaseRealm realm;
    Class<E> classSpec;
    String className;
    private TableOrView table = null;
    private static final String TYPE_MISMATCH = "Field '%s': type mismatch - %s expected.";
    private static final long TABLE_VIEW_VERSION_NONE = -1L;
    private long currentTableViewVersion = -1L;
    private final TableQuery query;
    private final List<RealmChangeListener<RealmResults<E>>> listeners = new CopyOnWriteArrayList<RealmChangeListener<RealmResults<E>>>();
    private Future<Long> pendingQuery;
    private boolean asyncQueryCompleted = false;
    private boolean viewUpdated = false;

    static <E extends RealmModel> RealmResults<E> createFromTableQuery(BaseRealm realm, TableQuery query, Class<E> clazz) {
        return new RealmResults<E>(realm, query, clazz);
    }

    static <E extends RealmModel> RealmResults<E> createFromTableOrView(BaseRealm realm, TableOrView table, Class<E> clazz) {
        RealmResults<E> realmResults = new RealmResults<E>(realm, table, clazz);
        realm.handlerController.addToRealmResults(realmResults);
        return realmResults;
    }

    static RealmResults<DynamicRealmObject> createFromDynamicClass(BaseRealm realm, TableQuery query, String className) {
        return new RealmResults<DynamicRealmObject>(realm, query, className);
    }

    static RealmResults<DynamicRealmObject> createFromDynamicTableOrView(BaseRealm realm, TableOrView table, String className) {
        RealmResults<DynamicRealmObject> realmResults = new RealmResults<DynamicRealmObject>(realm, table, className);
        realm.handlerController.addToRealmResults(realmResults);
        return realmResults;
    }

    private RealmResults(BaseRealm realm, TableQuery query, Class<E> clazz) {
        this.realm = realm;
        this.classSpec = clazz;
        this.query = query;
    }

    private RealmResults(BaseRealm realm, TableQuery query, String className) {
        this.realm = realm;
        this.query = query;
        this.className = className;
    }

    private RealmResults(BaseRealm realm, TableOrView table, Class<E> classSpec) {
        this.realm = realm;
        this.classSpec = classSpec;
        this.table = table;
        this.pendingQuery = null;
        this.query = null;
        this.currentTableViewVersion = table.syncIfNeeded();
    }

    private RealmResults(BaseRealm realm, String className) {
        this.realm = realm;
        this.className = className;
        this.pendingQuery = null;
        this.query = null;
    }

    private RealmResults(BaseRealm realm, TableOrView table, String className) {
        this(realm, className);
        this.table = table;
        this.currentTableViewVersion = table.syncIfNeeded();
    }

    TableOrView getTableOrView() {
        if (this.table == null) {
            return this.realm.schema.getTable(this.classSpec);
        }
        return this.table;
    }

    @Override
    public boolean isValid() {
        return !this.realm.isClosed();
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public RealmQuery<E> where() {
        this.realm.checkIfValid();
        return RealmQuery.createQueryFromResult(this);
    }

    @Override
    public boolean contains(Object object) {
        boolean contains = false;
        if (this.isLoaded() && object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            if (this.realm.getPath().equals(proxy.realmGet$proxyState().getRealm$realm().getPath()) && proxy.realmGet$proxyState().getRow$realm() != InvalidRow.INSTANCE) {
                contains = this.table.sourceRowIndex(proxy.realmGet$proxyState().getRow$realm().getIndex()) != -1L;
            }
        }
        return contains;
    }

    @Override
    public E get(int location) {
        this.realm.checkIfValid();
        TableOrView table = this.getTableOrView();
        E obj = table instanceof TableView ? this.realm.get(this.classSpec, this.className, ((TableView)table).getSourceRowIndex(location)) : this.realm.get(this.classSpec, this.className, location);
        return obj;
    }

    @Override
    public E first() {
        if (this.size() > 0) {
            return (E)this.get(0);
        }
        throw new IndexOutOfBoundsException("No results were found.");
    }

    @Override
    public E last() {
        int size = this.size();
        if (size > 0) {
            return (E)this.get(size - 1);
        }
        throw new IndexOutOfBoundsException("No results were found.");
    }

    @Override
    public void deleteFromRealm(int location) {
        this.realm.checkIfValid();
        TableOrView table = this.getTableOrView();
        table.remove(location);
    }

    @Override
    public boolean deleteAllFromRealm() {
        this.realm.checkIfValid();
        if (this.size() > 0) {
            TableOrView table = this.getTableOrView();
            table.clear();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        if (!this.isLoaded()) {
            return Collections.emptyList().iterator();
        }
        return new RealmResultsIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        if (!this.isLoaded()) {
            return Collections.emptyList().listIterator();
        }
        return new RealmResultsListIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int location) {
        if (!this.isLoaded()) {
            return Collections.emptyList().listIterator(location);
        }
        return new RealmResultsListIterator(location);
    }

    private long getColumnIndexForSort(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException("Non-empty field name required.");
        }
        if (fieldName.contains(".")) {
            throw new IllegalArgumentException("Sorting using child object fields is not supported: " + fieldName);
        }
        long columnIndex = this.table.getColumnIndex(fieldName);
        if (columnIndex < 0L) {
            throw new IllegalArgumentException(String.format("Field '%s' does not exist.", fieldName));
        }
        return columnIndex;
    }

    @Override
    public RealmResults<E> sort(String fieldName) {
        return this.sort(fieldName, Sort.ASCENDING);
    }

    @Override
    public RealmResults<E> sort(String fieldName, Sort sortOrder) {
        return this.where().findAllSorted(fieldName, sortOrder);
    }

    @Override
    public RealmResults<E> sort(String[] fieldNames, Sort[] sortOrders) {
        return this.where().findAllSorted(fieldNames, sortOrders);
    }

    @Override
    public RealmResults<E> sort(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        return this.sort(new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    @Override
    public int size() {
        if (!this.isLoaded()) {
            return 0;
        }
        long size = this.getTableOrView().size();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    @Override
    public Number min(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.getColumnIndexForSort(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.table.minimumLong(columnIndex);
            }
            case FLOAT: {
                return this.table.minimumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.table.minimumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    @Override
    public Date minDate(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.getColumnIndexForSort(fieldName);
        if (this.table.getColumnType(columnIndex) == RealmFieldType.DATE) {
            return this.table.minimumDate(columnIndex);
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "Date"));
    }

    @Override
    public Number max(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.getColumnIndexForSort(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.table.maximumLong(columnIndex);
            }
            case FLOAT: {
                return this.table.maximumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.table.maximumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    @Override
    public Date maxDate(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.getColumnIndexForSort(fieldName);
        if (this.table.getColumnType(columnIndex) == RealmFieldType.DATE) {
            return this.table.maximumDate(columnIndex);
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "Date"));
    }

    @Override
    public Number sum(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.getColumnIndexForSort(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.table.sumLong(columnIndex);
            }
            case FLOAT: {
                return this.table.sumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.table.sumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    @Override
    public double average(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.getColumnIndexForSort(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.table.averageLong(columnIndex);
            }
            case DOUBLE: {
                return this.table.averageDouble(columnIndex);
            }
            case FLOAT: {
                return this.table.averageFloat(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public RealmResults<E> distinct(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = RealmQuery.getAndValidateDistinctColumnIndex(fieldName, this.table.getTable());
        TableOrView tableOrView = this.getTableOrView();
        if (tableOrView instanceof Table) {
            this.table = ((Table)tableOrView).getDistinctView(columnIndex);
        } else {
            ((TableView)tableOrView).distinct(columnIndex);
        }
        return this;
    }

    public RealmResults<E> distinctAsync(String fieldName) {
        return this.where().distinctAsync(fieldName);
    }

    public RealmResults<E> distinct(String firstFieldName, String ... remainingFieldNames) {
        return this.where().distinct(firstFieldName, remainingFieldNames);
    }

    @Override
    @Deprecated
    public E remove(int index) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean remove(Object object) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public E set(int location, E object) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public boolean deleteLastFromRealm() {
        this.realm.checkIfValid();
        if (this.size() > 0) {
            TableOrView table = this.getTableOrView();
            table.removeLast();
            return true;
        }
        return false;
    }

    void syncIfNeeded() {
        long newVersion = this.table.syncIfNeeded();
        this.viewUpdated = newVersion != this.currentTableViewVersion;
        this.currentTableViewVersion = newVersion;
    }

    @Override
    public boolean deleteFirstFromRealm() {
        if (this.size() > 0) {
            TableOrView table = this.getTableOrView();
            table.removeFirst();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean add(E element) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public void add(int index, E element) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean addAll(int location, Collection<? extends E> collection) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    void swapTableViewPointer(long handoverTableViewPointer) {
        try {
            this.table = this.query.importHandoverTableView(handoverTableViewPointer, this.realm.sharedRealm);
            this.asyncQueryCompleted = true;
        }
        catch (BadVersionException e) {
            throw new IllegalStateException("Caller and Worker Realm should have been at the same version");
        }
    }

    void setPendingQuery(Future<Long> pendingQuery) {
        this.pendingQuery = pendingQuery;
        if (this.isLoaded()) {
            this.onAsyncQueryCompleted();
        }
    }

    @Override
    public boolean isLoaded() {
        this.realm.checkIfValid();
        return this.pendingQuery == null || this.asyncQueryCompleted;
    }

    @Override
    public boolean load() {
        if (this.isLoaded()) {
            return true;
        }
        return this.onAsyncQueryCompleted();
    }

    private boolean onAsyncQueryCompleted() {
        try {
            long tvHandover = this.pendingQuery.get();
            this.table = this.query.importHandoverTableView(tvHandover, this.realm.sharedRealm);
            this.asyncQueryCompleted = true;
            this.notifyChangeListeners(true);
        }
        catch (Exception e) {
            RealmLog.debug(e.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }

    public void addChangeListener(RealmChangeListener<RealmResults<E>> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        this.realm.checkIfValid();
        if (!this.realm.handlerController.isAutoRefreshEnabled()) {
            throw new IllegalStateException("You can't register a listener from a non-Looper thread or IntentService thread. ");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(RealmChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        this.realm.checkIfValid();
        this.listeners.remove(listener);
    }

    public void removeChangeListeners() {
        this.realm.checkIfValid();
        this.listeners.clear();
    }

    public Observable<RealmResults<E>> asObservable() {
        if (this.realm instanceof Realm) {
            return this.realm.configuration.getRxFactory().from((Realm)this.realm, this);
        }
        if (this.realm instanceof DynamicRealm) {
            DynamicRealm dynamicRealm = (DynamicRealm)this.realm;
            RealmResults dynamicResults = this;
            Observable<RealmResults<DynamicRealmObject>> results = this.realm.configuration.getRxFactory().from(dynamicRealm, dynamicResults);
            return results;
        }
        throw new UnsupportedOperationException(this.realm.getClass() + " does not support RxJava.");
    }

    void notifyChangeListeners(boolean forceNotify) {
        if (!this.listeners.isEmpty()) {
            if (this.pendingQuery != null && !this.asyncQueryCompleted) {
                return;
            }
            if (!this.viewUpdated && !forceNotify) {
                return;
            }
            this.viewUpdated = false;
            for (RealmChangeListener<RealmResults<E>> listener : this.listeners) {
                listener.onChange(this);
            }
        }
    }

    private class RealmResultsListIterator
    extends RealmResultsIterator
    implements ListIterator<E> {
        RealmResultsListIterator(int start) {
            if (start < 0 || start > RealmResults.this.size()) {
                throw new IndexOutOfBoundsException("Starting location must be a valid index: [0, " + (RealmResults.this.size() - 1) + "]. Yours was " + start);
            }
            this.pos = start - 1;
        }

        @Override
        @Deprecated
        public void add(E object) {
            throw new UnsupportedOperationException("Adding an element is not supported. Use Realm.createObject() instead.");
        }

        @Override
        public boolean hasPrevious() {
            return this.pos >= 0;
        }

        @Override
        public int nextIndex() {
            return this.pos + 1;
        }

        @Override
        public E previous() {
            RealmResults.this.realm.checkIfValid();
            this.checkRealmIsStable();
            try {
                Object obj = RealmResults.this.get(this.pos);
                --this.pos;
                return obj;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("Cannot access index less than zero. This was " + this.pos + ". Remember to check hasPrevious() before using previous().");
            }
        }

        @Override
        public int previousIndex() {
            return this.pos;
        }

        @Override
        @Deprecated
        public void set(E object) {
            throw new UnsupportedOperationException("Replacing and element is not supported.");
        }
    }

    private class RealmResultsIterator
    implements Iterator<E> {
        long tableViewVersion = 0L;
        int pos = -1;

        RealmResultsIterator() {
            this.tableViewVersion = RealmResults.this.currentTableViewVersion;
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < RealmResults.this.size();
        }

        @Override
        public E next() {
            RealmResults.this.realm.checkIfValid();
            this.checkRealmIsStable();
            ++this.pos;
            if (this.pos >= RealmResults.this.size()) {
                throw new NoSuchElementException("Cannot access index " + this.pos + " when size is " + RealmResults.this.size() + ". Remember to check hasNext() before using next().");
            }
            return RealmResults.this.get(this.pos);
        }

        @Override
        @Deprecated
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported by RealmResults iterators.");
        }

        protected void checkRealmIsStable() {
            long version = RealmResults.this.table.getVersion();
            if (!RealmResults.this.realm.isInTransaction() && this.tableViewVersion > -1L && version != this.tableViewVersion) {
                throw new ConcurrentModificationException("No outside changes to a Realm is allowed while iterating a RealmResults. Don't call Realm.refresh() while iterating.");
            }
            this.tableViewVersion = version;
        }
    }
}

