/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.FieldAttribute;
import io.realm.Property;
import io.realm.RealmFieldType;
import io.realm.RealmList;
import io.realm.RealmObject;
import io.realm.internal.Table;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class RealmObjectSchema {
    private static final Map<Class<?>, FieldMetaData> SUPPORTED_SIMPLE_FIELDS = new HashMap();
    private static final Map<Class<?>, FieldMetaData> SUPPORTED_LINKED_FIELDS;
    private final BaseRealm realm;
    final Table table;
    private final Map<String, Long> columnIndices;
    private final long nativePtr;

    RealmObjectSchema(BaseRealm realm, Table table, Map<String, Long> columnIndices) {
        this.realm = realm;
        this.table = table;
        this.columnIndices = columnIndices;
        this.nativePtr = 0L;
    }

    RealmObjectSchema(String className) {
        this.realm = null;
        this.table = null;
        this.columnIndices = null;
        this.nativePtr = RealmObjectSchema.nativeCreateRealmObjectSchema(className);
    }

    protected RealmObjectSchema(long nativePtr) {
        this.realm = null;
        this.table = null;
        this.columnIndices = null;
        this.nativePtr = nativePtr;
    }

    public void close() {
        if (this.nativePtr != 0L) {
            Set<Property> properties = this.getProperties();
            for (Property property : properties) {
                property.close();
            }
            RealmObjectSchema.nativeClose(this.nativePtr);
        }
    }

    protected long getNativePtr() {
        return this.nativePtr;
    }

    public String getClassName() {
        if (this.realm == null) {
            return RealmObjectSchema.nativeGetClassName(this.nativePtr);
        }
        return this.table.getName().substring(Table.TABLE_PREFIX.length());
    }

    public RealmObjectSchema setClassName(String className) {
        this.realm.checkNotInSync();
        this.checkEmpty(className);
        String internalTableName = Table.TABLE_PREFIX + className;
        if (internalTableName.length() > 56) {
            throw new IllegalArgumentException("Class name is to long. Limit is 56 characters: '" + className + "' (" + Integer.toString(className.length()) + ")");
        }
        if (this.realm.sharedRealm.hasTable(internalTableName)) {
            throw new IllegalArgumentException("Class already exists: " + className);
        }
        String oldTableName = null;
        String pkField = null;
        if (this.table.hasPrimaryKey()) {
            oldTableName = this.table.getName();
            pkField = this.getPrimaryKey();
            this.table.setPrimaryKey(null);
        }
        this.realm.sharedRealm.renameTable(this.table.getName(), internalTableName);
        if (pkField != null && !pkField.isEmpty()) {
            try {
                this.table.setPrimaryKey(pkField);
            }
            catch (Exception e) {
                this.realm.sharedRealm.renameTable(this.table.getName(), oldTableName);
                throw e;
            }
        }
        return this;
    }

    public RealmObjectSchema addField(String fieldName, Class<?> fieldType, FieldAttribute ... attributes) {
        FieldMetaData metadata = SUPPORTED_SIMPLE_FIELDS.get(fieldType);
        if (metadata == null) {
            if (SUPPORTED_LINKED_FIELDS.containsKey(fieldType)) {
                throw new IllegalArgumentException("Use addRealmObjectField() instead to add fields that link to other RealmObjects: " + fieldName);
            }
            throw new IllegalArgumentException(String.format("Realm doesn't support this field type: %s(%s)", fieldName, fieldType));
        }
        this.checkNewFieldName(fieldName);
        boolean nullable = metadata.defaultNullable;
        if (this.containsAttribute(attributes, FieldAttribute.REQUIRED)) {
            nullable = false;
        }
        long columnIndex = this.table.addColumn(metadata.realmType, fieldName, nullable);
        try {
            this.addModifiers(fieldName, attributes);
        }
        catch (Exception e) {
            this.table.removeColumn(columnIndex);
            throw e;
        }
        return this;
    }

    public RealmObjectSchema addRealmObjectField(String fieldName, RealmObjectSchema objectSchema) {
        this.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
        this.table.addColumnLink(RealmFieldType.OBJECT, fieldName, this.realm.sharedRealm.getTable(Table.TABLE_PREFIX + objectSchema.getClassName()));
        return this;
    }

    public RealmObjectSchema addRealmListField(String fieldName, RealmObjectSchema objectSchema) {
        this.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
        this.table.addColumnLink(RealmFieldType.LIST, fieldName, this.realm.sharedRealm.getTable(Table.TABLE_PREFIX + objectSchema.getClassName()));
        return this;
    }

    protected RealmObjectSchema add(Property property) {
        if (this.realm != null && this.nativePtr == 0L) {
            throw new IllegalArgumentException("Don't use this method.");
        }
        RealmObjectSchema.nativeAddProperty(this.nativePtr, property.getNativePtr());
        return this;
    }

    private Set<Property> getProperties() {
        if (this.realm == null) {
            long[] ptrs = RealmObjectSchema.nativeGetProperties(this.nativePtr);
            LinkedHashSet<Property> properties = new LinkedHashSet<Property>(ptrs.length);
            for (int i = 0; i < ptrs.length; ++i) {
                properties.add(new Property(ptrs[i]));
            }
            return properties;
        }
        throw new IllegalArgumentException("Not possible");
    }

    public RealmObjectSchema removeField(String fieldName) {
        this.realm.checkNotInSync();
        this.checkLegalName(fieldName);
        if (!this.hasField(fieldName)) {
            throw new IllegalStateException(fieldName + " does not exist.");
        }
        long columnIndex = this.getColumnIndex(fieldName);
        if (this.table.getPrimaryKey() == columnIndex) {
            this.table.setPrimaryKey(null);
        }
        this.table.removeColumn(columnIndex);
        return this;
    }

    public RealmObjectSchema renameField(String currentFieldName, String newFieldName) {
        this.realm.checkNotInSync();
        this.checkLegalName(currentFieldName);
        this.checkFieldExists(currentFieldName);
        this.checkLegalName(newFieldName);
        this.checkFieldNameIsAvailable(newFieldName);
        long columnIndex = this.getColumnIndex(currentFieldName);
        this.table.renameColumn(columnIndex, newFieldName);
        return this;
    }

    public boolean hasField(String fieldName) {
        return this.table.getColumnIndex(fieldName) != -1L;
    }

    public RealmObjectSchema addIndex(String fieldName) {
        this.checkLegalName(fieldName);
        this.checkFieldExists(fieldName);
        long columnIndex = this.getColumnIndex(fieldName);
        if (this.table.hasSearchIndex(columnIndex)) {
            throw new IllegalStateException(fieldName + " already has an index.");
        }
        this.table.addSearchIndex(columnIndex);
        return this;
    }

    public boolean hasIndex(String fieldName) {
        this.checkLegalName(fieldName);
        this.checkFieldExists(fieldName);
        return this.table.hasSearchIndex(this.table.getColumnIndex(fieldName));
    }

    public RealmObjectSchema removeIndex(String fieldName) {
        this.realm.checkNotInSync();
        this.checkLegalName(fieldName);
        this.checkFieldExists(fieldName);
        long columnIndex = this.getColumnIndex(fieldName);
        if (!this.table.hasSearchIndex(columnIndex)) {
            throw new IllegalStateException("Field is not indexed: " + fieldName);
        }
        this.table.removeSearchIndex(columnIndex);
        return this;
    }

    public RealmObjectSchema addPrimaryKey(String fieldName) {
        this.checkLegalName(fieldName);
        this.checkFieldExists(fieldName);
        if (this.table.hasPrimaryKey()) {
            throw new IllegalStateException("A primary key is already defined");
        }
        this.table.setPrimaryKey(fieldName);
        long columnIndex = this.getColumnIndex(fieldName);
        if (!this.table.hasSearchIndex(columnIndex)) {
            this.table.addSearchIndex(columnIndex);
        }
        return this;
    }

    public RealmObjectSchema removePrimaryKey() {
        this.realm.checkNotInSync();
        if (!this.table.hasPrimaryKey()) {
            throw new IllegalStateException(this.getClassName() + " doesn't have a primary key.");
        }
        long columnIndex = this.table.getPrimaryKey();
        if (this.table.hasSearchIndex(columnIndex)) {
            this.table.removeSearchIndex(columnIndex);
        }
        this.table.setPrimaryKey("");
        return this;
    }

    public RealmObjectSchema setRequired(String fieldName, boolean required) {
        long columnIndex = this.table.getColumnIndex(fieldName);
        boolean currentColumnRequired = this.isRequired(fieldName);
        RealmFieldType type = this.table.getColumnType(columnIndex);
        if (type == RealmFieldType.OBJECT) {
            throw new IllegalArgumentException("Cannot modify the required state for RealmObject references: " + fieldName);
        }
        if (type == RealmFieldType.LIST) {
            throw new IllegalArgumentException("Cannot modify the required state for RealmList references: " + fieldName);
        }
        if (required && currentColumnRequired) {
            throw new IllegalStateException("Field is already required: " + fieldName);
        }
        if (!required && !currentColumnRequired) {
            throw new IllegalStateException("Field is already nullable: " + fieldName);
        }
        if (required) {
            this.table.convertColumnToNotNullable(columnIndex);
        } else {
            this.table.convertColumnToNullable(columnIndex);
        }
        return this;
    }

    public RealmObjectSchema setNullable(String fieldName, boolean nullable) {
        this.setRequired(fieldName, !nullable);
        return this;
    }

    public boolean isRequired(String fieldName) {
        long columnIndex = this.getColumnIndex(fieldName);
        return !this.table.isColumnNullable(columnIndex);
    }

    public boolean isNullable(String fieldName) {
        long columnIndex = this.getColumnIndex(fieldName);
        return this.table.isColumnNullable(columnIndex);
    }

    public boolean isPrimaryKey(String fieldName) {
        long columnIndex = this.getColumnIndex(fieldName);
        return columnIndex == this.table.getPrimaryKey();
    }

    public boolean hasPrimaryKey() {
        return this.table.hasPrimaryKey();
    }

    public String getPrimaryKey() {
        if (!this.table.hasPrimaryKey()) {
            throw new IllegalStateException(this.getClassName() + " doesn't have a primary key.");
        }
        return this.table.getColumnName(this.table.getPrimaryKey());
    }

    public Set<String> getFieldNames() {
        int columnCount = (int)this.table.getColumnCount();
        LinkedHashSet<String> columnNames = new LinkedHashSet<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            columnNames.add(this.table.getColumnName(i));
        }
        return columnNames;
    }

    public RealmObjectSchema transform(Function function) {
        if (function != null) {
            long size = this.table.size();
            for (long i = 0L; i < size; ++i) {
                function.apply(new DynamicRealmObject(this.realm, this.table.getCheckedRow(i)));
            }
        }
        return this;
    }

    private void addModifiers(String fieldName, FieldAttribute[] attributes) {
        boolean indexAdded = false;
        try {
            if (attributes != null && attributes.length > 0) {
                if (this.containsAttribute(attributes, FieldAttribute.INDEXED)) {
                    this.addIndex(fieldName);
                    indexAdded = true;
                }
                if (this.containsAttribute(attributes, FieldAttribute.PRIMARY_KEY)) {
                    this.addPrimaryKey(fieldName);
                    indexAdded = true;
                }
            }
        }
        catch (Exception e) {
            long columnIndex = this.getColumnIndex(fieldName);
            if (indexAdded) {
                this.table.removeSearchIndex(columnIndex);
            }
            throw e;
        }
    }

    private boolean containsAttribute(FieldAttribute[] attributeList, FieldAttribute attribute) {
        if (attributeList == null || attributeList.length == 0) {
            return false;
        }
        for (int i = 0; i < attributeList.length; ++i) {
            if (attributeList[i] != attribute) continue;
            return true;
        }
        return false;
    }

    private void checkNewFieldName(String fieldName) {
        this.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
    }

    private void checkLegalName(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException("Field name can not be null or empty");
        }
        if (fieldName.contains(".")) {
            throw new IllegalArgumentException("Field name can not contain '.'");
        }
    }

    private void checkFieldNameIsAvailable(String fieldName) {
        if (this.table.getColumnIndex(fieldName) != -1L) {
            throw new IllegalArgumentException("Field already exists in '" + this.getClassName() + "': " + fieldName);
        }
    }

    private void checkFieldExists(String fieldName) {
        if (this.table.getColumnIndex(fieldName) == -1L) {
            throw new IllegalArgumentException("Field name doesn't exist on object '" + this.getClassName() + "': " + fieldName);
        }
    }

    private long getColumnIndex(String fieldName) {
        long columnIndex = this.table.getColumnIndex(fieldName);
        if (columnIndex == -1L) {
            throw new IllegalArgumentException(String.format("Field name '%s' does not exist on schema for '%s", fieldName, this.getClassName()));
        }
        return columnIndex;
    }

    private void checkEmpty(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("Null or empty class names are not allowed");
        }
    }

    long[] getColumnIndices(String fieldDescription, RealmFieldType ... validColumnTypes) {
        boolean checkColumnType;
        if (fieldDescription == null || fieldDescription.equals("")) {
            throw new IllegalArgumentException("Non-empty fieldname must be provided");
        }
        if (fieldDescription.startsWith(".") || fieldDescription.endsWith(".")) {
            throw new IllegalArgumentException("Illegal field name. It cannot start or end with a '.': " + fieldDescription);
        }
        Table table = this.table;
        boolean bl = checkColumnType = validColumnTypes != null && validColumnTypes.length > 0;
        if (fieldDescription.contains(".")) {
            long columnIndex;
            String[] names = fieldDescription.split("\\.");
            long[] columnIndices = new long[names.length];
            for (int i = 0; i < names.length - 1; ++i) {
                long index = table.getColumnIndex(names[i]);
                if (index < 0L) {
                    throw new IllegalArgumentException("Invalid query: " + names[i] + " does not refer to a class.");
                }
                RealmFieldType type = table.getColumnType(index);
                if (type != RealmFieldType.OBJECT && type != RealmFieldType.LIST) {
                    throw new IllegalArgumentException("Invalid query: " + names[i] + " does not refer to a class.");
                }
                table = table.getLinkTarget(index);
                columnIndices[i] = index;
            }
            String columnName = names[names.length - 1];
            columnIndices[names.length - 1] = columnIndex = table.getColumnIndex(columnName);
            if (columnIndex < 0L) {
                throw new IllegalArgumentException(columnName + " is not a field name in class " + table.getName());
            }
            if (checkColumnType && !this.isValidType(table.getColumnType(columnIndex), validColumnTypes)) {
                throw new IllegalArgumentException(String.format("Field '%s': type mismatch.", names[names.length - 1]));
            }
            return columnIndices;
        }
        Long fieldIndex = this.getFieldIndex(fieldDescription);
        if (fieldIndex == null) {
            throw new IllegalArgumentException(String.format("Field '%s' does not exist.", fieldDescription));
        }
        RealmFieldType tableColumnType = table.getColumnType(fieldIndex);
        if (checkColumnType && !this.isValidType(tableColumnType, validColumnTypes)) {
            throw new IllegalArgumentException(String.format("Field '%s': type mismatch. Was %s, expected %s.", new Object[]{fieldDescription, tableColumnType, Arrays.toString((Object[])validColumnTypes)}));
        }
        return new long[]{fieldIndex};
    }

    private boolean isValidType(RealmFieldType columnType, RealmFieldType[] validColumnTypes) {
        for (int i = 0; i < validColumnTypes.length; ++i) {
            if (validColumnTypes[i] != columnType) continue;
            return true;
        }
        return false;
    }

    Long getFieldIndex(String fieldName) {
        return this.columnIndices.get(fieldName);
    }

    long getAndCheckFieldIndex(String fieldName) {
        Long index = this.columnIndices.get(fieldName);
        if (index == null) {
            throw new IllegalArgumentException("Field does not exist: " + fieldName);
        }
        return index;
    }

    public RealmFieldType getFieldType(String fieldName) {
        long columnIndex = this.getColumnIndex(fieldName);
        return this.table.getColumnType(columnIndex);
    }

    static native long nativeCreateRealmObjectSchema(String var0);

    static native void nativeAddProperty(long var0, long var2);

    static native long[] nativeGetProperties(long var0);

    static native void nativeClose(long var0);

    static native String nativeGetClassName(long var0);

    static {
        SUPPORTED_SIMPLE_FIELDS.put(String.class, new FieldMetaData(RealmFieldType.STRING, true));
        SUPPORTED_SIMPLE_FIELDS.put(Short.TYPE, new FieldMetaData(RealmFieldType.INTEGER, false));
        SUPPORTED_SIMPLE_FIELDS.put(Short.class, new FieldMetaData(RealmFieldType.INTEGER, true));
        SUPPORTED_SIMPLE_FIELDS.put(Integer.TYPE, new FieldMetaData(RealmFieldType.INTEGER, false));
        SUPPORTED_SIMPLE_FIELDS.put(Integer.class, new FieldMetaData(RealmFieldType.INTEGER, true));
        SUPPORTED_SIMPLE_FIELDS.put(Long.TYPE, new FieldMetaData(RealmFieldType.INTEGER, false));
        SUPPORTED_SIMPLE_FIELDS.put(Long.class, new FieldMetaData(RealmFieldType.INTEGER, true));
        SUPPORTED_SIMPLE_FIELDS.put(Float.TYPE, new FieldMetaData(RealmFieldType.FLOAT, false));
        SUPPORTED_SIMPLE_FIELDS.put(Float.class, new FieldMetaData(RealmFieldType.FLOAT, true));
        SUPPORTED_SIMPLE_FIELDS.put(Double.TYPE, new FieldMetaData(RealmFieldType.DOUBLE, false));
        SUPPORTED_SIMPLE_FIELDS.put(Double.class, new FieldMetaData(RealmFieldType.DOUBLE, true));
        SUPPORTED_SIMPLE_FIELDS.put(Boolean.TYPE, new FieldMetaData(RealmFieldType.BOOLEAN, false));
        SUPPORTED_SIMPLE_FIELDS.put(Boolean.class, new FieldMetaData(RealmFieldType.BOOLEAN, true));
        SUPPORTED_SIMPLE_FIELDS.put(Byte.TYPE, new FieldMetaData(RealmFieldType.INTEGER, false));
        SUPPORTED_SIMPLE_FIELDS.put(Byte.class, new FieldMetaData(RealmFieldType.INTEGER, true));
        SUPPORTED_SIMPLE_FIELDS.put(byte[].class, new FieldMetaData(RealmFieldType.BINARY, true));
        SUPPORTED_SIMPLE_FIELDS.put(Date.class, new FieldMetaData(RealmFieldType.DATE, true));
        SUPPORTED_LINKED_FIELDS = new HashMap();
        SUPPORTED_LINKED_FIELDS.put(RealmObject.class, new FieldMetaData(RealmFieldType.OBJECT, false));
        SUPPORTED_LINKED_FIELDS.put(RealmList.class, new FieldMetaData(RealmFieldType.LIST, false));
    }

    static final class DynamicColumnMap
    implements Map<String, Long> {
        private final Table table;

        public DynamicColumnMap(Table table) {
            this.table = table;
        }

        @Override
        public Long get(Object key) {
            long ret = this.table.getColumnIndex((String)key);
            return ret < 0L ? null : Long.valueOf(ret);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Long>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long put(String key, Long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Long> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Long> values() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FieldMetaData {
        public final RealmFieldType realmType;
        public final boolean defaultNullable;

        public FieldMetaData(RealmFieldType realmType, boolean defaultNullable) {
            this.realmType = realmType;
            this.defaultNullable = defaultNullable;
        }
    }

    public static interface Function {
        public void apply(DynamicRealmObject var1);
    }
}

