/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmModel;
import io.realm.annotations.RealmClass;
import io.realm.internal.InvalidRow;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import java.util.List;
import rx.Observable;

@RealmClass
public abstract class RealmObject
implements RealmModel {
    public final void deleteFromRealm() {
        RealmObject.deleteFromRealm(this);
    }

    public static <E extends RealmModel> void deleteFromRealm(E object) {
        if (!(object instanceof RealmObjectProxy)) {
            throw new IllegalArgumentException("Object not managed by Realm, so it cannot be removed.");
        }
        RealmObjectProxy proxy = (RealmObjectProxy)object;
        if (proxy.realmGet$proxyState().getRow$realm() == null) {
            throw new IllegalStateException("Object malformed: missing object in Realm. Make sure to instantiate RealmObjects with Realm.createObject()");
        }
        if (proxy.realmGet$proxyState().getRealm$realm() == null) {
            throw new IllegalStateException("Object malformed: missing Realm. Make sure to instantiate RealmObjects with Realm.createObject()");
        }
        proxy.realmGet$proxyState().getRealm$realm().checkIfValid();
        Row row = proxy.realmGet$proxyState().getRow$realm();
        row.getTable().moveLastOver(row.getIndex());
        proxy.realmGet$proxyState().setRow$realm(InvalidRow.INSTANCE);
    }

    public final boolean isValid() {
        return RealmObject.isValid(this);
    }

    public static <E extends RealmModel> boolean isValid(E object) {
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            Row row = proxy.realmGet$proxyState().getRow$realm();
            return row != null && row.isAttached();
        }
        return true;
    }

    public final boolean isLoaded() {
        return RealmObject.isLoaded(this);
    }

    public static <E extends RealmModel> boolean isLoaded(E object) {
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            proxy.realmGet$proxyState().getRealm$realm().checkIfValid();
            return proxy.realmGet$proxyState().getPendingQuery$realm() == null || proxy.realmGet$proxyState().isCompleted$realm();
        }
        return true;
    }

    public boolean isManaged() {
        return RealmObject.isManaged(this);
    }

    public static <E extends RealmModel> boolean isManaged(E object) {
        return object instanceof RealmObjectProxy;
    }

    public final boolean load() {
        return RealmObject.load(this);
    }

    public static <E extends RealmModel> boolean load(E object) {
        if (RealmObject.isLoaded(object)) {
            return true;
        }
        if (object instanceof RealmObjectProxy) {
            return ((RealmObjectProxy)object).realmGet$proxyState().onCompleted$realm();
        }
        return false;
    }

    public final <E extends RealmModel> void addChangeListener(RealmChangeListener<E> listener) {
        RealmObject.addChangeListener(this, listener);
    }

    public static <E extends RealmModel> void addChangeListener(E object, RealmChangeListener<E> listener) {
        if (object == null) {
            throw new IllegalArgumentException("Object should not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            BaseRealm realm = proxy.realmGet$proxyState().getRealm$realm();
            realm.checkIfValid();
            if (!realm.handlerController.isAutoRefreshEnabled()) {
                throw new IllegalStateException("You can't register a listener from a non-Looper thread or IntentService thread.");
            }
            List<RealmChangeListener<RealmChangeListener<E>>> listeners = proxy.realmGet$proxyState().getListeners$realm();
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
            if (RealmObject.isLoaded(proxy)) {
                realm.handlerController.addToRealmObjects(proxy);
            }
        } else {
            throw new IllegalArgumentException("Cannot add listener from this unmanaged RealmObject (created outside of Realm)");
        }
    }

    public final void removeChangeListener(RealmChangeListener listener) {
        RealmObject.removeChangeListener(this, listener);
    }

    public static <E extends RealmModel> void removeChangeListener(E object, RealmChangeListener listener) {
        if (object == null) {
            throw new IllegalArgumentException("Object should not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        if (!(object instanceof RealmObjectProxy)) {
            throw new IllegalArgumentException("Cannot remove listener from this unmanaged RealmObject (created outside of Realm)");
        }
        RealmObjectProxy proxy = (RealmObjectProxy)object;
        proxy.realmGet$proxyState().getRealm$realm().checkIfValid();
        proxy.realmGet$proxyState().getListeners$realm().remove(listener);
    }

    public final void removeChangeListeners() {
        RealmObject.removeChangeListeners(this);
    }

    public static <E extends RealmModel> void removeChangeListeners(E object) {
        if (!(object instanceof RealmObjectProxy)) {
            throw new IllegalArgumentException("Cannot remove listeners from this unmanaged RealmObject (created outside of Realm)");
        }
        RealmObjectProxy proxy = (RealmObjectProxy)object;
        proxy.realmGet$proxyState().getRealm$realm().checkIfValid();
        proxy.realmGet$proxyState().getListeners$realm().clear();
    }

    public final <E extends RealmObject> Observable<E> asObservable() {
        return RealmObject.asObservable(this);
    }

    public static <E extends RealmModel> Observable<E> asObservable(E object) {
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            BaseRealm realm = proxy.realmGet$proxyState().getRealm$realm();
            if (realm instanceof Realm) {
                return realm.configuration.getRxFactory().from((Realm)realm, object);
            }
            if (realm instanceof DynamicRealm) {
                DynamicRealm dynamicRealm = (DynamicRealm)realm;
                DynamicRealmObject dynamicObject = (DynamicRealmObject)object;
                Observable<DynamicRealmObject> observable = realm.configuration.getRxFactory().from(dynamicRealm, dynamicObject);
                return observable;
            }
            throw new UnsupportedOperationException(realm.getClass() + " does not support RxJava." + " See https://realm.io/docs/java/latest/#rxjava for more details.");
        }
        throw new IllegalArgumentException("Cannot create Observables from unmanaged RealmObjects");
    }
}

