/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.internal.Keep;
import java.nio.ByteBuffer;
import java.util.Date;

@Keep
public enum RealmFieldType {
    INTEGER(0),
    BOOLEAN(1),
    STRING(2),
    BINARY(4),
    UNSUPPORTED_TABLE(5),
    UNSUPPORTED_MIXED(6),
    UNSUPPORTED_DATE(7),
    DATE(8),
    FLOAT(9),
    DOUBLE(10),
    OBJECT(12),
    LIST(13);

    private static RealmFieldType[] typeList;
    private final int nativeValue;

    private RealmFieldType(int nativeValue) {
        this.nativeValue = nativeValue;
    }

    public int getNativeValue() {
        return this.nativeValue;
    }

    public boolean isValid(Object obj) {
        switch (this.nativeValue) {
            case 0: {
                return obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte;
            }
            case 1: {
                return obj instanceof Boolean;
            }
            case 2: {
                return obj instanceof String;
            }
            case 4: {
                return obj instanceof byte[] || obj instanceof ByteBuffer;
            }
            case 5: {
                return obj == null || obj instanceof Object[][];
            }
            case 7: {
                return obj instanceof Date;
            }
            case 8: {
                return obj instanceof Date;
            }
            case 9: {
                return obj instanceof Float;
            }
            case 10: {
                return obj instanceof Double;
            }
            case 12: {
                return false;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
        }
        throw new RuntimeException("Unsupported Realm type:  " + (Object)((Object)this));
    }

    public static RealmFieldType fromNativeValue(int value) {
        RealmFieldType e;
        if (0 <= value && value < typeList.length && (e = typeList[value]) != null) {
            return e;
        }
        throw new IllegalArgumentException("Invalid native Realm type: " + value);
    }

    static {
        typeList = new RealmFieldType[15];
        RealmFieldType[] columnTypes = RealmFieldType.values();
        for (int i = 0; i < columnTypes.length; ++i) {
            int v = columnTypes[i].nativeValue;
            RealmFieldType.typeList[v] = columnTypes[i];
        }
    }
}

