/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.content.Context;
import android.text.TextUtils;
import io.realm.BaseRealm;
import io.realm.Realm;
import io.realm.RealmMigration;
import io.realm.RealmModel;
import io.realm.annotations.RealmModule;
import io.realm.exceptions.RealmException;
import io.realm.exceptions.RealmFileException;
import io.realm.internal.RealmCore;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.SharedRealm;
import io.realm.internal.modules.CompositeMediator;
import io.realm.internal.modules.FilterableMediator;
import io.realm.rx.RealmObservableFactory;
import io.realm.rx.RxObservableFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RealmConfiguration {
    public static final String DEFAULT_REALM_NAME = "default.realm";
    public static final int KEY_LENGTH = 64;
    private static final Object DEFAULT_MODULE = Realm.getDefaultModule();
    private static final RealmProxyMediator DEFAULT_MODULE_MEDIATOR;
    private static Boolean rxJavaAvailable;
    private final File realmDirectory;
    private final String realmFileName;
    private final String canonicalPath;
    private final String assetFilePath;
    private final byte[] key;
    private final long schemaVersion;
    private final RealmMigration migration;
    private final boolean deleteRealmIfMigrationNeeded;
    private final SharedRealm.Durability durability;
    private final RealmProxyMediator schemaMediator;
    private final RxObservableFactory rxObservableFactory;
    private final Realm.Transaction initialDataTransaction;

    protected RealmConfiguration(File realmDirectory, String realmFileName, String canonicalPath, String assetFilePath, byte[] key, long schemaVersion, RealmMigration migration, boolean deleteRealmIfMigrationNeeded, SharedRealm.Durability durability, RealmProxyMediator schemaMediator, RxObservableFactory rxObservableFactory, Realm.Transaction initialDataTransaction) {
        this.realmDirectory = realmDirectory;
        this.realmFileName = realmFileName;
        this.canonicalPath = canonicalPath;
        this.assetFilePath = assetFilePath;
        this.key = key;
        this.schemaVersion = schemaVersion;
        this.migration = migration;
        this.deleteRealmIfMigrationNeeded = deleteRealmIfMigrationNeeded;
        this.durability = durability;
        this.schemaMediator = schemaMediator;
        this.rxObservableFactory = rxObservableFactory;
        this.initialDataTransaction = initialDataTransaction;
    }

    public File getRealmDirectory() {
        return this.realmDirectory;
    }

    public String getRealmFileName() {
        return this.realmFileName;
    }

    public byte[] getEncryptionKey() {
        return this.key == null ? null : Arrays.copyOf(this.key, this.key.length);
    }

    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    public RealmMigration getMigration() {
        return this.migration;
    }

    public boolean shouldDeleteRealmIfMigrationNeeded() {
        return this.deleteRealmIfMigrationNeeded;
    }

    public SharedRealm.Durability getDurability() {
        return this.durability;
    }

    RealmProxyMediator getSchemaMediator() {
        return this.schemaMediator;
    }

    Realm.Transaction getInitialDataTransaction() {
        return this.initialDataTransaction;
    }

    boolean hasAssetFile() {
        return !TextUtils.isEmpty((CharSequence)this.assetFilePath);
    }

    InputStream getAssetFile() throws IOException {
        return BaseRealm.applicationContext.getAssets().open(this.assetFilePath);
    }

    public Set<Class<? extends RealmModel>> getRealmObjectClasses() {
        return this.schemaMediator.getModelClasses();
    }

    public String getPath() {
        return this.canonicalPath;
    }

    public RxObservableFactory getRxFactory() {
        if (this.rxObservableFactory == null) {
            throw new UnsupportedOperationException("RxJava seems to be missing from the classpath. Remember to add it as a compile dependency. See https://realm.io/docs/java/latest/#rxjava for more details.");
        }
        return this.rxObservableFactory;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RealmConfiguration that = (RealmConfiguration)obj;
        if (this.schemaVersion != that.schemaVersion) {
            return false;
        }
        if (this.deleteRealmIfMigrationNeeded != that.deleteRealmIfMigrationNeeded) {
            return false;
        }
        if (!this.realmDirectory.equals(that.realmDirectory)) {
            return false;
        }
        if (!this.realmFileName.equals(that.realmFileName)) {
            return false;
        }
        if (!this.canonicalPath.equals(that.canonicalPath)) {
            return false;
        }
        if (!Arrays.equals(this.key, that.key)) {
            return false;
        }
        if (!this.durability.equals((Object)that.durability)) {
            return false;
        }
        if (this.migration != null ? !this.migration.equals(that.migration) : that.migration != null) {
            return false;
        }
        if (this.rxObservableFactory != null ? !this.rxObservableFactory.equals(that.rxObservableFactory) : that.rxObservableFactory != null) {
            return false;
        }
        if (this.initialDataTransaction != null ? !this.initialDataTransaction.equals(that.initialDataTransaction) : that.initialDataTransaction != null) {
            return false;
        }
        return this.schemaMediator.equals(that.schemaMediator);
    }

    public int hashCode() {
        int result = this.realmDirectory.hashCode();
        result = 31 * result + this.realmFileName.hashCode();
        result = 31 * result + this.canonicalPath.hashCode();
        result = 31 * result + (this.key != null ? Arrays.hashCode(this.key) : 0);
        result = 31 * result + (int)this.schemaVersion;
        result = 31 * result + (this.migration != null ? this.migration.hashCode() : 0);
        result = 31 * result + (this.deleteRealmIfMigrationNeeded ? 1 : 0);
        result = 31 * result + this.schemaMediator.hashCode();
        result = 31 * result + this.durability.hashCode();
        result = 31 * result + (this.rxObservableFactory != null ? this.rxObservableFactory.hashCode() : 0);
        result = 31 * result + (this.initialDataTransaction != null ? this.initialDataTransaction.hashCode() : 0);
        return result;
    }

    protected static RealmProxyMediator createSchemaMediator(Set<Object> modules, Set<Class<? extends RealmModel>> debugSchema) {
        if (debugSchema.size() > 0) {
            return new FilterableMediator(DEFAULT_MODULE_MEDIATOR, debugSchema);
        }
        if (modules.size() == 1) {
            return RealmConfiguration.getModuleMediator(modules.iterator().next().getClass().getCanonicalName());
        }
        RealmProxyMediator[] mediators = new RealmProxyMediator[modules.size()];
        int i = 0;
        for (Object module : modules) {
            mediators[i] = RealmConfiguration.getModuleMediator(module.getClass().getCanonicalName());
            ++i;
        }
        return new CompositeMediator(mediators);
    }

    private static RealmProxyMediator getModuleMediator(String fullyQualifiedModuleClassName) {
        String[] moduleNameParts = fullyQualifiedModuleClassName.split("\\.");
        String moduleSimpleName = moduleNameParts[moduleNameParts.length - 1];
        String mediatorName = String.format("io.realm.%s%s", moduleSimpleName, "Mediator");
        try {
            Class<?> clazz = Class.forName(mediatorName);
            Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            return (RealmProxyMediator)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RealmException("Could not find " + mediatorName, e);
        }
        catch (InvocationTargetException e) {
            throw new RealmException("Could not create an instance of " + mediatorName, e);
        }
        catch (InstantiationException e) {
            throw new RealmException("Could not create an instance of " + mediatorName, e);
        }
        catch (IllegalAccessException e) {
            throw new RealmException("Could not create an instance of " + mediatorName, e);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("realmDirectory: ").append(this.realmDirectory.toString());
        stringBuilder.append("\n");
        stringBuilder.append("realmFileName : ").append(this.realmFileName);
        stringBuilder.append("\n");
        stringBuilder.append("canonicalPath: ").append(this.canonicalPath);
        stringBuilder.append("\n");
        stringBuilder.append("key: ").append("[length: ").append(this.key == null ? 0 : 64).append("]");
        stringBuilder.append("\n");
        stringBuilder.append("schemaVersion: ").append(Long.toString(this.schemaVersion));
        stringBuilder.append("\n");
        stringBuilder.append("migration: ").append(this.migration);
        stringBuilder.append("\n");
        stringBuilder.append("deleteRealmIfMigrationNeeded: ").append(this.deleteRealmIfMigrationNeeded);
        stringBuilder.append("\n");
        stringBuilder.append("durability: ").append((Object)this.durability);
        stringBuilder.append("\n");
        stringBuilder.append("schemaMediator: ").append(this.schemaMediator);
        return stringBuilder.toString();
    }

    private static synchronized boolean isRxJavaAvailable() {
        if (rxJavaAvailable == null) {
            try {
                Class.forName("rx.Observable");
                rxJavaAvailable = true;
            }
            catch (ClassNotFoundException ignore) {
                rxJavaAvailable = false;
            }
        }
        return rxJavaAvailable;
    }

    protected static String getCanonicalPath(File realmFile) {
        try {
            return realmFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RealmFileException(RealmFileException.Kind.ACCESS_ERROR, "Could not resolve the canonical path to the Realm file: " + realmFile.getAbsolutePath(), e);
        }
    }

    boolean isSyncConfiguration() {
        return false;
    }

    static {
        if (DEFAULT_MODULE != null) {
            RealmProxyMediator mediator = RealmConfiguration.getModuleMediator(DEFAULT_MODULE.getClass().getCanonicalName());
            if (!mediator.transformerApplied()) {
                throw new ExceptionInInitializerError("RealmTransformer doesn't seem to be applied. Please update the project configuration to use the Realm Gradle plugin. See https://realm.io/news/android-installation-change/");
            }
            DEFAULT_MODULE_MEDIATOR = mediator;
        } else {
            DEFAULT_MODULE_MEDIATOR = null;
        }
    }

    public static class Builder {
        private File directory;
        private String fileName;
        private String assetFilePath;
        private byte[] key;
        private long schemaVersion;
        private RealmMigration migration;
        private boolean deleteRealmIfMigrationNeeded;
        private SharedRealm.Durability durability;
        private HashSet<Object> modules = new HashSet();
        private HashSet<Class<? extends RealmModel>> debugSchema = new HashSet();
        private RxObservableFactory rxFactory;
        private Realm.Transaction initialDataTransaction;

        public Builder() {
            this(BaseRealm.applicationContext);
        }

        Builder(Context context) {
            if (context == null) {
                throw new IllegalStateException("Call `Realm.init(Context)` before creating a RealmConfiguration");
            }
            RealmCore.loadLibrary(context);
            this.initializeBuilder(context);
        }

        private void initializeBuilder(Context context) {
            this.directory = context.getFilesDir();
            this.fileName = RealmConfiguration.DEFAULT_REALM_NAME;
            this.key = null;
            this.schemaVersion = 0L;
            this.migration = null;
            this.deleteRealmIfMigrationNeeded = false;
            this.durability = SharedRealm.Durability.FULL;
            if (DEFAULT_MODULE != null) {
                this.modules.add(DEFAULT_MODULE);
            }
        }

        public Builder name(String filename) {
            if (filename == null || filename.isEmpty()) {
                throw new IllegalArgumentException("A non-empty filename must be provided");
            }
            this.fileName = filename;
            return this;
        }

        public Builder directory(File directory) {
            if (directory == null) {
                throw new IllegalArgumentException("Non-null 'dir' required.");
            }
            if (directory.isFile()) {
                throw new IllegalArgumentException("'dir' is a file, not a directory: " + directory.getAbsolutePath() + ".");
            }
            if (!directory.exists() && !directory.mkdirs()) {
                throw new IllegalArgumentException("Could not create the specified directory: " + directory.getAbsolutePath() + ".");
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException("Realm directory is not writable: " + directory.getAbsolutePath() + ".");
            }
            this.directory = directory;
            return this;
        }

        public Builder encryptionKey(byte[] key) {
            if (key == null) {
                throw new IllegalArgumentException("A non-null key must be provided");
            }
            if (key.length != 64) {
                throw new IllegalArgumentException(String.format("The provided key must be %s bytes. Yours was: %s", 64, key.length));
            }
            this.key = Arrays.copyOf(key, key.length);
            return this;
        }

        public Builder schemaVersion(long schemaVersion) {
            if (schemaVersion < 0L) {
                throw new IllegalArgumentException("Realm schema version numbers must be 0 (zero) or higher. Yours was: " + schemaVersion);
            }
            this.schemaVersion = schemaVersion;
            return this;
        }

        public Builder migration(RealmMigration migration) {
            if (migration == null) {
                throw new IllegalArgumentException("A non-null migration must be provided");
            }
            this.migration = migration;
            return this;
        }

        public Builder deleteRealmIfMigrationNeeded() {
            if (this.assetFilePath != null && this.assetFilePath.length() != 0) {
                throw new IllegalStateException("Realm cannot clear its schema when previously configured to use an asset file by calling assetFile().");
            }
            this.deleteRealmIfMigrationNeeded = true;
            return this;
        }

        public Builder inMemory() {
            if (!TextUtils.isEmpty((CharSequence)this.assetFilePath)) {
                throw new RealmException("Realm can not use in-memory configuration if asset file is present.");
            }
            this.durability = SharedRealm.Durability.MEM_ONLY;
            return this;
        }

        public Builder modules(Object baseModule, Object ... additionalModules) {
            this.modules.clear();
            this.addModule(baseModule);
            if (additionalModules != null) {
                for (int i = 0; i < additionalModules.length; ++i) {
                    Object module = additionalModules[i];
                    this.addModule(module);
                }
            }
            return this;
        }

        public Builder rxFactory(RxObservableFactory factory) {
            this.rxFactory = factory;
            return this;
        }

        public Builder initialData(Realm.Transaction transaction) {
            this.initialDataTransaction = transaction;
            return this;
        }

        public Builder assetFile(String assetFile) {
            if (TextUtils.isEmpty((CharSequence)assetFile)) {
                throw new IllegalArgumentException("A non-empty asset file path must be provided");
            }
            if (this.durability == SharedRealm.Durability.MEM_ONLY) {
                throw new RealmException("Realm can not use in-memory configuration if asset file is present.");
            }
            if (this.deleteRealmIfMigrationNeeded) {
                throw new IllegalStateException("Realm cannot use an asset file when previously configured to clear its schema in migration by calling deleteRealmIfMigrationNeeded().");
            }
            this.assetFilePath = assetFile;
            return this;
        }

        private void addModule(Object module) {
            if (module != null) {
                this.checkModule(module);
                this.modules.add(module);
            }
        }

        Builder schema(Class<? extends RealmModel> firstClass, Class<? extends RealmModel> ... additionalClasses) {
            if (firstClass == null) {
                throw new IllegalArgumentException("A non-null class must be provided");
            }
            this.modules.clear();
            this.modules.add(DEFAULT_MODULE_MEDIATOR);
            this.debugSchema.add(firstClass);
            if (additionalClasses != null) {
                Collections.addAll(this.debugSchema, additionalClasses);
            }
            return this;
        }

        public RealmConfiguration build() {
            if (this.rxFactory == null && RealmConfiguration.isRxJavaAvailable()) {
                this.rxFactory = new RealmObservableFactory();
            }
            return new RealmConfiguration(this.directory, this.fileName, RealmConfiguration.getCanonicalPath(new File(this.directory, this.fileName)), this.assetFilePath, this.key, this.schemaVersion, this.migration, this.deleteRealmIfMigrationNeeded, this.durability, RealmConfiguration.createSchemaMediator(this.modules, this.debugSchema), this.rxFactory, this.initialDataTransaction);
        }

        private void checkModule(Object module) {
            if (!module.getClass().isAnnotationPresent(RealmModule.class)) {
                throw new IllegalArgumentException(module.getClass().getCanonicalName() + " is not a RealmModule. " + "Add @RealmModule to the class definition.");
            }
        }
    }
}

