/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.JsonReader;
import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.RealmAsyncTask;
import io.realm.RealmCache;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmMigration;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmObjectSchema;
import io.realm.RealmQuery;
import io.realm.RealmSchema;
import io.realm.exceptions.RealmException;
import io.realm.exceptions.RealmFileException;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.ColumnIndices;
import io.realm.internal.ColumnInfo;
import io.realm.internal.ObjectServerFacade;
import io.realm.internal.RealmCore;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.Table;
import io.realm.internal.async.RealmAsyncTaskImpl;
import io.realm.log.AndroidLogger;
import io.realm.log.RealmLog;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import rx.Observable;

public final class Realm
extends BaseRealm {
    public static final String DEFAULT_REALM_NAME = "default.realm";
    private static RealmConfiguration defaultConfiguration;

    Realm(RealmConfiguration configuration) {
        super(configuration);
    }

    public Observable<Realm> asObservable() {
        return this.configuration.getRxFactory().from(this);
    }

    public static synchronized void init(Context context) {
        if (BaseRealm.applicationContext == null) {
            if (context == null) {
                throw new IllegalArgumentException("Non-null context required.");
            }
            RealmCore.loadLibrary(context);
            RealmLog.add(new AndroidLogger(5));
            defaultConfiguration = new RealmConfiguration.Builder(context).build();
            ObjectServerFacade.getSyncFacadeIfPossible().init(context);
            BaseRealm.applicationContext = context.getApplicationContext();
        }
    }

    public static Realm getDefaultInstance() {
        if (defaultConfiguration == null) {
            throw new IllegalStateException("Call `Realm.init(Context)` before calling this method.");
        }
        return RealmCache.createRealmOrGetFromCache(defaultConfiguration, Realm.class);
    }

    public static Realm getInstance(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        return RealmCache.createRealmOrGetFromCache(configuration, Realm.class);
    }

    public static void setDefaultConfiguration(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        defaultConfiguration = configuration;
    }

    public static void removeDefaultConfiguration() {
        defaultConfiguration = null;
    }

    static Realm createInstance(RealmConfiguration configuration, ColumnIndices[] globalCacheArray) {
        try {
            return Realm.createAndValidate(configuration, globalCacheArray);
        }
        catch (RealmMigrationNeededException e) {
            if (configuration.shouldDeleteRealmIfMigrationNeeded()) {
                Realm.deleteRealm(configuration);
            } else {
                try {
                    Realm.migrateRealm(configuration, e);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new RealmFileException(RealmFileException.Kind.NOT_FOUND, (Throwable)fileNotFoundException);
                }
            }
            return Realm.createAndValidate(configuration, globalCacheArray);
        }
    }

    static Realm createAndValidate(RealmConfiguration configuration, ColumnIndices[] globalCacheArray) {
        Realm realm = new Realm(configuration);
        long currentVersion = realm.getVersion();
        long requiredVersion = configuration.getSchemaVersion();
        ColumnIndices columnIndices = RealmCache.findColumnIndices(globalCacheArray, requiredVersion);
        if (currentVersion != -1L && currentVersion < requiredVersion && columnIndices == null) {
            realm.doClose();
            throw new RealmMigrationNeededException(configuration.getPath(), String.format("Realm on disk need to migrate from v%s to v%s", currentVersion, requiredVersion));
        }
        if (currentVersion != -1L && requiredVersion < currentVersion && columnIndices == null) {
            realm.doClose();
            throw new IllegalArgumentException(String.format("Realm on disk is newer than the one specified: v%s vs. v%s", currentVersion, requiredVersion));
        }
        if (columnIndices == null) {
            try {
                Realm.initializeRealm(realm);
            }
            catch (RuntimeException e) {
                realm.doClose();
                throw e;
            }
        } else {
            realm.schema.columnIndices = columnIndices.clone();
        }
        return realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeRealm(Realm realm) {
        long version = realm.getVersion();
        boolean commitNeeded = false;
        boolean syncAvailable = realm.configuration.isSyncConfiguration();
        try {
            Transaction transaction;
            if (!syncAvailable) {
                realm.beginTransaction();
                if (version == -1L) {
                    commitNeeded = true;
                    realm.setVersion(realm.configuration.getSchemaVersion());
                }
            }
            RealmProxyMediator mediator = realm.configuration.getSchemaMediator();
            Set<Class<? extends RealmModel>> modelClasses = mediator.getModelClasses();
            HashMap<Class<? extends RealmModel>, ColumnInfo> columnInfoMap = new HashMap<Class<? extends RealmModel>, ColumnInfo>(modelClasses.size());
            ArrayList<RealmObjectSchema> realmObjectSchemas = new ArrayList<RealmObjectSchema>();
            RealmSchema realmSchemaCache = new RealmSchema();
            for (Class<? extends RealmModel> modelClass : modelClasses) {
                if (version == -1L && !syncAvailable) {
                    mediator.createTable(modelClass, realm.sharedRealm);
                }
                if (syncAvailable) {
                    RealmObjectSchema realmObjectSchema = mediator.createRealmObjectSchema(modelClass, realmSchemaCache);
                    realmObjectSchemas.add(realmObjectSchema);
                    continue;
                }
                columnInfoMap.put(modelClass, mediator.validateTable(modelClass, realm.sharedRealm, false));
            }
            if (syncAvailable) {
                RealmSchema schema = new RealmSchema(realmObjectSchemas);
                realm.sharedRealm.updateSchema(schema, version);
                for (Class<? extends RealmModel> modelClass : modelClasses) {
                    columnInfoMap.put(modelClass, mediator.validateTable(modelClass, realm.sharedRealm, false));
                }
            }
            realm.schema.columnIndices = new ColumnIndices(version == -1L ? realm.configuration.getSchemaVersion() : version, columnInfoMap);
            if (version == -1L && (transaction = realm.getConfiguration().getInitialDataTransaction()) != null) {
                if (syncAvailable) {
                    realm.executeTransaction(transaction);
                    realm.executeTransaction(new Transaction(){

                        @Override
                        public void execute(Realm realm) {
                            realm.setVersion(realm.configuration.getSchemaVersion());
                        }
                    });
                } else {
                    transaction.execute(realm);
                }
            }
        }
        finally {
            if (!syncAvailable) {
                if (commitNeeded) {
                    realm.commitTransaction(false);
                } else {
                    realm.cancelTransaction();
                }
            }
        }
    }

    public <E extends RealmModel> void createAllFromJson(Class<E> clazz, JSONArray json) {
        if (clazz == null || json == null) {
            return;
        }
        this.checkIfValid();
        for (int i = 0; i < json.length(); ++i) {
            try {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), false);
                continue;
            }
            catch (JSONException e) {
                throw new RealmException("Could not map JSON", e);
            }
        }
    }

    public <E extends RealmModel> void createOrUpdateAllFromJson(Class<E> clazz, JSONArray json) {
        if (clazz == null || json == null) {
            return;
        }
        this.checkIfValid();
        this.checkHasPrimaryKey(clazz);
        for (int i = 0; i < json.length(); ++i) {
            try {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), true);
                continue;
            }
            catch (JSONException e) {
                throw new RealmException("Could not map JSON", e);
            }
        }
    }

    public <E extends RealmModel> void createAllFromJson(Class<E> clazz, String json) {
        JSONArray arr;
        if (clazz == null || json == null || json.length() == 0) {
            return;
        }
        try {
            arr = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new RealmException("Could not create JSON array from string", e);
        }
        this.createAllFromJson(clazz, arr);
    }

    public <E extends RealmModel> void createOrUpdateAllFromJson(Class<E> clazz, String json) {
        JSONArray arr;
        if (clazz == null || json == null || json.length() == 0) {
            return;
        }
        this.checkIfValid();
        this.checkHasPrimaryKey(clazz);
        try {
            arr = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new RealmException("Could not create JSON array from string", e);
        }
        this.createOrUpdateAllFromJson(clazz, arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public <E extends RealmModel> void createAllFromJson(Class<E> clazz, InputStream inputStream) throws IOException {
        if (clazz == null || inputStream == null) {
            return;
        }
        this.checkIfValid();
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));){
            reader.beginArray();
            while (reader.hasNext()) {
                this.configuration.getSchemaMediator().createUsingJsonStream(clazz, this, reader);
            }
            reader.endArray();
        }
    }

    @TargetApi(value=11)
    public <E extends RealmModel> void createOrUpdateAllFromJson(Class<E> clazz, InputStream in) throws IOException {
        if (clazz == null || in == null) {
            return;
        }
        this.checkIfValid();
        this.checkHasPrimaryKey(clazz);
        try (Scanner scanner = null;){
            scanner = this.getFullStringScanner(in);
            JSONArray json = new JSONArray(scanner.next());
            for (int i = 0; i < json.length(); ++i) {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), true);
            }
        }
    }

    public <E extends RealmModel> E createObjectFromJson(Class<E> clazz, JSONObject json) {
        if (clazz == null || json == null) {
            return null;
        }
        this.checkIfValid();
        try {
            return this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, false);
        }
        catch (JSONException e) {
            throw new RealmException("Could not map JSON", e);
        }
    }

    public <E extends RealmModel> E createOrUpdateObjectFromJson(Class<E> clazz, JSONObject json) {
        if (clazz == null || json == null) {
            return null;
        }
        this.checkIfValid();
        this.checkHasPrimaryKey(clazz);
        try {
            E realmObject = this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, true);
            return realmObject;
        }
        catch (JSONException e) {
            throw new RealmException("Could not map JSON", e);
        }
    }

    public <E extends RealmModel> E createObjectFromJson(Class<E> clazz, String json) {
        JSONObject obj;
        if (clazz == null || json == null || json.length() == 0) {
            return null;
        }
        try {
            obj = new JSONObject(json);
        }
        catch (JSONException e) {
            throw new RealmException("Could not create Json object from string", e);
        }
        return this.createObjectFromJson(clazz, obj);
    }

    public <E extends RealmModel> E createOrUpdateObjectFromJson(Class<E> clazz, String json) {
        JSONObject obj;
        if (clazz == null || json == null || json.length() == 0) {
            return null;
        }
        this.checkIfValid();
        this.checkHasPrimaryKey(clazz);
        try {
            obj = new JSONObject(json);
        }
        catch (JSONException e) {
            throw new RealmException("Could not create Json object from string", e);
        }
        return this.createOrUpdateObjectFromJson(clazz, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public <E extends RealmModel> E createObjectFromJson(Class<E> clazz, InputStream inputStream) throws IOException {
        E realmObject;
        if (clazz == null || inputStream == null) {
            return null;
        }
        this.checkIfValid();
        Table table = this.schema.getTable(clazz);
        if (table.hasPrimaryKey()) {
            try (Scanner scanner = null;){
                scanner = this.getFullStringScanner(inputStream);
                JSONObject json = new JSONObject(scanner.next());
                realmObject = this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, false);
            }
        }
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));){
            realmObject = this.configuration.getSchemaMediator().createUsingJsonStream(clazz, this, reader);
        }
        return realmObject;
    }

    @TargetApi(value=11)
    public <E extends RealmModel> E createOrUpdateObjectFromJson(Class<E> clazz, InputStream in) throws IOException {
        if (clazz == null || in == null) {
            return null;
        }
        this.checkIfValid();
        this.checkHasPrimaryKey(clazz);
        try (Scanner scanner = null;){
            scanner = this.getFullStringScanner(in);
            JSONObject json = new JSONObject(scanner.next());
            E e = this.createOrUpdateObjectFromJson(clazz, json);
            return e;
        }
    }

    private Scanner getFullStringScanner(InputStream in) {
        return new Scanner(in, "UTF-8").useDelimiter("\\A");
    }

    public <E extends RealmModel> E createObject(Class<E> clazz) {
        this.checkIfValid();
        return this.createObjectInternal(clazz, true, Collections.emptyList());
    }

    <E extends RealmModel> E createObjectInternal(Class<E> clazz, boolean acceptDefaultValue, List<String> excludeFields) {
        Table table = this.schema.getTable(clazz);
        if (table.hasPrimaryKey()) {
            throw new RealmException(String.format("'%s' has a primary key, use 'createObject(Class<E>, Object)' instead.", Table.tableNameToClassName(table.getName())));
        }
        long rowIndex = table.addEmptyRow();
        return this.get(clazz, rowIndex, acceptDefaultValue, excludeFields);
    }

    public <E extends RealmModel> E createObject(Class<E> clazz, Object primaryKeyValue) {
        this.checkIfValid();
        return this.createObjectInternal(clazz, primaryKeyValue, true, Collections.emptyList());
    }

    <E extends RealmModel> E createObjectInternal(Class<E> clazz, Object primaryKeyValue, boolean acceptDefaultValue, List<String> excludeFields) {
        Table table = this.schema.getTable(clazz);
        long rowIndex = table.addEmptyRowWithPrimaryKey(primaryKeyValue);
        return this.get(clazz, rowIndex, acceptDefaultValue, excludeFields);
    }

    public <E extends RealmModel> E copyToRealm(E object) {
        this.checkNotNullObject(object);
        return this.copyOrUpdate(object, false, new HashMap<RealmModel, RealmObjectProxy>());
    }

    public <E extends RealmModel> E copyToRealmOrUpdate(E object) {
        this.checkNotNullObject(object);
        this.checkHasPrimaryKey(object.getClass());
        return this.copyOrUpdate(object, true, new HashMap<RealmModel, RealmObjectProxy>());
    }

    public <E extends RealmModel> List<E> copyToRealm(Iterable<E> objects) {
        if (objects == null) {
            return new ArrayList();
        }
        HashMap<RealmModel, RealmObjectProxy> cache = new HashMap<RealmModel, RealmObjectProxy>();
        ArrayList<RealmModel> realmObjects = new ArrayList<RealmModel>();
        for (RealmModel object : objects) {
            this.checkNotNullObject(object);
            realmObjects.add(this.copyOrUpdate(object, false, cache));
        }
        return realmObjects;
    }

    public void insert(Collection<? extends RealmModel> objects) {
        this.checkIfValidAndInTransaction();
        if (objects == null) {
            throw new IllegalArgumentException("Null objects cannot be inserted into Realm.");
        }
        if (objects.isEmpty()) {
            return;
        }
        this.configuration.getSchemaMediator().insert(this, objects);
    }

    public void insert(RealmModel object) {
        this.checkIfValidAndInTransaction();
        if (object == null) {
            throw new IllegalArgumentException("Null object cannot be inserted into Realm.");
        }
        IdentityHashMap<RealmModel, Long> cache = new IdentityHashMap<RealmModel, Long>();
        this.configuration.getSchemaMediator().insert(this, object, cache);
    }

    public void insertOrUpdate(Collection<? extends RealmModel> objects) {
        this.checkIfValidAndInTransaction();
        if (objects == null) {
            throw new IllegalArgumentException("Null objects cannot be inserted into Realm.");
        }
        if (objects.isEmpty()) {
            return;
        }
        this.configuration.getSchemaMediator().insertOrUpdate(this, objects);
    }

    public void insertOrUpdate(RealmModel object) {
        this.checkIfValidAndInTransaction();
        if (object == null) {
            throw new IllegalArgumentException("Null object cannot be inserted into Realm.");
        }
        IdentityHashMap<RealmModel, Long> cache = new IdentityHashMap<RealmModel, Long>();
        this.configuration.getSchemaMediator().insertOrUpdate(this, object, cache);
    }

    public <E extends RealmModel> List<E> copyToRealmOrUpdate(Iterable<E> objects) {
        if (objects == null) {
            return new ArrayList(0);
        }
        HashMap<RealmModel, RealmObjectProxy> cache = new HashMap<RealmModel, RealmObjectProxy>();
        ArrayList<RealmModel> realmObjects = new ArrayList<RealmModel>();
        for (RealmModel object : objects) {
            this.checkNotNullObject(object);
            realmObjects.add(this.copyOrUpdate(object, true, cache));
        }
        return realmObjects;
    }

    public <E extends RealmModel> List<E> copyFromRealm(Iterable<E> realmObjects) {
        return this.copyFromRealm((E)((Object)realmObjects), Integer.MAX_VALUE);
    }

    public <E extends RealmModel> List<E> copyFromRealm(Iterable<E> realmObjects, int maxDepth) {
        this.checkMaxDepth(maxDepth);
        if (realmObjects == null) {
            return new ArrayList(0);
        }
        ArrayList<RealmModel> unmanagedObjects = new ArrayList<RealmModel>();
        HashMap<RealmModel, RealmObjectProxy.CacheData<RealmModel>> listCache = new HashMap<RealmModel, RealmObjectProxy.CacheData<RealmModel>>();
        for (RealmModel object : realmObjects) {
            this.checkValidObjectForDetach(object);
            unmanagedObjects.add(this.createDetachedCopy(object, maxDepth, listCache));
        }
        return unmanagedObjects;
    }

    public <E extends RealmModel> E copyFromRealm(E realmObject) {
        return this.copyFromRealm(realmObject, Integer.MAX_VALUE);
    }

    public <E extends RealmModel> E copyFromRealm(E realmObject, int maxDepth) {
        this.checkMaxDepth(maxDepth);
        this.checkValidObjectForDetach(realmObject);
        return this.createDetachedCopy(realmObject, maxDepth, new HashMap<RealmModel, RealmObjectProxy.CacheData<RealmModel>>());
    }

    public <E extends RealmModel> RealmQuery<E> where(Class<E> clazz) {
        this.checkIfValid();
        return RealmQuery.createQuery(this, clazz);
    }

    public void addChangeListener(RealmChangeListener<Realm> listener) {
        super.addListener(listener);
    }

    public void executeTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        this.beginTransaction();
        try {
            transaction.execute(this);
            this.commitTransaction();
        }
        catch (Throwable e) {
            if (this.isInTransaction()) {
                this.cancelTransaction();
            } else {
                RealmLog.warn("Could not cancel transaction, not currently in a transaction.", new Object[0]);
            }
            throw e;
        }
    }

    public RealmAsyncTask executeTransactionAsync(Transaction transaction) {
        return this.executeTransactionAsync(transaction, null, null);
    }

    public RealmAsyncTask executeTransactionAsync(Transaction transaction, Transaction.OnSuccess onSuccess) {
        if (onSuccess == null) {
            throw new IllegalArgumentException("onSuccess callback can't be null");
        }
        return this.executeTransactionAsync(transaction, onSuccess, null);
    }

    public RealmAsyncTask executeTransactionAsync(Transaction transaction, Transaction.OnError onError) {
        if (onError == null) {
            throw new IllegalArgumentException("onError callback can't be null");
        }
        return this.executeTransactionAsync(transaction, null, onError);
    }

    public RealmAsyncTask executeTransactionAsync(final Transaction transaction, final Transaction.OnSuccess onSuccess, final Transaction.OnError onError) {
        this.checkIfValid();
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        if (!(onSuccess == null && onError == null || this.hasValidNotifier())) {
            throw new IllegalStateException("Your Realm is opened from a thread without a Looper and you provided a callback, we need a Handler to invoke your callback");
        }
        final RealmConfiguration realmConfiguration = this.getConfiguration();
        Future<?> pendingTransaction = asyncTaskExecutor.submitTransaction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Throwable[] exception;
                boolean transactionCommitted;
                block31: {
                    Realm bgRealm;
                    block33: {
                        block32: {
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                            transactionCommitted = false;
                            exception = new Throwable[1];
                            bgRealm = Realm.getInstance(realmConfiguration);
                            bgRealm.beginTransaction();
                            try {
                                transaction.execute(bgRealm);
                                if (!Thread.currentThread().isInterrupted()) {
                                    bgRealm.commitTransaction(false);
                                    bgRealm.close();
                                    transactionCommitted = true;
                                }
                                if (bgRealm.isClosed()) break block31;
                                if (!bgRealm.isInTransaction()) break block32;
                                bgRealm.cancelTransaction();
                                break block33;
                            }
                            catch (Throwable e) {
                                block34: {
                                    block35: {
                                        try {
                                            exception[0] = e;
                                            if (bgRealm.isClosed()) break block34;
                                            if (!bgRealm.isInTransaction()) break block35;
                                            bgRealm.cancelTransaction();
                                        }
                                        catch (Throwable throwable) {
                                            if (!bgRealm.isClosed()) {
                                                if (bgRealm.isInTransaction()) {
                                                    bgRealm.cancelTransaction();
                                                } else if (exception[0] != null) {
                                                    RealmLog.warn("Could not cancel transaction, not currently in a transaction.", new Object[0]);
                                                }
                                                bgRealm.close();
                                            }
                                            Throwable backgroundException = exception[0];
                                            if (Realm.this.hasValidNotifier() && !Thread.currentThread().isInterrupted()) {
                                                if (transactionCommitted) {
                                                    Realm.this.sharedRealm.realmNotifier.post(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            Realm.this.handlerController.handleAsyncTransactionCompleted(onSuccess != null ? new Runnable(){

                                                                @Override
                                                                public void run() {
                                                                    onSuccess.onSuccess();
                                                                }
                                                            } : null);
                                                        }
                                                    });
                                                }
                                                if (backgroundException == null) throw throwable;
                                                if (onError != null) {
                                                    Realm.this.sharedRealm.realmNotifier.post(new Runnable(backgroundException){
                                                        final /* synthetic */ Throwable val$backgroundException;
                                                        {
                                                            this.val$backgroundException = throwable;
                                                        }

                                                        @Override
                                                        public void run() {
                                                            onError.onError(this.val$backgroundException);
                                                        }
                                                    });
                                                    throw throwable;
                                                } else {
                                                    Realm.this.sharedRealm.realmNotifier.post(new Runnable(backgroundException){
                                                        final /* synthetic */ Throwable val$backgroundException;
                                                        {
                                                            this.val$backgroundException = throwable;
                                                        }

                                                        @Override
                                                        public void run() {
                                                            if (this.val$backgroundException instanceof RuntimeException) {
                                                                throw (RuntimeException)this.val$backgroundException;
                                                            }
                                                            if (this.val$backgroundException instanceof Exception) {
                                                                throw new RealmException("Async transaction failed", this.val$backgroundException);
                                                            }
                                                            if (this.val$backgroundException instanceof Error) {
                                                                throw (Error)this.val$backgroundException;
                                                            }
                                                        }
                                                    });
                                                }
                                                throw throwable;
                                            } else {
                                                if (backgroundException == null) throw throwable;
                                                if (backgroundException instanceof RuntimeException) {
                                                    throw (RuntimeException)backgroundException;
                                                }
                                                if (backgroundException instanceof Exception) {
                                                    throw new RealmException("Async transaction failed", backgroundException);
                                                }
                                                if (!(backgroundException instanceof Error)) throw throwable;
                                                throw (Error)backgroundException;
                                            }
                                        }
                                    }
                                    if (exception[0] != null) {
                                        RealmLog.warn("Could not cancel transaction, not currently in a transaction.", new Object[0]);
                                    }
                                    bgRealm.close();
                                }
                                Throwable backgroundException = exception[0];
                                if (Realm.this.hasValidNotifier() && !Thread.currentThread().isInterrupted()) {
                                    if (transactionCommitted) {
                                        Realm.this.sharedRealm.realmNotifier.post(new /* invalid duplicate definition of identical inner class */);
                                    }
                                    if (backgroundException == null) return;
                                    if (onError != null) {
                                        Realm.this.sharedRealm.realmNotifier.post(new /* invalid duplicate definition of identical inner class */);
                                        return;
                                    } else {
                                        Realm.this.sharedRealm.realmNotifier.post(new /* invalid duplicate definition of identical inner class */);
                                    }
                                    return;
                                }
                                if (backgroundException == null) return;
                                if (backgroundException instanceof RuntimeException) {
                                    throw (RuntimeException)backgroundException;
                                }
                                if (backgroundException instanceof Exception) {
                                    throw new RealmException("Async transaction failed", backgroundException);
                                }
                                if (!(backgroundException instanceof Error)) return;
                                throw (Error)backgroundException;
                            }
                        }
                        if (exception[0] != null) {
                            RealmLog.warn("Could not cancel transaction, not currently in a transaction.", new Object[0]);
                        }
                    }
                    bgRealm.close();
                }
                Throwable backgroundException = exception[0];
                if (Realm.this.hasValidNotifier() && !Thread.currentThread().isInterrupted()) {
                    if (transactionCommitted) {
                        Realm.this.sharedRealm.realmNotifier.post(new /* invalid duplicate definition of identical inner class */);
                    }
                    if (backgroundException == null) return;
                    if (onError != null) {
                        Realm.this.sharedRealm.realmNotifier.post(new /* invalid duplicate definition of identical inner class */);
                        return;
                    } else {
                        Realm.this.sharedRealm.realmNotifier.post(new /* invalid duplicate definition of identical inner class */);
                    }
                    return;
                }
                if (backgroundException == null) return;
                if (backgroundException instanceof RuntimeException) {
                    throw (RuntimeException)backgroundException;
                }
                if (backgroundException instanceof Exception) {
                    throw new RealmException("Async transaction failed", backgroundException);
                }
                if (!(backgroundException instanceof Error)) return;
                throw (Error)backgroundException;
            }
        });
        return new RealmAsyncTaskImpl(pendingTransaction, asyncTaskExecutor);
    }

    public void delete(Class<? extends RealmModel> clazz) {
        this.checkIfValid();
        this.schema.getTable(clazz).clear();
    }

    private <E extends RealmModel> E copyOrUpdate(E object, boolean update, Map<RealmModel, RealmObjectProxy> cache) {
        this.checkIfValid();
        return this.configuration.getSchemaMediator().copyOrUpdate(this, object, update, cache);
    }

    private <E extends RealmModel> E createDetachedCopy(E object, int maxDepth, Map<RealmModel, RealmObjectProxy.CacheData<RealmModel>> cache) {
        this.checkIfValid();
        return this.configuration.getSchemaMediator().createDetachedCopy(object, maxDepth, cache);
    }

    private <E extends RealmModel> void checkNotNullObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Null objects cannot be copied into Realm.");
        }
    }

    private void checkHasPrimaryKey(Class<? extends RealmModel> clazz) {
        if (!this.schema.getTable(clazz).hasPrimaryKey()) {
            throw new IllegalArgumentException("A RealmObject with no @PrimaryKey cannot be updated: " + clazz.toString());
        }
    }

    private void checkMaxDepth(int maxDepth) {
        if (maxDepth < 0) {
            throw new IllegalArgumentException("maxDepth must be > 0. It was: " + maxDepth);
        }
    }

    private <E extends RealmModel> void checkValidObjectForDetach(E realmObject) {
        if (realmObject == null) {
            throw new IllegalArgumentException("Null objects cannot be copied from Realm.");
        }
        if (!RealmObject.isManaged(realmObject) || !RealmObject.isValid(realmObject)) {
            throw new IllegalArgumentException("Only valid managed objects can be copied from Realm.");
        }
        if (realmObject instanceof DynamicRealmObject) {
            throw new IllegalArgumentException("DynamicRealmObject cannot be copied from Realm.");
        }
    }

    public static void migrateRealm(RealmConfiguration configuration) throws FileNotFoundException {
        Realm.migrateRealm(configuration, (RealmMigration)null);
    }

    private static void migrateRealm(RealmConfiguration configuration, RealmMigrationNeededException cause) throws FileNotFoundException {
        BaseRealm.migrateRealm(configuration, null, new BaseRealm.MigrationCallback(){

            @Override
            public void migrationComplete() {
            }
        }, cause);
    }

    public static void migrateRealm(RealmConfiguration configuration, RealmMigration migration) throws FileNotFoundException {
        BaseRealm.migrateRealm(configuration, migration, new BaseRealm.MigrationCallback(){

            @Override
            public void migrationComplete() {
            }
        }, null);
    }

    public static boolean deleteRealm(RealmConfiguration configuration) {
        return BaseRealm.deleteRealm(configuration);
    }

    public static boolean compactRealm(RealmConfiguration configuration) {
        return BaseRealm.compactRealm(configuration);
    }

    Table getTable(Class<? extends RealmModel> clazz) {
        return this.schema.getTable(clazz);
    }

    ColumnIndices updateSchemaCache(ColumnIndices[] globalCacheArray) {
        long cacheSchemaVersion;
        long currentSchemaVersion = this.sharedRealm.getSchemaVersion();
        if (currentSchemaVersion == (cacheSchemaVersion = this.schema.columnIndices.getSchemaVersion())) {
            return null;
        }
        ColumnIndices createdGlobalCache = null;
        RealmProxyMediator mediator = this.getConfiguration().getSchemaMediator();
        ColumnIndices cacheForCurrentVersion = RealmCache.findColumnIndices(globalCacheArray, currentSchemaVersion);
        if (cacheForCurrentVersion == null) {
            Set<Class<? extends RealmModel>> modelClasses = mediator.getModelClasses();
            HashMap<Class<? extends RealmModel>, ColumnInfo> map = new HashMap<Class<? extends RealmModel>, ColumnInfo>(modelClasses.size());
            for (Class<? extends RealmModel> clazz : modelClasses) {
                ColumnInfo columnInfo = mediator.validateTable(clazz, this.sharedRealm, true);
                map.put(clazz, columnInfo);
            }
            cacheForCurrentVersion = createdGlobalCache = new ColumnIndices(currentSchemaVersion, map);
        }
        this.schema.columnIndices.copyFrom(cacheForCurrentVersion, mediator);
        return createdGlobalCache;
    }

    public static Object getDefaultModule() {
        String moduleName = "io.realm.DefaultRealmModule";
        try {
            Class<?> clazz = Class.forName(moduleName);
            Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
        catch (InstantiationException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
        catch (IllegalAccessException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
    }

    public static int getGlobalInstanceCount(RealmConfiguration configuration) {
        final AtomicInteger globalCount = new AtomicInteger(0);
        RealmCache.invokeWithGlobalRefCount(configuration, new RealmCache.Callback(){

            @Override
            public void onResult(int count) {
                globalCount.set(count);
            }
        });
        return globalCount.get();
    }

    public static int getLocalInstanceCount(RealmConfiguration configuration) {
        return RealmCache.getLocalThreadCount(configuration);
    }

    public static interface Transaction {
        public void execute(Realm var1);

        public static interface OnError {
            public void onError(Throwable var1);
        }

        public static interface OnSuccess {
            public void onSuccess();
        }

        public static class Callback {
            public void onSuccess() {
            }

            public void onError(Exception e) {
            }
        }
    }
}

