/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import io.realm.BaseRealm;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.internal.IdentitySet;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.SharedRealm;
import io.realm.internal.async.BadVersionException;
import io.realm.internal.async.QueryUpdateTask;
import io.realm.log.RealmLog;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;

final class HandlerController
implements Handler.Callback {
    private static final Boolean NO_REALM_QUERY = Boolean.TRUE;
    final CopyOnWriteArrayList<RealmChangeListener<? extends BaseRealm>> changeListeners = new CopyOnWriteArrayList();
    final List<WeakReference<RealmChangeListener<? extends BaseRealm>>> weakChangeListeners = new CopyOnWriteArrayList<WeakReference<RealmChangeListener<? extends BaseRealm>>>();
    final BaseRealm realm;
    private boolean autoRefresh;
    private Future updateAsyncQueriesTask;
    private final ReferenceQueue<RealmResults<? extends RealmModel>> referenceQueueAsyncRealmResults = new ReferenceQueue();
    private final ReferenceQueue<RealmResults<? extends RealmModel>> referenceQueueSyncRealmResults = new ReferenceQueue();
    final ReferenceQueue<RealmModel> referenceQueueRealmObject = new ReferenceQueue();
    final Map<WeakReference<RealmResults<? extends RealmModel>>, RealmQuery<? extends RealmModel>> asyncRealmResults = new IdentityHashMap<WeakReference<RealmResults<? extends RealmModel>>, RealmQuery<? extends RealmModel>>();
    final Map<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>> emptyAsyncRealmObject = new ConcurrentHashMap<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>>();
    final IdentitySet<WeakReference<RealmResults<? extends RealmModel>>> syncRealmResults = new IdentitySet();
    final ConcurrentHashMap<WeakReference<RealmObjectProxy>, Object> realmObjects = new ConcurrentHashMap();
    private final List<Runnable> pendingOnSuccessAsyncTransactionCallbacks = new ArrayList<Runnable>();

    public HandlerController(BaseRealm realm) {
        this.realm = realm;
    }

    public boolean handleMessage(Message message) {
        if (this.realm.sharedRealm != null) {
            switch (message.what) {
                case 14930352: 
                case 165580141: {
                    this.realmChanged(message.what == 165580141);
                    break;
                }
                case 39088169: {
                    QueryUpdateTask.Result result = (QueryUpdateTask.Result)message.obj;
                    this.completedAsyncRealmResults(result);
                    break;
                }
                case 63245986: {
                    QueryUpdateTask.Result result = (QueryUpdateTask.Result)message.obj;
                    this.completedAsyncRealmObject(result);
                    break;
                }
                case 24157817: {
                    QueryUpdateTask.Result result = (QueryUpdateTask.Result)message.obj;
                    this.completedAsyncQueriesUpdate(result);
                    break;
                }
                case 102334155: {
                    throw (Error)message.obj;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message: " + message.what);
                }
            }
        }
        return true;
    }

    public void handleAsyncTransactionCompleted(Runnable onSuccess) {
        if (this.realm.sharedRealm != null) {
            if (onSuccess != null) {
                this.pendingOnSuccessAsyncTransactionCallbacks.add(onSuccess);
            }
            this.realmChanged(false);
        }
    }

    void addChangeListener(RealmChangeListener<? extends BaseRealm> listener) {
        this.changeListeners.addIfAbsent(listener);
    }

    void addChangeListenerAsWeakReference(RealmChangeListener<? extends BaseRealm> listener) {
        Iterator<WeakReference<RealmChangeListener<? extends BaseRealm>>> iterator = this.weakChangeListeners.iterator();
        ArrayList<WeakReference<RealmChangeListener<? extends BaseRealm>>> toRemoveList = null;
        boolean addListener = true;
        while (iterator.hasNext()) {
            WeakReference<RealmChangeListener<? extends BaseRealm>> weakRef = iterator.next();
            RealmChangeListener weakListener = (RealmChangeListener)weakRef.get();
            if (weakListener == null) {
                if (toRemoveList == null) {
                    toRemoveList = new ArrayList<WeakReference<RealmChangeListener<? extends BaseRealm>>>(this.weakChangeListeners.size());
                }
                toRemoveList.add(weakRef);
            }
            if (weakListener != listener) continue;
            addListener = false;
        }
        if (toRemoveList != null) {
            this.weakChangeListeners.removeAll(toRemoveList);
        }
        if (addListener) {
            this.weakChangeListeners.add(new WeakReference<RealmChangeListener<? extends BaseRealm>>(listener));
        }
    }

    void removeWeakChangeListener(RealmChangeListener<? extends BaseRealm> listener) {
        ArrayList<WeakReference<RealmChangeListener<? extends BaseRealm>>> toRemoveList = null;
        for (int i = 0; i < this.weakChangeListeners.size(); ++i) {
            WeakReference<RealmChangeListener<? extends BaseRealm>> weakRef = this.weakChangeListeners.get(i);
            RealmChangeListener weakListener = (RealmChangeListener)weakRef.get();
            if (weakListener != null && weakListener != listener) continue;
            if (toRemoveList == null) {
                toRemoveList = new ArrayList<WeakReference<RealmChangeListener<? extends BaseRealm>>>(this.weakChangeListeners.size());
            }
            toRemoveList.add(weakRef);
        }
        this.weakChangeListeners.removeAll(toRemoveList);
    }

    void removeChangeListener(RealmChangeListener<? extends BaseRealm> listener) {
        this.changeListeners.remove(listener);
    }

    void removeAllChangeListeners() {
        this.changeListeners.clear();
    }

    private void notifyGlobalListeners() {
        Iterator<RealmChangeListener<? extends BaseRealm>> iteratorStrongListeners = this.changeListeners.iterator();
        while (!this.realm.isClosed() && iteratorStrongListeners.hasNext()) {
            RealmChangeListener<? extends BaseRealm> listener = iteratorStrongListeners.next();
            listener.onChange(this.realm);
        }
        Iterator<WeakReference<RealmChangeListener<? extends BaseRealm>>> iteratorWeakListeners = this.weakChangeListeners.iterator();
        ArrayList<WeakReference<RealmChangeListener<? extends BaseRealm>>> toRemoveList = null;
        while (!this.realm.isClosed() && iteratorWeakListeners.hasNext()) {
            WeakReference<RealmChangeListener<? extends BaseRealm>> weakRef = iteratorWeakListeners.next();
            RealmChangeListener listener = (RealmChangeListener)weakRef.get();
            if (listener == null) {
                if (toRemoveList == null) {
                    toRemoveList = new ArrayList<WeakReference<RealmChangeListener<? extends BaseRealm>>>(this.weakChangeListeners.size());
                }
                toRemoveList.add(weakRef);
                continue;
            }
            listener.onChange(this.realm);
        }
        if (toRemoveList != null) {
            this.weakChangeListeners.removeAll(toRemoveList);
        }
    }

    private void updateAsyncEmptyRealmObject() {
        Iterator<Map.Entry<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>>> iterator = this.emptyAsyncRealmObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>> next = iterator.next();
            if (next.getKey().get() != null) {
                Realm.asyncTaskExecutor.submitQueryUpdate(QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration()).addObject(next.getKey(), next.getValue().handoverQueryPointer(), next.getValue().getArgument()).sendToNotifier(this.realm.sharedRealm.realmNotifier, QueryUpdateTask.NotifyEvent.COMPLETE_ASYNC_OBJECT).build());
                continue;
            }
            iterator.remove();
        }
    }

    void notifyAllListeners(List<RealmResults<? extends RealmModel>> realmResultsToBeNotified) {
        Iterator<RealmResults<? extends RealmModel>> it = realmResultsToBeNotified.iterator();
        while (!this.realm.isClosed() && it.hasNext()) {
            RealmResults<? extends RealmModel> realmResults = it.next();
            realmResults.notifyChangeListeners(false);
        }
        this.notifyRealmObjectCallbacks();
        if (!this.realm.isClosed() && this.threadContainsAsyncEmptyRealmObject()) {
            this.updateAsyncEmptyRealmObject();
        }
        this.notifyAsyncTransactionCallbacks();
        this.notifyGlobalListeners();
    }

    private void collectAsyncRealmResultsCallbacks(List<RealmResults<? extends RealmModel>> resultsToBeNotified) {
        this.collectRealmResultsCallbacks(this.asyncRealmResults.keySet().iterator(), resultsToBeNotified);
    }

    private void collectSyncRealmResultsCallbacks(List<RealmResults<? extends RealmModel>> resultsToBeNotified) {
        this.collectRealmResultsCallbacks(this.syncRealmResults.keySet().iterator(), resultsToBeNotified);
    }

    private void collectRealmResultsCallbacks(Iterator<WeakReference<RealmResults<? extends RealmModel>>> iterator, List<RealmResults<? extends RealmModel>> resultsToBeNotified) {
        while (iterator.hasNext()) {
            WeakReference<RealmResults<? extends RealmModel>> weakRealmResults = iterator.next();
            RealmResults realmResults = (RealmResults)weakRealmResults.get();
            if (realmResults == null) {
                iterator.remove();
                continue;
            }
            if (!realmResults.isLoaded()) continue;
            realmResults.syncIfNeeded();
            resultsToBeNotified.add(realmResults);
        }
    }

    private void notifyRealmObjectCallbacks() {
        RealmObjectProxy realmObject;
        ArrayList<RealmObjectProxy> objectsToBeNotified = new ArrayList<RealmObjectProxy>();
        Iterator iterator = this.realmObjects.keySet().iterator();
        while (iterator.hasNext()) {
            WeakReference weakRealmObject = (WeakReference)iterator.next();
            realmObject = (RealmObjectProxy)weakRealmObject.get();
            if (realmObject == null) {
                iterator.remove();
                continue;
            }
            if (realmObject.realmGet$proxyState().getRow$realm().isAttached()) {
                objectsToBeNotified.add(realmObject);
                continue;
            }
            if (realmObject.realmGet$proxyState().getRow$realm() == Row.EMPTY_ROW) continue;
            iterator.remove();
        }
        Iterator it = objectsToBeNotified.iterator();
        while (!this.realm.isClosed() && it.hasNext()) {
            realmObject = (RealmObjectProxy)it.next();
            realmObject.realmGet$proxyState().notifyChangeListeners$realm();
        }
    }

    private void updateAsyncQueries() {
        if (this.updateAsyncQueriesTask != null && !this.updateAsyncQueriesTask.isDone()) {
            this.updateAsyncQueriesTask.cancel(true);
            Realm.asyncTaskExecutor.getQueue().remove(this.updateAsyncQueriesTask);
            RealmLog.trace("REALM_CHANGED realm: %s cancelling pending COMPLETED_UPDATE_ASYNC_QUERIES updates", this);
        }
        RealmLog.trace("REALM_CHANGED realm: %s updating async queries, total: %d", this, this.asyncRealmResults.size());
        QueryUpdateTask.Builder.UpdateQueryStep updateQueryStep = QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration());
        QueryUpdateTask.Builder.RealmResultsQueryStep realmResultsQueryStep = null;
        Iterator<Map.Entry<WeakReference<RealmResults<? extends RealmModel>>, RealmQuery<? extends RealmModel>>> iterator = this.asyncRealmResults.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmResults<? extends RealmModel>>, RealmQuery<? extends RealmModel>> entry = iterator.next();
            WeakReference<RealmResults<? extends RealmModel>> weakReference = entry.getKey();
            RealmResults realmResults = (RealmResults)weakReference.get();
            if (realmResults == null) {
                iterator.remove();
                continue;
            }
            realmResultsQueryStep = updateQueryStep.add(weakReference, entry.getValue().handoverQueryPointer(), entry.getValue().getArgument());
        }
        if (realmResultsQueryStep != null) {
            QueryUpdateTask queryUpdateTask = realmResultsQueryStep.sendToNotifier(this.realm.sharedRealm.realmNotifier, QueryUpdateTask.NotifyEvent.COMPLETE_UPDATE_ASYNC_QUERIES).build();
            this.updateAsyncQueriesTask = Realm.asyncTaskExecutor.submitQueryUpdate(queryUpdateTask);
        }
    }

    private void realmChanged(boolean localCommit) {
        RealmLog.debug("%s : %s", localCommit ? "LOCAL_COMMIT" : "REALM_CHANGED", this);
        this.deleteWeakReferences();
        boolean threadContainsAsyncQueries = this.threadContainsAsyncQueries();
        if (localCommit && threadContainsAsyncQueries) {
            RealmLog.warn("Mixing asynchronous queries with local writes should be avoided. Realm will convert any async queries to synchronous in order to remain consistent. Use asynchronous writes instead. You can read more here: https://realm.io/docs/java/latest/#asynchronous-transactions", new Object[0]);
        }
        if (!localCommit && threadContainsAsyncQueries) {
            this.updateAsyncQueries();
        } else {
            this.realm.sharedRealm.refresh();
            ArrayList<RealmResults<? extends RealmModel>> resultsToBeNotified = new ArrayList<RealmResults<? extends RealmModel>>();
            this.collectAsyncRealmResultsCallbacks(resultsToBeNotified);
            this.collectSyncRealmResultsCallbacks(resultsToBeNotified);
            this.notifyAllListeners(resultsToBeNotified);
        }
    }

    private void completedAsyncRealmResults(QueryUpdateTask.Result result) {
        Set<WeakReference<RealmResults<? extends RealmModel>>> updatedTableViewsKeys = result.updatedTableViews.keySet();
        if (updatedTableViewsKeys.size() > 0) {
            WeakReference<RealmResults<? extends RealmModel>> weakRealmResults = updatedTableViewsKeys.iterator().next();
            RealmResults realmResults = (RealmResults)weakRealmResults.get();
            if (realmResults == null) {
                this.asyncRealmResults.remove(weakRealmResults);
                RealmLog.trace("[COMPLETED_ASYNC_REALM_RESULTS %s] realm: %s RealmResults GC'd ignore results", weakRealmResults, this);
            } else {
                SharedRealm.VersionID callerVersionID = this.realm.sharedRealm.getVersionID();
                int compare = callerVersionID.compareTo(result.versionID);
                if (compare == 0) {
                    if (!realmResults.isLoaded()) {
                        RealmLog.trace("[COMPLETED_ASYNC_REALM_RESULTS %s] , realm: %s same versions, using results (RealmResults is not loaded)", weakRealmResults, this);
                        realmResults.swapTableViewPointer(result.updatedTableViews.get(weakRealmResults));
                        realmResults.syncIfNeeded();
                        realmResults.notifyChangeListeners(false);
                    } else {
                        RealmLog.trace("[COMPLETED_ASYNC_REALM_RESULTS %s] , realm: %s ignoring result the RealmResults (is already loaded)", weakRealmResults, this);
                    }
                } else if (compare > 0) {
                    if (!realmResults.isLoaded()) {
                        RealmLog.trace("[COMPLETED_ASYNC_REALM_RESULTS %s ] , %s caller is more advanced & RealmResults is not loaded, rerunning the query against the latest version", weakRealmResults, this);
                        RealmQuery<? extends RealmModel> query = this.asyncRealmResults.get(weakRealmResults);
                        QueryUpdateTask queryUpdateTask = QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration()).add(weakRealmResults, query.handoverQueryPointer(), query.getArgument()).sendToNotifier(this.realm.sharedRealm.realmNotifier, QueryUpdateTask.NotifyEvent.COMPLETE_ASYNC_RESULTS).build();
                        Realm.asyncTaskExecutor.submitQueryUpdate(queryUpdateTask);
                    } else {
                        RealmLog.trace("[COMPLETED_ASYNC_REALM_RESULTS %s] , %s caller is more advanced & RealmResults is loaded ignore the outdated result", weakRealmResults, this);
                    }
                } else {
                    RealmLog.trace("[COMPLETED_ASYNC_REALM_RESULTS %s] , %s caller thread behind worker thread, ignore results (a batch update will update everything including this query)", weakRealmResults, this);
                }
            }
        }
    }

    private void completedAsyncQueriesUpdate(QueryUpdateTask.Result result) {
        SharedRealm.VersionID callerVersionID = this.realm.sharedRealm.getVersionID();
        int compare = callerVersionID.compareTo(result.versionID);
        if (compare > 0) {
            RealmLog.trace("COMPLETED_UPDATE_ASYNC_QUERIES %s caller is more advanced, Looper will updates queries", this);
        } else {
            if (compare != 0) {
                RealmLog.trace("COMPLETED_UPDATE_ASYNC_QUERIES %s caller is behind advance_read", this);
                try {
                    this.realm.sharedRealm.refresh(result.versionID);
                }
                catch (BadVersionException e) {
                    throw new IllegalStateException("Failed to advance Caller Realm to Worker Realm version", e);
                }
            }
            ArrayList<RealmResults<? extends RealmModel>> resultsToBeNotified = new ArrayList<RealmResults<? extends RealmModel>>(result.updatedTableViews.size());
            for (Map.Entry<WeakReference<RealmResults<? extends RealmModel>>, Long> query : result.updatedTableViews.entrySet()) {
                WeakReference<RealmResults<? extends RealmModel>> weakRealmResults = query.getKey();
                RealmResults realmResults = (RealmResults)weakRealmResults.get();
                if (realmResults == null) {
                    this.asyncRealmResults.remove(weakRealmResults);
                    continue;
                }
                realmResults.swapTableViewPointer(query.getValue());
                realmResults.syncIfNeeded();
                resultsToBeNotified.add(realmResults);
                RealmLog.trace("COMPLETED_UPDATE_ASYNC_QUERIES updating RealmResults %s", this, weakRealmResults);
            }
            this.collectSyncRealmResultsCallbacks(resultsToBeNotified);
            this.notifyAllListeners(resultsToBeNotified);
            this.updateAsyncQueriesTask = null;
        }
    }

    private void notifyAsyncTransactionCallbacks() {
        if (!this.pendingOnSuccessAsyncTransactionCallbacks.isEmpty()) {
            for (Runnable callback : this.pendingOnSuccessAsyncTransactionCallbacks) {
                callback.run();
            }
            this.pendingOnSuccessAsyncTransactionCallbacks.clear();
        }
    }

    private void completedAsyncRealmObject(QueryUpdateTask.Result result) {
        WeakReference<RealmObjectProxy> realmObjectWeakReference;
        RealmObjectProxy proxy;
        Set<WeakReference<RealmObjectProxy>> updatedRowKey = result.updatedRow.keySet();
        if (updatedRowKey.size() > 0 && (proxy = (RealmObjectProxy)(realmObjectWeakReference = updatedRowKey.iterator().next()).get()) != null) {
            SharedRealm.VersionID callerVersionID = this.realm.sharedRealm.getVersionID();
            int compare = callerVersionID.compareTo(result.versionID);
            if (compare == 0) {
                long rowPointer = result.updatedRow.get(realmObjectWeakReference);
                if (rowPointer != 0L && this.emptyAsyncRealmObject.containsKey(realmObjectWeakReference)) {
                    this.emptyAsyncRealmObject.remove(realmObjectWeakReference);
                    this.realmObjects.put(realmObjectWeakReference, NO_REALM_QUERY);
                }
                proxy.realmGet$proxyState().onCompleted$realm(rowPointer);
                proxy.realmGet$proxyState().notifyChangeListeners$realm();
            } else if (compare > 0) {
                if (RealmObject.isValid(proxy)) {
                    RealmLog.trace("[COMPLETED_ASYNC_REALM_OBJECT %s], realm: %s. RealmObject is already loaded, just notify it", this.realm, this);
                    proxy.realmGet$proxyState().notifyChangeListeners$realm();
                } else {
                    RealmLog.trace("[COMPLETED_ASYNC_REALM_OBJECT %s, realm: %s. RealmObject is not loaded yet. Rerun the query.", proxy, this);
                    Object value = this.realmObjects.get(realmObjectWeakReference);
                    RealmQuery<? extends RealmModel> realmQuery = value == null || value == NO_REALM_QUERY ? this.emptyAsyncRealmObject.get(realmObjectWeakReference) : (RealmQuery<? extends RealmModel>)value;
                    QueryUpdateTask queryUpdateTask = QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration()).addObject(realmObjectWeakReference, realmQuery.handoverQueryPointer(), realmQuery.getArgument()).sendToNotifier(this.realm.sharedRealm.realmNotifier, QueryUpdateTask.NotifyEvent.COMPLETE_ASYNC_OBJECT).build();
                    Realm.asyncTaskExecutor.submitQueryUpdate(queryUpdateTask);
                }
            } else {
                throw new IllegalStateException("Caller thread behind the Worker thread");
            }
        }
    }

    private boolean threadContainsAsyncQueries() {
        boolean isEmpty = true;
        Iterator<Map.Entry<WeakReference<RealmResults<? extends RealmModel>>, RealmQuery<? extends RealmModel>>> iterator = this.asyncRealmResults.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmResults<? extends RealmModel>>, RealmQuery<? extends RealmModel>> next = iterator.next();
            if (next.getKey().get() == null) {
                iterator.remove();
                continue;
            }
            isEmpty = false;
        }
        return !isEmpty;
    }

    boolean threadContainsAsyncEmptyRealmObject() {
        boolean isEmpty = true;
        Iterator<Map.Entry<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>>> iterator = this.emptyAsyncRealmObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>> next = iterator.next();
            if (next.getKey().get() == null) {
                iterator.remove();
                continue;
            }
            isEmpty = false;
        }
        return !isEmpty;
    }

    private void deleteWeakReferences() {
        Reference<RealmModel> weakReferenceObject;
        Reference<RealmResults<? extends RealmModel>> weakReferenceResults;
        while ((weakReferenceResults = this.referenceQueueAsyncRealmResults.poll()) != null) {
            this.asyncRealmResults.remove(weakReferenceResults);
        }
        while ((weakReferenceResults = this.referenceQueueSyncRealmResults.poll()) != null) {
            this.syncRealmResults.remove(weakReferenceResults);
        }
        while ((weakReferenceObject = this.referenceQueueRealmObject.poll()) != null) {
            this.realmObjects.remove(weakReferenceObject);
        }
    }

    WeakReference<RealmResults<? extends RealmModel>> addToAsyncRealmResults(RealmResults<? extends RealmModel> realmResults, RealmQuery<? extends RealmModel> realmQuery) {
        WeakReference<RealmResults<? extends RealmModel>> weakRealmResults = new WeakReference<RealmResults<? extends RealmModel>>(realmResults, this.referenceQueueAsyncRealmResults);
        this.asyncRealmResults.put(weakRealmResults, realmQuery);
        return weakRealmResults;
    }

    void addToRealmResults(RealmResults<? extends RealmModel> realmResults) {
        WeakReference<RealmResults<? extends RealmModel>> realmResultsWeakReference = new WeakReference<RealmResults<? extends RealmModel>>(realmResults, this.referenceQueueSyncRealmResults);
        this.syncRealmResults.add(realmResultsWeakReference);
    }

    <E extends RealmObjectProxy> void addToRealmObjects(E realmObject) {
        for (WeakReference ref : this.realmObjects.keySet()) {
            if (ref.get() != realmObject) continue;
            return;
        }
        WeakReference<RealmModel> realmObjectWeakReference = new WeakReference<RealmModel>(realmObject, this.referenceQueueRealmObject);
        this.realmObjects.put(realmObjectWeakReference, NO_REALM_QUERY);
    }

    <E extends RealmObjectProxy> WeakReference<RealmObjectProxy> addToAsyncRealmObject(E realmObject, RealmQuery<? extends RealmModel> realmQuery) {
        WeakReference<RealmModel> realmObjectWeakReference = new WeakReference<RealmModel>(realmObject, this.referenceQueueRealmObject);
        this.realmObjects.put(realmObjectWeakReference, realmQuery);
        return realmObjectWeakReference;
    }

    void removeFromAsyncRealmObject(WeakReference<RealmObjectProxy> realmObjectWeakReference) {
        this.realmObjects.remove(realmObjectWeakReference);
    }

    void addToEmptyAsyncRealmObject(WeakReference<RealmObjectProxy> realmObjectWeakReference, RealmQuery<? extends RealmModel> realmQuery) {
        this.emptyAsyncRealmObject.put(realmObjectWeakReference, realmQuery);
    }

    public void refreshSynchronousTableViews() {
        Iterator iterator = this.syncRealmResults.keySet().iterator();
        while (iterator.hasNext()) {
            WeakReference weakRealmResults = (WeakReference)iterator.next();
            RealmResults realmResults = (RealmResults)weakRealmResults.get();
            if (realmResults == null) {
                iterator.remove();
                continue;
            }
            realmResults.syncIfNeeded();
        }
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.checkCanBeAutoRefreshed();
        this.autoRefresh = autoRefresh;
    }

    public boolean isAutoRefreshEnabled() {
        return this.autoRefresh;
    }

    public void checkCanBeAutoRefreshed() {
        if (Looper.myLooper() == null) {
            throw new IllegalStateException("Cannot set auto-refresh in a Thread without a Looper");
        }
        if (HandlerController.isIntentServiceThread()) {
            throw new IllegalStateException("Cannot set auto-refresh in an IntentService thread.");
        }
    }

    public boolean isAutoRefreshAvailable() {
        return Looper.myLooper() != null && !HandlerController.isIntentServiceThread();
    }

    private static boolean isIntentServiceThread() {
        String threadName = Thread.currentThread().getName();
        return threadName != null && threadName.startsWith("IntentService[");
    }
}

