/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.RealmCache;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmQuery;
import io.realm.exceptions.RealmException;
import io.realm.internal.Table;
import io.realm.log.RealmLog;
import rx.Observable;

public final class DynamicRealm
extends BaseRealm {
    private DynamicRealm(RealmConfiguration configuration) {
        super(configuration);
    }

    public static DynamicRealm getInstance(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        return RealmCache.createRealmOrGetFromCache(configuration, DynamicRealm.class);
    }

    public DynamicRealmObject createObject(String className) {
        this.checkIfValid();
        Table table = this.schema.getTable(className);
        if (table.hasPrimaryKey()) {
            throw new RealmException(String.format("'%s' has a primary key, use 'createObject(String, Object)' instead.", className));
        }
        long rowIndex = table.addEmptyRow();
        return this.get(DynamicRealmObject.class, className, rowIndex);
    }

    public DynamicRealmObject createObject(String className, Object primaryKeyValue) {
        Table table = this.schema.getTable(className);
        long index = table.addEmptyRowWithPrimaryKey(primaryKeyValue);
        return new DynamicRealmObject(this, table.getCheckedRow(index));
    }

    public RealmQuery<DynamicRealmObject> where(String className) {
        this.checkIfValid();
        if (!this.sharedRealm.hasTable(Table.TABLE_PREFIX + className)) {
            throw new IllegalArgumentException("Class does not exist in the Realm and cannot be queried: " + className);
        }
        return RealmQuery.createDynamicQuery(this, className);
    }

    public void addChangeListener(RealmChangeListener<DynamicRealm> listener) {
        super.addListener(listener);
    }

    public void delete(String className) {
        this.checkIfValid();
        this.checkIfInTransaction();
        this.schema.getTable(className).clear();
    }

    public void executeTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        this.beginTransaction();
        try {
            transaction.execute(this);
            this.commitTransaction();
        }
        catch (RuntimeException e) {
            if (this.isInTransaction()) {
                this.cancelTransaction();
            } else {
                RealmLog.warn("Could not cancel transaction, not currently in a transaction.", new Object[0]);
            }
            throw e;
        }
    }

    static DynamicRealm createInstance(RealmConfiguration configuration) {
        return new DynamicRealm(configuration);
    }

    public Observable<DynamicRealm> asObservable() {
        return this.configuration.getRxFactory().from(this);
    }

    public static interface Transaction {
        public void execute(DynamicRealm var1);
    }
}

