/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import io.realm.AndroidNotifier;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.HandlerController;
import io.realm.Realm;
import io.realm.RealmCache;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmMigration;
import io.realm.RealmModel;
import io.realm.RealmObjectSchema;
import io.realm.RealmSchema;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.ColumnInfo;
import io.realm.internal.InvalidRow;
import io.realm.internal.ObjectServerFacade;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.SharedRealm;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import io.realm.internal.Util;
import io.realm.internal.async.RealmThreadPoolExecutor;
import io.realm.log.RealmLog;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;

abstract class BaseRealm
implements Closeable {
    protected static final long UNVERSIONED = -1L;
    private static final String INCORRECT_THREAD_CLOSE_MESSAGE = "Realm access from incorrect thread. Realm instance can only be closed on the thread it was created.";
    private static final String INCORRECT_THREAD_MESSAGE = "Realm access from incorrect thread. Realm objects can only be accessed on the thread they were created.";
    private static final String CLOSED_REALM_MESSAGE = "This Realm instance has already been closed, making it unusable.";
    private static final String NOT_IN_TRANSACTION_MESSAGE = "Changing Realm data can only be done from inside a transaction.";
    static volatile Context applicationContext;
    static final RealmThreadPoolExecutor asyncTaskExecutor;
    final long threadId = Thread.currentThread().getId();
    protected RealmConfiguration configuration;
    protected SharedRealm sharedRealm;
    RealmSchema schema;
    HandlerController handlerController;
    public static final ThreadLocalRealmObjectContext objectContext;

    protected BaseRealm(RealmConfiguration configuration) {
        this.configuration = configuration;
        this.handlerController = new HandlerController(this);
        this.sharedRealm = SharedRealm.getInstance(configuration, new AndroidNotifier(this.handlerController), !(this instanceof Realm) ? null : new SharedRealm.SchemaVersionListener(){

            @Override
            public void onSchemaVersionChanged(long currentVersion) {
                RealmCache.updateSchemaCache((Realm)BaseRealm.this);
            }
        });
        this.schema = new RealmSchema(this);
        if (this.handlerController.isAutoRefreshAvailable()) {
            this.setAutoRefresh(true);
        }
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.checkIfValid();
        this.handlerController.checkCanBeAutoRefreshed();
        this.handlerController.setAutoRefresh(autoRefresh);
    }

    public boolean isAutoRefresh() {
        return this.handlerController.isAutoRefreshEnabled();
    }

    public boolean isInTransaction() {
        this.checkIfValid();
        return this.sharedRealm.isInTransaction();
    }

    protected void addListener(RealmChangeListener<? extends BaseRealm> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        this.checkIfValid();
        if (!this.handlerController.isAutoRefreshEnabled()) {
            throw new IllegalStateException("You can't register a listener from a non-Looper or IntentService thread.");
        }
        this.handlerController.addChangeListener(listener);
    }

    public void removeChangeListener(RealmChangeListener<? extends BaseRealm> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        this.checkIfValid();
        if (!this.handlerController.isAutoRefreshEnabled()) {
            throw new IllegalStateException("You can't remove a listener from a non-Looper thread ");
        }
        this.handlerController.removeChangeListener(listener);
    }

    public abstract Observable asObservable();

    public void removeAllChangeListeners() {
        this.checkIfValid();
        if (!this.handlerController.isAutoRefreshEnabled()) {
            throw new IllegalStateException("You can't remove listeners from a non-Looper thread ");
        }
        this.handlerController.removeAllChangeListeners();
    }

    void setHandler(Handler handler) {
        ((AndroidNotifier)this.sharedRealm.realmNotifier).setHandler(handler);
    }

    public void writeCopyTo(File destination) {
        this.writeEncryptedCopyTo(destination, null);
    }

    public void writeEncryptedCopyTo(File destination, byte[] key) {
        if (destination == null) {
            throw new IllegalArgumentException("The destination argument cannot be null");
        }
        this.checkIfValid();
        this.sharedRealm.writeCopy(destination, key);
    }

    public boolean waitForChange() {
        this.checkIfValid();
        if (this.isInTransaction()) {
            throw new IllegalStateException("Cannot wait for changes inside of a transaction.");
        }
        if (Looper.myLooper() != null) {
            throw new IllegalStateException("Cannot wait for changes inside a Looper thread. Use RealmChangeListeners instead.");
        }
        boolean hasChanged = this.sharedRealm.waitForChange();
        if (hasChanged) {
            this.sharedRealm.refresh();
            this.handlerController.refreshSynchronousTableViews();
        }
        return hasChanged;
    }

    public void stopWaitForChange() {
        RealmCache.invokeWithLock(new RealmCache.Callback0(){

            @Override
            public void onCall() {
                if (BaseRealm.this.sharedRealm == null || BaseRealm.this.sharedRealm.isClosed()) {
                    throw new IllegalStateException(BaseRealm.CLOSED_REALM_MESSAGE);
                }
                BaseRealm.this.sharedRealm.stopWaitForChange();
            }
        });
    }

    public void beginTransaction() {
        this.checkIfValid();
        this.sharedRealm.beginTransaction();
    }

    public void commitTransaction() {
        this.commitTransaction(true);
    }

    void commitTransaction(boolean notifyLocalThread) {
        this.checkIfValid();
        this.sharedRealm.commitTransaction();
        ObjectServerFacade.getFacade(this.configuration.isSyncConfiguration()).notifyCommit(this.configuration, this.sharedRealm.getLastSnapshotVersion());
        if (notifyLocalThread) {
            this.sharedRealm.realmNotifier.notifyCommitByLocalThread();
        }
    }

    public void cancelTransaction() {
        this.checkIfValid();
        this.sharedRealm.cancelTransaction();
    }

    protected void checkIfValid() {
        if (this.sharedRealm == null || this.sharedRealm.isClosed()) {
            throw new IllegalStateException(CLOSED_REALM_MESSAGE);
        }
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_MESSAGE);
        }
    }

    protected void checkIfInTransaction() {
        if (!this.sharedRealm.isInTransaction()) {
            throw new IllegalStateException(NOT_IN_TRANSACTION_MESSAGE);
        }
    }

    protected void checkIfValidAndInTransaction() {
        if (!this.isInTransaction()) {
            throw new IllegalStateException(NOT_IN_TRANSACTION_MESSAGE);
        }
    }

    void checkNotInSync() {
        if (this.configuration.isSyncConfiguration()) {
            throw new IllegalArgumentException("You cannot perform changes to a schema. Please update app and restart.");
        }
    }

    public String getPath() {
        return this.configuration.getPath();
    }

    public RealmConfiguration getConfiguration() {
        return this.configuration;
    }

    public long getVersion() {
        return this.sharedRealm.getSchemaVersion();
    }

    @Override
    public void close() {
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_CLOSE_MESSAGE);
        }
        RealmCache.release(this);
    }

    void doClose() {
        if (this.sharedRealm != null) {
            this.sharedRealm.close();
            this.sharedRealm = null;
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    public boolean isClosed() {
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_MESSAGE);
        }
        return this.sharedRealm == null || this.sharedRealm.isClosed();
    }

    public boolean isEmpty() {
        this.checkIfValid();
        return this.sharedRealm.isEmpty();
    }

    void setVersion(long version) {
        this.sharedRealm.setSchemaVersion(version);
    }

    public RealmSchema getSchema() {
        return this.schema;
    }

    <E extends RealmModel> E get(Class<E> clazz, long rowIndex, boolean acceptDefaultValue, List<String> excludeFields) {
        Table table = this.schema.getTable(clazz);
        UncheckedRow row = table.getUncheckedRow(rowIndex);
        E result = this.configuration.getSchemaMediator().newInstance(clazz, this, row, this.schema.getColumnInfo(clazz), acceptDefaultValue, excludeFields);
        RealmObjectProxy proxy = (RealmObjectProxy)result;
        proxy.realmGet$proxyState().setTableVersion$realm();
        return result;
    }

    <E extends RealmModel> E get(Class<E> clazz, String dynamicClassName, long rowIndex) {
        DynamicRealmObject dynamicObj;
        Table table;
        boolean isDynamicRealmObject = dynamicClassName != null;
        Table table2 = table = isDynamicRealmObject ? this.schema.getTable(dynamicClassName) : this.schema.getTable(clazz);
        DynamicRealmObject result = isDynamicRealmObject ? (dynamicObj = new DynamicRealmObject(this, rowIndex != -1L ? table.getCheckedRow(rowIndex) : InvalidRow.INSTANCE)) : this.configuration.getSchemaMediator().newInstance(clazz, this, rowIndex != -1L ? table.getUncheckedRow(rowIndex) : InvalidRow.INSTANCE, this.schema.getColumnInfo(clazz), false, Collections.emptyList());
        RealmObjectProxy proxy = result;
        if (rowIndex != -1L) {
            proxy.realmGet$proxyState().setTableVersion$realm();
        }
        return (E)result;
    }

    public void deleteAll() {
        this.checkIfValid();
        for (RealmObjectSchema objectSchema : this.schema.getAll()) {
            this.schema.getTable(objectSchema.getClassName()).clear();
        }
    }

    static boolean deleteRealm(final RealmConfiguration configuration) {
        final AtomicBoolean realmDeleted = new AtomicBoolean(true);
        RealmCache.invokeWithGlobalRefCount(configuration, new RealmCache.Callback(){

            @Override
            public void onResult(int count) {
                if (count != 0) {
                    throw new IllegalStateException("It's not allowed to delete the file associated with an open Realm. Remember to close() all the instances of the Realm before deleting its file: " + configuration.getPath());
                }
                String canonicalPath = configuration.getPath();
                File realmFolder = configuration.getRealmDirectory();
                String realmFileName = configuration.getRealmFileName();
                realmDeleted.set(Util.deleteRealm(canonicalPath, realmFolder, realmFileName));
            }
        });
        return realmDeleted.get();
    }

    static boolean compactRealm(RealmConfiguration configuration) {
        if (configuration.getEncryptionKey() != null) {
            throw new IllegalArgumentException("Cannot currently compact an encrypted Realm.");
        }
        SharedRealm sharedRealm = SharedRealm.getInstance(configuration);
        Boolean result = sharedRealm.compact();
        sharedRealm.close();
        return result;
    }

    protected static void migrateRealm(final RealmConfiguration configuration, final RealmMigration migration, final MigrationCallback callback, RealmMigrationNeededException cause) throws FileNotFoundException {
        if (configuration == null) {
            throw new IllegalArgumentException("RealmConfiguration must be provided");
        }
        if (migration == null && configuration.getMigration() == null) {
            throw new RealmMigrationNeededException(configuration.getPath(), "RealmMigration must be provided", cause);
        }
        final AtomicBoolean fileNotFound = new AtomicBoolean(false);
        RealmCache.invokeWithGlobalRefCount(configuration, new RealmCache.Callback(){

            @Override
            public void onResult(int count) {
                if (count != 0) {
                    throw new IllegalStateException("Cannot migrate a Realm file that is already open: " + configuration.getPath());
                }
                File realmFile = new File(configuration.getPath());
                if (!realmFile.exists()) {
                    fileNotFound.set(true);
                    return;
                }
                RealmMigration realmMigration = migration == null ? configuration.getMigration() : migration;
                DynamicRealm realm = null;
                try {
                    realm = DynamicRealm.getInstance(configuration);
                    realm.beginTransaction();
                    long currentVersion = realm.getVersion();
                    realmMigration.migrate(realm, currentVersion, configuration.getSchemaVersion());
                    realm.setVersion(configuration.getSchemaVersion());
                    realm.commitTransaction();
                }
                catch (RuntimeException e) {
                    if (realm != null) {
                        realm.cancelTransaction();
                    }
                    throw e;
                }
                finally {
                    if (realm != null) {
                        realm.close();
                        callback.migrationComplete();
                    }
                }
            }
        });
        if (fileNotFound.get()) {
            throw new FileNotFoundException("Cannot migrate a Realm file which doesn't exist: " + configuration.getPath());
        }
    }

    boolean hasValidNotifier() {
        return this.sharedRealm.realmNotifier != null && this.sharedRealm.realmNotifier.isValid();
    }

    protected void finalize() throws Throwable {
        if (this.sharedRealm != null && !this.sharedRealm.isClosed()) {
            RealmLog.warn("Remember to call close() on all Realm instances. Realm %s is being finalized without being closed, this can lead to running out of native memory.", this.configuration.getPath());
        }
        super.finalize();
    }

    static {
        asyncTaskExecutor = RealmThreadPoolExecutor.newDefaultExecutor();
        objectContext = new ThreadLocalRealmObjectContext();
    }

    static final class ThreadLocalRealmObjectContext
    extends ThreadLocal<RealmObjectContext> {
        ThreadLocalRealmObjectContext() {
        }

        @Override
        protected RealmObjectContext initialValue() {
            return new RealmObjectContext();
        }
    }

    public static final class RealmObjectContext {
        private BaseRealm realm;
        private Row row;
        private ColumnInfo columnInfo;
        private boolean acceptDefaultValue;
        private List<String> excludeFields;

        public void set(BaseRealm realm, Row row, ColumnInfo columnInfo, boolean acceptDefaultValue, List<String> excludeFields) {
            this.realm = realm;
            this.row = row;
            this.columnInfo = columnInfo;
            this.acceptDefaultValue = acceptDefaultValue;
            this.excludeFields = excludeFields;
        }

        public BaseRealm getRealm() {
            return this.realm;
        }

        public Row getRow() {
            return this.row;
        }

        public ColumnInfo getColumnInfo() {
            return this.columnInfo;
        }

        public boolean getAcceptDefaultValue() {
            return this.acceptDefaultValue;
        }

        public List<String> getExcludeFields() {
            return this.excludeFields;
        }

        public void clear() {
            this.realm = null;
            this.row = null;
            this.columnInfo = null;
            this.acceptDefaultValue = false;
            this.excludeFields = null;
        }
    }

    protected static interface MigrationCallback {
        public void migrationComplete();
    }
}

