/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import io.realm.HandlerController;
import io.realm.internal.RealmNotifier;
import io.realm.internal.async.QueryUpdateTask;
import io.realm.log.RealmLog;

class AndroidNotifier
implements RealmNotifier {
    private Handler handler;

    public AndroidNotifier(HandlerController handlerController) {
        if (AndroidNotifier.isAutoRefreshAvailable()) {
            this.handler = new Handler((Handler.Callback)handlerController);
        }
    }

    @Override
    public void notifyCommitByLocalThread() {
        if (this.handler == null) {
            return;
        }
        Message msg = Message.obtain();
        msg.what = 165580141;
        if (!this.handler.hasMessages(165580141)) {
            this.handler.removeMessages(14930352);
            this.handler.sendMessageAtFrontOfQueue(msg);
        }
    }

    @Override
    public void notifyCommitByOtherThread() {
        if (this.handler == null) {
            return;
        }
        boolean messageHandled = true;
        if (!this.handler.hasMessages(14930352) && !this.handler.hasMessages(165580141)) {
            messageHandled = this.handler.sendEmptyMessage(14930352);
        }
        if (!messageHandled) {
            RealmLog.warn("Cannot update Looper threads when the Looper has quit. Use realm.setAutoRefresh(false) to prevent this.", new Object[0]);
        }
    }

    @Override
    public void post(Runnable runnable) {
        Looper looper = this.handler.getLooper();
        if (looper.getThread().isAlive()) {
            this.handler.post(runnable);
        }
    }

    @Override
    public boolean isValid() {
        return this.handler != null;
    }

    @Override
    public void close() {
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler = null;
        }
    }

    @Override
    public void completeAsyncResults(QueryUpdateTask.Result result) {
        Looper looper = this.handler.getLooper();
        if (looper.getThread().isAlive()) {
            this.handler.obtainMessage(39088169, (Object)result).sendToTarget();
        }
    }

    @Override
    public void completeAsyncObject(QueryUpdateTask.Result result) {
        Looper looper = this.handler.getLooper();
        if (looper.getThread().isAlive()) {
            this.handler.obtainMessage(63245986, (Object)result).sendToTarget();
        }
    }

    @Override
    public void throwBackgroundException(Throwable throwable) {
        Looper looper = this.handler.getLooper();
        if (looper.getThread().isAlive()) {
            this.handler.obtainMessage(102334155, (Object)new Error(throwable)).sendToTarget();
        }
    }

    @Override
    public void completeUpdateAsyncQueries(QueryUpdateTask.Result result) {
        Looper looper = this.handler.getLooper();
        if (looper.getThread().isAlive()) {
            this.handler.obtainMessage(24157817, (Object)result).sendToTarget();
        }
    }

    private static boolean isAutoRefreshAvailable() {
        return Looper.myLooper() != null && !AndroidNotifier.isIntentServiceThread();
    }

    private static boolean isIntentServiceThread() {
        String threadName = Thread.currentThread().getName();
        return threadName != null && threadName.startsWith("IntentService[");
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }
}

