/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.BinarySetIterator;
import io.realm.BooleanSetIterator;
import io.realm.ByteSetIterator;
import io.realm.CollectionUtils;
import io.realm.DateSetIterator;
import io.realm.Decimal128SetIterator;
import io.realm.DoubleSetIterator;
import io.realm.DynamicRealmObject;
import io.realm.DynamicSetIterator;
import io.realm.FloatSetIterator;
import io.realm.IntegerSetIterator;
import io.realm.LongSetIterator;
import io.realm.ObjectIdSetIterator;
import io.realm.RealmAny;
import io.realm.RealmAnySetIterator;
import io.realm.RealmChangeListener;
import io.realm.RealmModelSetIterator;
import io.realm.RealmQuery;
import io.realm.RealmSet;
import io.realm.SetChangeListener;
import io.realm.SetChangeSet;
import io.realm.SetIterator;
import io.realm.ShortSetIterator;
import io.realm.StringSetIterator;
import io.realm.UUIDSetIterator;
import io.realm.internal.ObservableSet;
import io.realm.internal.ObserverPairList;
import io.realm.internal.OsSet;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

abstract class SetValueOperator<E>
implements ObservableSet {
    protected final BaseRealm baseRealm;
    protected final OsSet osSet;
    protected final Class<E> valueClass;
    protected final String className;
    protected final ObserverPairList<ObservableSet.SetObserverPair<E>> setObserverPairs = new ObserverPairList();

    SetValueOperator(BaseRealm baseRealm, OsSet osSet, Class<E> valueClass) {
        this(baseRealm, osSet, valueClass, valueClass.getSimpleName());
    }

    SetValueOperator(BaseRealm baseRealm, OsSet osSet, Class<E> valueClass, String className) {
        this.baseRealm = baseRealm;
        this.osSet = osSet;
        this.valueClass = valueClass;
        this.className = className;
    }

    abstract boolean add(@Nullable E var1);

    abstract boolean containsInternal(@Nullable Object var1);

    abstract boolean removeInternal(@Nullable Object var1);

    abstract boolean containsAllInternal(Collection<?> var1);

    abstract boolean addAllInternal(Collection<? extends E> var1);

    abstract boolean removeAllInternal(Collection<?> var1);

    abstract boolean retainAllInternal(Collection<?> var1);

    RealmQuery<E> where() {
        throw new UnsupportedOperationException("This feature is available only when the element type is implementing RealmModel.");
    }

    void deleteAll() {
        this.osSet.deleteAll();
    }

    @Override
    public void notifyChangeListeners(long nativeChangeSetPtr) {
        this.osSet.notifyChangeListeners(nativeChangeSetPtr, this.setObserverPairs);
    }

    boolean contains(@Nullable Object o) {
        if (!this.isObjectSameType(o)) {
            throw new ClassCastException("Set contents and object must be the same type when calling 'contains'.");
        }
        return this.containsInternal(o);
    }

    boolean remove(@Nullable Object o) {
        if (!this.isObjectSameType(o)) {
            throw new ClassCastException("Set contents and object must be the same type when calling 'remove'.");
        }
        return this.removeInternal(o);
    }

    boolean containsAll(Collection<?> c) {
        if (this.isRealmCollection(c)) {
            OsSet otherOsSet = ((RealmSet)c).getOsSet();
            return this.funnelCollection(otherOsSet, OsSet.ExternalCollectionOperation.CONTAINS_ALL);
        }
        if (!this.isCollectionSameType(c)) {
            throw new ClassCastException("Set contents and collection must be the same type when calling 'containsAll'.");
        }
        return this.containsAllInternal(c);
    }

    boolean addAll(Collection<? extends E> c) {
        if (this.isRealmCollection(c)) {
            OsSet otherOsSet = ((RealmSet)c).getOsSet();
            return this.funnelCollection(otherOsSet, OsSet.ExternalCollectionOperation.ADD_ALL);
        }
        if (!this.isUpperBoundCollectionSameType(c)) {
            throw new ClassCastException("Set contents and collection must be the same type when calling 'addAll'.");
        }
        return this.addAllInternal(c);
    }

    boolean removeAll(Collection<?> c) {
        if (this.isRealmCollection(c)) {
            OsSet otherOsSet = ((RealmSet)c).getOsSet();
            return this.funnelCollection(otherOsSet, OsSet.ExternalCollectionOperation.REMOVE_ALL);
        }
        if (!this.isCollectionSameType(c)) {
            throw new ClassCastException("Set contents and collection must be the same type when calling 'removeAll'.");
        }
        return this.removeAllInternal(c);
    }

    boolean retainAll(Collection<?> c) {
        if (this.isRealmCollection(c)) {
            OsSet otherOsSet = ((RealmSet)c).getOsSet();
            return this.funnelCollection(otherOsSet, OsSet.ExternalCollectionOperation.RETAIN_ALL);
        }
        if (!this.isCollectionSameType(c)) {
            throw new ClassCastException("Set contents and collection must be the same type when calling 'retainAll'.");
        }
        return this.retainAllInternal(c);
    }

    boolean isValid() {
        if (this.baseRealm.isClosed()) {
            return false;
        }
        return this.osSet.isValid();
    }

    boolean isFrozen() {
        return this.baseRealm.isFrozen();
    }

    int size() {
        return Long.valueOf(this.osSet.size()).intValue();
    }

    boolean isEmpty() {
        return this.size() == 0;
    }

    Iterator<E> iterator() {
        return SetValueOperator.iteratorFactory(this.valueClass, this.osSet, this.baseRealm, this.className);
    }

    void clear() {
        this.osSet.clear();
    }

    RealmSet<E> freeze() {
        BaseRealm frozenRealm = this.baseRealm.freeze();
        OsSet frozenOsSet = this.osSet.freeze(frozenRealm.sharedRealm);
        return new RealmSet<E>(frozenRealm, frozenOsSet, this.valueClass);
    }

    void addChangeListener(RealmSet<E> realmSet, SetChangeListener<E> listener) {
        CollectionUtils.checkForAddRemoveListener(this.baseRealm, listener, true);
        if (this.setObserverPairs.isEmpty()) {
            this.osSet.startListening(this);
        }
        ObservableSet.SetObserverPair<E> setObserverPair = new ObservableSet.SetObserverPair<E>(realmSet, listener);
        this.setObserverPairs.add(setObserverPair);
    }

    void addChangeListener(RealmSet<E> realmSet, final RealmChangeListener<RealmSet<E>> listener) {
        SetChangeListener changeListener = new SetChangeListener<E>(){

            @Override
            public void onChange(RealmSet<E> set, SetChangeSet changes) {
                listener.onChange(set);
            }
        };
        this.addChangeListener(realmSet, changeListener);
    }

    void removeChangeListener(RealmSet<E> realmSet, final RealmChangeListener<RealmSet<E>> listener) {
        this.removeChangeListener(realmSet, new SetChangeListener<E>(){

            @Override
            public void onChange(RealmSet<E> set, SetChangeSet changes) {
                listener.onChange(set);
            }
        });
    }

    void removeChangeListener(RealmSet<E> realmSet, SetChangeListener<E> listener) {
        this.setObserverPairs.remove(realmSet, listener);
        if (this.setObserverPairs.isEmpty()) {
            this.osSet.stopListening();
        }
    }

    void removeAllChangeListeners() {
        CollectionUtils.checkForAddRemoveListener(this.baseRealm, null, false);
        this.setObserverPairs.clear();
        this.osSet.stopListening();
    }

    boolean hasListeners() {
        return !this.setObserverPairs.isEmpty();
    }

    OsSet getOsSet() {
        return this.osSet;
    }

    protected boolean isRealmCollection(Collection<?> c) {
        return c instanceof RealmSet && ((RealmSet)c).isManaged();
    }

    protected boolean funnelCollection(OsSet otherOsSet, OsSet.ExternalCollectionOperation operation) {
        if (this.osSet.getNativePtr() == otherOsSet.getNativePtr()) {
            switch (operation) {
                case CONTAINS_ALL: {
                    return true;
                }
                case ADD_ALL: {
                    return false;
                }
                case REMOVE_ALL: {
                    this.osSet.clear();
                    return true;
                }
                case RETAIN_ALL: {
                    return false;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)operation));
        }
        switch (operation) {
            case CONTAINS_ALL: {
                return this.osSet.containsAll(otherOsSet);
            }
            case ADD_ALL: {
                return this.osSet.union(otherOsSet);
            }
            case REMOVE_ALL: {
                return this.osSet.asymmetricDifference(otherOsSet);
            }
            case RETAIN_ALL: {
                return this.osSet.intersect(otherOsSet);
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)operation));
    }

    private boolean isObjectSameType(@Nullable Object object) {
        if (object != null) {
            return this.valueClass.isAssignableFrom(object.getClass());
        }
        return true;
    }

    private boolean isUpperBoundCollectionSameType(Collection<? extends E> c) {
        if (!c.isEmpty()) {
            for (E item : c) {
                if (item == null || this.valueClass.isAssignableFrom(item.getClass())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isCollectionSameType(Collection<?> c) {
        if (!c.isEmpty()) {
            for (Object item : c) {
                if (item == null || this.valueClass.isAssignableFrom(item.getClass())) continue;
                return false;
            }
        }
        return true;
    }

    private static <T> SetIterator<T> iteratorFactory(Class<T> valueClass, OsSet osSet, BaseRealm baseRealm, String className) {
        if (valueClass == Boolean.class) {
            return new BooleanSetIterator(osSet, baseRealm);
        }
        if (valueClass == String.class) {
            return new StringSetIterator(osSet, baseRealm);
        }
        if (valueClass == Integer.class) {
            return new IntegerSetIterator(osSet, baseRealm);
        }
        if (valueClass == Long.class) {
            return new LongSetIterator(osSet, baseRealm);
        }
        if (valueClass == Short.class) {
            return new ShortSetIterator(osSet, baseRealm);
        }
        if (valueClass == Byte.class) {
            return new ByteSetIterator(osSet, baseRealm);
        }
        if (valueClass == Float.class) {
            return new FloatSetIterator(osSet, baseRealm);
        }
        if (valueClass == Double.class) {
            return new DoubleSetIterator(osSet, baseRealm);
        }
        if (valueClass == byte[].class) {
            return new BinarySetIterator(osSet, baseRealm);
        }
        if (valueClass == Date.class) {
            return new DateSetIterator(osSet, baseRealm);
        }
        if (valueClass == Decimal128.class) {
            return new Decimal128SetIterator(osSet, baseRealm);
        }
        if (valueClass == ObjectId.class) {
            return new ObjectIdSetIterator(osSet, baseRealm);
        }
        if (valueClass == UUID.class) {
            return new UUIDSetIterator(osSet, baseRealm);
        }
        if (valueClass == RealmAny.class) {
            return new RealmAnySetIterator(osSet, baseRealm);
        }
        if (valueClass == DynamicRealmObject.class) {
            return new DynamicSetIterator(osSet, baseRealm, className);
        }
        if (CollectionUtils.isClassForRealmModel(valueClass)) {
            return new RealmModelSetIterator<T>(osSet, baseRealm, valueClass);
        }
        throw new IllegalArgumentException("Unknown class for iterator: " + valueClass.getSimpleName());
    }

    public Class<E> getValueClass() {
        return this.valueClass;
    }

    public String getValueClassName() {
        return this.className;
    }
}

