/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.RealmAny;
import io.realm.RealmAnyOperator;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.core.NativeRealmAny;
import java.util.Collections;

class RealmModelOperator
extends RealmAnyOperator {
    private final Class<? extends RealmModel> clazz;
    private final RealmModel value;

    private static <T extends RealmModel> T getRealmModel(BaseRealm realm, Class<T> clazz, NativeRealmAny nativeRealmAny) {
        return realm.get(clazz, nativeRealmAny.getRealmModelRowKey(), false, Collections.emptyList());
    }

    RealmModelOperator(RealmModel realmModel) {
        super(RealmAny.Type.OBJECT);
        this.value = realmModel;
        this.clazz = realmModel.getClass();
    }

    <T extends RealmModel> RealmModelOperator(BaseRealm realm, NativeRealmAny nativeRealmAny, Class<T> clazz) {
        super(RealmAny.Type.OBJECT, nativeRealmAny);
        this.clazz = clazz;
        this.value = RealmModelOperator.getRealmModel(realm, clazz, nativeRealmAny);
    }

    @Override
    protected NativeRealmAny createNativeRealmAny() {
        if (!(this.value instanceof RealmObjectProxy)) {
            throw new IllegalStateException("Native RealmAny instances only allow managed Realm objects or primitives");
        }
        return new NativeRealmAny(this.getValue(RealmObjectProxy.class));
    }

    @Override
    <T> T getValue(Class<T> clazz) {
        return clazz.cast(this.value);
    }

    @Override
    Class<?> getTypedClass() {
        return RealmObjectProxy.class.isAssignableFrom(this.clazz) ? this.clazz.getSuperclass() : this.clazz;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        RealmModelOperator otherOperator = (RealmModelOperator)other;
        return this.value == null ? otherOperator.value == null : this.value.equals(otherOperator.value);
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public void checkValidObject(BaseRealm realm) {
        if (!RealmObject.isValid(this.value) || !RealmObject.isManaged(this.value)) {
            throw new IllegalArgumentException("Realm object is not a valid managed object.");
        }
        if (((RealmObjectProxy)this.value).realmGet$proxyState().getRealm$realm() != realm) {
            throw new IllegalArgumentException("Realm object belongs to a different Realm.");
        }
    }
}

