/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.OrderedRealmCollection;
import io.realm.OrderedRealmCollectionSnapshot;
import io.realm.Realm;
import io.realm.RealmAny;
import io.realm.RealmAnyOperator;
import io.realm.RealmResults;
import io.realm.Sort;
import io.realm.internal.InvalidRow;
import io.realm.internal.OsResults;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import io.realm.internal.core.NativeRealmAny;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import javax.annotation.Nullable;

abstract class OrderedRealmCollectionImpl<E>
extends AbstractList<E>
implements OrderedRealmCollection<E> {
    private static final String NOT_SUPPORTED_MESSAGE = "This method is not supported by 'RealmResults' or 'OrderedRealmCollectionSnapshot'.";
    public final BaseRealm baseRealm;
    @Nullable
    final Class<E> classSpec;
    @Nullable
    final String className;
    final OsResults osResults;
    final CollectionOperator<E> operator;

    OrderedRealmCollectionImpl(BaseRealm baseRealm, OsResults osResults, Class<E> clazz) {
        this(baseRealm, osResults, clazz, null, OrderedRealmCollectionImpl.getCollectionOperator(false, baseRealm, osResults, clazz, null));
    }

    OrderedRealmCollectionImpl(BaseRealm baseRealm, OsResults osResults, Class<E> clazz, CollectionOperator<E> operator) {
        this(baseRealm, osResults, clazz, null, operator);
    }

    OrderedRealmCollectionImpl(BaseRealm baseRealm, OsResults osResults, String className) {
        this(baseRealm, osResults, null, className, OrderedRealmCollectionImpl.getCollectionOperator(false, baseRealm, osResults, null, className));
    }

    OrderedRealmCollectionImpl(BaseRealm baseRealm, OsResults osResults, String className, CollectionOperator<E> operator) {
        this(baseRealm, osResults, null, className, operator);
    }

    private OrderedRealmCollectionImpl(BaseRealm baseRealm, OsResults osResults, @Nullable Class<E> clazz, @Nullable String className, CollectionOperator<E> operator) {
        this.baseRealm = baseRealm;
        this.osResults = osResults;
        this.classSpec = clazz;
        this.className = className;
        this.operator = operator;
    }

    Table getTable() {
        return this.osResults.getTable();
    }

    OsResults getOsResults() {
        return this.osResults;
    }

    @Override
    public boolean isValid() {
        return this.osResults.isValid();
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        if (this.isLoaded()) {
            RealmObjectProxy proxy;
            if (object instanceof RealmObjectProxy && (proxy = (RealmObjectProxy)object).realmGet$proxyState().getRow$realm() == InvalidRow.INSTANCE) {
                return false;
            }
            for (E e : this) {
                if (e instanceof byte[] && object instanceof byte[]) {
                    if (!Arrays.equals((byte[])e, (byte[])object)) continue;
                    return true;
                }
                if (e != null && e.equals(object)) {
                    return true;
                }
                if (e != null || object != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public E get(int location) {
        this.baseRealm.checkIfValid();
        return this.operator.get(location);
    }

    @Override
    @Nullable
    public E first() {
        return this.firstImpl(true, null);
    }

    @Override
    @Nullable
    public E first(@Nullable E defaultValue) {
        return this.firstImpl(false, defaultValue);
    }

    @Nullable
    private E firstImpl(boolean shouldThrow, @Nullable E defaultValue) {
        return this.operator.firstImpl(shouldThrow, defaultValue);
    }

    @Override
    @Nullable
    public E last() {
        return this.lastImpl(true, null);
    }

    @Override
    @Nullable
    public E last(@Nullable E defaultValue) {
        return this.lastImpl(false, defaultValue);
    }

    @Nullable
    private E lastImpl(boolean shouldThrow, @Nullable E defaultValue) {
        return this.operator.lastImpl(shouldThrow, defaultValue);
    }

    @Override
    public void deleteFromRealm(int location) {
        this.baseRealm.checkIfValidAndInTransaction();
        this.osResults.delete(location);
    }

    @Override
    public boolean deleteAllFromRealm() {
        this.baseRealm.checkIfValid();
        if (this.size() > 0) {
            this.osResults.clear();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new RealmCollectionIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new RealmCollectionListIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int location) {
        return new RealmCollectionListIterator(location);
    }

    private long getColumnKeyForSort(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException("Non-empty field name required.");
        }
        if (fieldName.contains(".")) {
            throw new IllegalArgumentException("Aggregates on child object fields are not supported: " + fieldName);
        }
        long columnKey = this.osResults.getTable().getColumnKey(fieldName);
        if (columnKey < 0L) {
            throw new IllegalArgumentException(String.format(Locale.US, "Field '%s' does not exist.", fieldName));
        }
        return columnKey;
    }

    @Override
    public RealmResults<E> sort(String fieldName) {
        OsResults sortedOsResults = this.osResults.sort(this.baseRealm.getSchema().getKeyPathMapping(), fieldName, Sort.ASCENDING);
        return this.createLoadedResults(sortedOsResults);
    }

    @Override
    public RealmResults<E> sort(String fieldName, Sort sortOrder) {
        OsResults sortedOsResults = this.osResults.sort(this.baseRealm.getSchema().getKeyPathMapping(), fieldName, sortOrder);
        return this.createLoadedResults(sortedOsResults);
    }

    @Override
    public RealmResults<E> sort(String[] fieldNames, Sort[] sortOrders) {
        OsResults sortedOsResults = this.osResults.sort(this.baseRealm.getSchema().getKeyPathMapping(), fieldNames, sortOrders);
        return this.createLoadedResults(sortedOsResults);
    }

    @Override
    public RealmResults<E> sort(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        return this.sort(new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    @Override
    public int size() {
        if (this.isLoaded()) {
            long size = this.osResults.size();
            return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
        }
        return 0;
    }

    @Override
    public Number min(String fieldName) {
        this.baseRealm.checkIfValid();
        long columnKey = this.getColumnKeyForSort(fieldName);
        return this.osResults.aggregateNumber(OsResults.Aggregate.MINIMUM, columnKey);
    }

    @Override
    public Date minDate(String fieldName) {
        this.baseRealm.checkIfValid();
        long columnIndex = this.getColumnKeyForSort(fieldName);
        return this.osResults.aggregateDate(OsResults.Aggregate.MINIMUM, columnIndex);
    }

    @Override
    public Number max(String fieldName) {
        this.baseRealm.checkIfValid();
        long columnIndex = this.getColumnKeyForSort(fieldName);
        return this.osResults.aggregateNumber(OsResults.Aggregate.MAXIMUM, columnIndex);
    }

    @Override
    @Nullable
    public Date maxDate(String fieldName) {
        this.baseRealm.checkIfValid();
        long columnIndex = this.getColumnKeyForSort(fieldName);
        return this.osResults.aggregateDate(OsResults.Aggregate.MAXIMUM, columnIndex);
    }

    @Override
    public Number sum(String fieldName) {
        this.baseRealm.checkIfValid();
        long columnIndex = this.getColumnKeyForSort(fieldName);
        return this.osResults.aggregateNumber(OsResults.Aggregate.SUM, columnIndex);
    }

    @Override
    public double average(String fieldName) {
        this.baseRealm.checkIfValid();
        long columnIndex = this.getColumnKeyForSort(fieldName);
        Number avg = this.osResults.aggregateNumber(OsResults.Aggregate.AVERAGE, columnIndex);
        return avg.doubleValue();
    }

    @Override
    @Deprecated
    public E remove(int index) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean remove(Object object) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public E set(int location, E object) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public boolean deleteLastFromRealm() {
        this.baseRealm.checkIfValidAndInTransaction();
        return this.osResults.deleteLast();
    }

    @Override
    public boolean deleteFirstFromRealm() {
        this.baseRealm.checkIfValidAndInTransaction();
        return this.osResults.deleteFirst();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean add(E element) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public void add(int index, E element) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean addAll(int location, Collection<? extends E> collection) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public OrderedRealmCollectionSnapshot<E> createSnapshot() {
        if (this.className != null) {
            return new OrderedRealmCollectionSnapshot(this.baseRealm, this.osResults, this.className);
        }
        return new OrderedRealmCollectionSnapshot<E>(this.baseRealm, this.osResults, this.classSpec);
    }

    public Realm getRealm() {
        this.baseRealm.checkIfValid();
        if (!(this.baseRealm instanceof Realm)) {
            throw new IllegalStateException("This method is only available for typed Realms");
        }
        return (Realm)this.baseRealm;
    }

    RealmResults<E> createLoadedResults(OsResults newOsResults) {
        RealmResults results = this.className != null ? new RealmResults(this.baseRealm, newOsResults, this.className) : new RealmResults<E>(this.baseRealm, newOsResults, this.classSpec);
        results.load();
        return results;
    }

    protected static <T> CollectionOperator<T> getCollectionOperator(boolean forPrimitives, BaseRealm baseRealm, OsResults osResults, @Nullable Class<T> clazz, @Nullable String className) {
        if (forPrimitives) {
            if (clazz == Integer.class) {
                return new IntegerValueOperator(baseRealm, osResults, Integer.class, className);
            }
            if (clazz == Short.class) {
                return new ShortValueOperator(baseRealm, osResults, Short.class, className);
            }
            if (clazz == Byte.class) {
                return new ByteValueOperator(baseRealm, osResults, Byte.class, className);
            }
            if (clazz == RealmAny.class) {
                return new RealmAnyValueOperator(baseRealm, osResults, RealmAny.class, className);
            }
            return new PrimitiveValueOperator<T>(baseRealm, osResults, clazz, className);
        }
        return new ModelCollectionOperator<T>(baseRealm, osResults, clazz, className);
    }

    static class RealmAnyValueOperator
    extends PrimitiveValueOperator<RealmAny> {
        RealmAnyValueOperator(BaseRealm baseRealm, OsResults osResults, @Nullable Class<RealmAny> classSpec, @Nullable String className) {
            super(baseRealm, osResults, classSpec, className);
        }

        @Override
        public RealmAny get(int location) {
            Object value = this.osResults.getValue(location);
            NativeRealmAny nativeRealmAny = (NativeRealmAny)value;
            return new RealmAny(RealmAnyOperator.fromNativeRealmAny(this.baseRealm, nativeRealmAny));
        }

        @Override
        public RealmAny getFromResults(int pos, OsResults iteratorOsResults) {
            NativeRealmAny nativeRealmAny = (NativeRealmAny)iteratorOsResults.getValue(pos);
            return new RealmAny(RealmAnyOperator.fromNativeRealmAny(this.baseRealm, nativeRealmAny));
        }
    }

    static class ByteValueOperator
    extends PrimitiveValueOperator<Byte> {
        ByteValueOperator(BaseRealm baseRealm, OsResults osResults, @Nullable Class<Byte> classSpec, @Nullable String className) {
            super(baseRealm, osResults, classSpec, className);
        }

        @Override
        public Byte get(int location) {
            Object value = this.osResults.getValue(location);
            Long longValue = (Long)value;
            return longValue.byteValue();
        }

        @Override
        public Byte getFromResults(int pos, OsResults iteratorOsResults) {
            Long longValue = (Long)iteratorOsResults.getValue(pos);
            if (longValue == null) {
                return null;
            }
            return longValue.byteValue();
        }
    }

    static class ShortValueOperator
    extends PrimitiveValueOperator<Short> {
        ShortValueOperator(BaseRealm baseRealm, OsResults osResults, @Nullable Class<Short> classSpec, @Nullable String className) {
            super(baseRealm, osResults, classSpec, className);
        }

        @Override
        public Short get(int location) {
            Object value = this.osResults.getValue(location);
            Long longValue = (Long)value;
            return longValue.shortValue();
        }

        @Override
        public Short getFromResults(int pos, OsResults iteratorOsResults) {
            Long longValue = (Long)iteratorOsResults.getValue(pos);
            if (longValue == null) {
                return null;
            }
            return longValue.shortValue();
        }
    }

    static class IntegerValueOperator
    extends PrimitiveValueOperator<Integer> {
        IntegerValueOperator(BaseRealm baseRealm, OsResults osResults, @Nullable Class<Integer> classSpec, @Nullable String className) {
            super(baseRealm, osResults, classSpec, className);
        }

        @Override
        public Integer get(int location) {
            Object value = this.osResults.getValue(location);
            Long longValue = (Long)value;
            return longValue.intValue();
        }

        @Override
        public Integer getFromResults(int pos, OsResults iteratorOsResults) {
            Long longValue = (Long)iteratorOsResults.getValue(pos);
            if (longValue == null) {
                return null;
            }
            return longValue.intValue();
        }
    }

    static class PrimitiveValueOperator<T>
    extends CollectionOperator<T> {
        PrimitiveValueOperator(BaseRealm baseRealm, OsResults osResults, @Nullable Class<T> classSpec, @Nullable String className) {
            super(baseRealm, osResults, classSpec, className);
        }

        @Override
        public T get(int location) {
            Object value = this.osResults.getValue(location);
            return (T)value;
        }

        @Override
        @Nullable
        public T firstImpl(boolean shouldThrow, @Nullable T defaultValue) {
            if (this.osResults.size() != 0L) {
                return (T)this.osResults.getValue(0);
            }
            return defaultValue;
        }

        @Override
        @Nullable
        public T lastImpl(boolean shouldThrow, @Nullable T defaultValue) {
            int size = (int)this.osResults.size();
            if (size != 0) {
                return (T)this.osResults.getValue(size - 1);
            }
            return defaultValue;
        }

        @Override
        public T convertRowToObject(UncheckedRow row) {
            throw new UnsupportedOperationException("Method 'convertRowToObject' cannot be used on primitive Realm collections.");
        }

        @Override
        public T getFromResults(int pos, OsResults iteratorOsResults) {
            return (T)iteratorOsResults.getValue(pos);
        }
    }

    static class ModelCollectionOperator<T>
    extends CollectionOperator<T> {
        ModelCollectionOperator(BaseRealm baseRealm, OsResults osResults, @Nullable Class<T> clazz, @Nullable String className) {
            super(baseRealm, osResults, clazz, className);
        }

        @Override
        public T get(int location) {
            return (T)this.baseRealm.get(this.classSpec, this.className, this.osResults.getUncheckedRow(location));
        }

        @Override
        @Nullable
        public T firstImpl(boolean shouldThrow, @Nullable T defaultValue) {
            return this.convertToObject(this.osResults.firstUncheckedRow(), shouldThrow, defaultValue);
        }

        @Override
        @Nullable
        public T lastImpl(boolean shouldThrow, @Nullable T defaultValue) {
            return this.convertToObject(this.osResults.lastUncheckedRow(), shouldThrow, defaultValue);
        }

        @Override
        public T convertRowToObject(UncheckedRow row) {
            return (T)this.baseRealm.get(this.classSpec, this.className, row);
        }

        @Override
        public T getFromResults(int pos, OsResults iteratorOsResults) {
            return this.convertRowToObject(iteratorOsResults.getUncheckedRow(pos));
        }
    }

    static abstract class CollectionOperator<T> {
        protected final BaseRealm baseRealm;
        protected final OsResults osResults;
        @Nullable
        protected final Class<T> classSpec;
        @Nullable
        protected final String className;

        CollectionOperator(BaseRealm baseRealm, OsResults osResults, @Nullable Class<T> classSpec, @Nullable String className) {
            this.baseRealm = baseRealm;
            this.osResults = osResults;
            this.classSpec = classSpec;
            this.className = className;
        }

        public abstract T get(int var1);

        @Nullable
        public abstract T firstImpl(boolean var1, @Nullable T var2);

        @Nullable
        public abstract T lastImpl(boolean var1, @Nullable T var2);

        public abstract T convertRowToObject(UncheckedRow var1);

        public abstract T getFromResults(int var1, OsResults var2);

        protected T convertToObject(@Nullable UncheckedRow row, boolean shouldThrow, @Nullable T defaultValue) {
            if (row != null) {
                return this.baseRealm.get(this.classSpec, this.className, row);
            }
            if (shouldThrow) {
                throw new IndexOutOfBoundsException("No results were found.");
            }
            return defaultValue;
        }
    }

    private class RealmCollectionListIterator
    extends OsResults.ListIterator<E> {
        RealmCollectionListIterator(int start) {
            super(OrderedRealmCollectionImpl.this.osResults, start);
        }

        @Override
        protected E convertRowToObject(UncheckedRow row) {
            return OrderedRealmCollectionImpl.this.operator.convertRowToObject(row);
        }

        @Override
        protected E getInternal(int pos, OsResults iteratorOsResults) {
            return OrderedRealmCollectionImpl.this.operator.getFromResults(pos, iteratorOsResults);
        }
    }

    private class RealmCollectionIterator
    extends OsResults.Iterator<E> {
        RealmCollectionIterator() {
            super(OrderedRealmCollectionImpl.this.osResults);
        }

        @Override
        protected E convertRowToObject(UncheckedRow row) {
            return OrderedRealmCollectionImpl.this.operator.convertRowToObject(row);
        }

        @Override
        protected E getInternal(int pos, OsResults iteratorOsResults) {
            return OrderedRealmCollectionImpl.this.operator.getFromResults(pos, iteratorOsResults);
        }
    }
}

