/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.ManagedListOperator;
import io.realm.internal.OsList;
import java.util.Locale;
import javax.annotation.Nullable;

final class LongListOperator<T>
extends ManagedListOperator<T> {
    LongListOperator(BaseRealm realm, OsList osList, Class<T> clazz) {
        super(realm, osList, clazz);
    }

    @Override
    public boolean forRealmModel() {
        return false;
    }

    @Override
    @Nullable
    public T get(int index) {
        Long value = (Long)this.osList.getValue(index);
        if (value == null) {
            return null;
        }
        if (this.clazz == Long.class) {
            return (T)value;
        }
        if (this.clazz == Integer.class) {
            return this.clazz.cast(value.intValue());
        }
        if (this.clazz == Short.class) {
            return this.clazz.cast(value.shortValue());
        }
        if (this.clazz == Byte.class) {
            return this.clazz.cast(value.byteValue());
        }
        throw new IllegalStateException("Unexpected element type: " + this.clazz.getName());
    }

    @Override
    protected void checkValidValue(@Nullable Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unacceptable value type. Acceptable: %1$s, actual: %2$s .", "java.lang.Long, java.lang.Integer, java.lang.Short, java.lang.Byte", value.getClass().getName()));
        }
    }

    @Override
    public void appendValue(Object value) {
        this.osList.addLong(((Number)value).longValue());
    }

    @Override
    public void insertValue(int index, Object value) {
        this.osList.insertLong(index, ((Number)value).longValue());
    }

    @Override
    protected void setValue(int index, Object value) {
        this.osList.setLong(index, ((Number)value).longValue());
    }
}

