/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.core;

import io.realm.RealmModel;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.UncheckedRow;
import io.realm.internal.core.NativeRealmAny;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public final class NativeRealmAnyCollection
implements NativeObject {
    private final long nativePtr;

    public static NativeRealmAnyCollection newBooleanCollection(Collection<Boolean> collection) {
        boolean[] booleanValues = new boolean[collection.size()];
        boolean[] notNull = new boolean[collection.size()];
        int i = 0;
        for (Boolean aBoolean : collection) {
            if (aBoolean != null) {
                booleanValues[i] = aBoolean;
                notNull[i] = true;
            }
            ++i;
        }
        return new NativeRealmAnyCollection(NativeRealmAnyCollection.nativeCreateBooleanCollection(booleanValues, notNull));
    }

    public static NativeRealmAnyCollection newIntegerCollection(Collection<? extends Number> collection) {
        long[] integerValues = new long[collection.size()];
        boolean[] notNull = new boolean[collection.size()];
        int i = 0;
        for (Number number : collection) {
            if (number != null) {
                integerValues[i] = number.longValue();
                notNull[i] = true;
            }
            ++i;
        }
        return new NativeRealmAnyCollection(NativeRealmAnyCollection.nativeCreateIntegerCollection(integerValues, notNull));
    }

    public static NativeRealmAnyCollection newFloatCollection(Collection<? extends Float> collection) {
        float[] floatValues = new float[collection.size()];
        boolean[] notNull = new boolean[collection.size()];
        int i = 0;
        for (Float f : collection) {
            if (f != null) {
                floatValues[i] = f.floatValue();
                notNull[i] = true;
            }
            ++i;
        }
        return new NativeRealmAnyCollection(NativeRealmAnyCollection.nativeCreateFloatCollection(floatValues, notNull));
    }

    public static NativeRealmAnyCollection newDoubleCollection(Collection<? extends Double> collection) {
        double[] doubleValues = new double[collection.size()];
        boolean[] notNull = new boolean[collection.size()];
        int i = 0;
        for (Double d : collection) {
            if (d != null) {
                doubleValues[i] = d;
                notNull[i] = true;
            }
            ++i;
        }
        return new NativeRealmAnyCollection(NativeRealmAnyCollection.nativeCreateDoubleCollection(doubleValues, notNull));
    }

    public static NativeRealmAnyCollection newStringCollection(Collection<String> collection) {
        String[] stringValues = new String[collection.size()];
        boolean[] notNull = new boolean[collection.size()];
        int i = 0;
        for (String aString : collection) {
            if (aString != null) {
                stringValues[i] = aString;
                notNull[i] = true;
            }
            ++i;
        }
        return new NativeRealmAnyCollection(NativeRealmAnyCollection.nativeCreateStringCollection(stringValues, notNull));
    }

    public static NativeRealmAnyCollection newBinaryCollection(Collection<? extends byte[]> collection) {
        byte[][] binaryValues = new byte[collection.size()][];
        boolean[] notNull = new boolean[collection.size()];
        int i = 0;
        for (byte[] byArray : collection) {
            if (byArray != null) {
                binaryValues[i] = byArray;
                notNull[i] = true;
            }
            ++i;
        }
        return new NativeRealmAnyCollection(NativeRealmAnyCollection.nativeCreateBinaryCollection(binaryValues, notNull));
    }

    public static NativeRealmAnyCollection newDateCollection(Collection<? extends Date> collection) {
        long[] dateValues = new long[collection.size()];
        boolean[] notNull = new boolean[collection.size()];
        int i = 0;
        for (Date date : collection) {
            if (date != null) {
                dateValues[i] = date.getTime();
                notNull[i] = true;
            }
            ++i;
        }
        return new NativeRealmAnyCollection(NativeRealmAnyCollection.nativeCreateDateCollection(dateValues, notNull));
    }

    public static NativeRealmAnyCollection newObjectIdCollection(Collection<? extends ObjectId> collection) {
        String[] objectIdValues = new String[collection.size()];
        boolean[] notNull = new boolean[collection.size()];
        int i = 0;
        for (ObjectId objectId : collection) {
            if (objectId != null) {
                objectIdValues[i] = objectId.toString();
                notNull[i] = true;
            }
            ++i;
        }
        return new NativeRealmAnyCollection(NativeRealmAnyCollection.nativeCreateObjectIdCollection(objectIdValues, notNull));
    }

    public static NativeRealmAnyCollection newDecimal128Collection(Collection<? extends Decimal128> collection) {
        long[] lowValues = new long[collection.size()];
        long[] highValues = new long[collection.size()];
        boolean[] notNull = new boolean[collection.size()];
        int i = 0;
        for (Decimal128 decimal128 : collection) {
            if (decimal128 != null) {
                lowValues[i] = decimal128.getLow();
                highValues[i] = decimal128.getHigh();
                notNull[i] = true;
            }
            ++i;
        }
        return new NativeRealmAnyCollection(NativeRealmAnyCollection.nativeCreateDecimal128Collection(lowValues, highValues, notNull));
    }

    public static NativeRealmAnyCollection newUUIDCollection(Collection<? extends UUID> collection) {
        String[] uuidValues = new String[collection.size()];
        boolean[] notNull = new boolean[collection.size()];
        int i = 0;
        for (UUID uUID : collection) {
            if (uUID != null) {
                uuidValues[i] = uUID.toString();
                notNull[i] = true;
            }
            ++i;
        }
        return new NativeRealmAnyCollection(NativeRealmAnyCollection.nativeCreateUUIDCollection(uuidValues, notNull));
    }

    public static NativeRealmAnyCollection newRealmModelCollection(Collection<? extends RealmModel> collection) {
        long[] objectValues = new long[collection.size()];
        boolean[] notNull = new boolean[collection.size()];
        int i = 0;
        for (RealmModel realmModel : collection) {
            if (realmModel != null) {
                RealmObjectProxy proxy = (RealmObjectProxy)realmModel;
                objectValues[i] = ((UncheckedRow)proxy.realmGet$proxyState().getRow$realm()).getNativePtr();
                notNull[i] = true;
            }
            ++i;
        }
        return new NativeRealmAnyCollection(NativeRealmAnyCollection.nativeCreateObjectCollection(objectValues, notNull));
    }

    public static NativeRealmAnyCollection newRealmAnyCollection(long[] realmAnyPtrs, boolean[] notNull) {
        return new NativeRealmAnyCollection(NativeRealmAnyCollection.nativeCreateRealmAnyCollection(realmAnyPtrs, notNull));
    }

    private NativeRealmAnyCollection(long nativePtr) {
        this.nativePtr = nativePtr;
        NativeContext.dummyContext.addReference(this);
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return NativeRealmAnyCollection.nativeGetFinalizerPtr();
    }

    public int getSize() {
        return NativeRealmAnyCollection.nativeGetCollectionSize(this.nativePtr);
    }

    public NativeRealmAny getItem(int index) {
        return new NativeRealmAny(NativeRealmAnyCollection.nativeGetCollectionItem(this.nativePtr, index));
    }

    private static native long nativeCreateBooleanCollection(boolean[] var0, boolean[] var1);

    private static native long nativeCreateIntegerCollection(long[] var0, boolean[] var1);

    private static native long nativeCreateFloatCollection(float[] var0, boolean[] var1);

    private static native long nativeCreateDoubleCollection(double[] var0, boolean[] var1);

    private static native long nativeCreateStringCollection(String[] var0, boolean[] var1);

    private static native long nativeCreateBinaryCollection(byte[][] var0, boolean[] var1);

    private static native long nativeCreateDateCollection(long[] var0, boolean[] var1);

    private static native long nativeCreateObjectIdCollection(String[] var0, boolean[] var1);

    private static native long nativeCreateDecimal128Collection(long[] var0, long[] var1, boolean[] var2);

    private static native long nativeCreateUUIDCollection(String[] var0, boolean[] var1);

    private static native long nativeCreateObjectCollection(long[] var0, boolean[] var1);

    private static native long nativeCreateRealmAnyCollection(long[] var0, boolean[] var1);

    private static native int nativeGetCollectionSize(long var0);

    private static native long nativeGetCollectionItem(long var0, int var2);

    private static native long nativeGetFinalizerPtr();
}

