/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;

final class NativeObjectReference
extends PhantomReference<NativeObject> {
    private final long nativePtr;
    private final long nativeFinalizerPtr;
    private final NativeContext context;
    private NativeObjectReference prev;
    private NativeObjectReference next;
    private static ReferencePool referencePool = new ReferencePool();

    NativeObjectReference(NativeContext context, NativeObject referent, ReferenceQueue<? super NativeObject> referenceQueue) {
        super(referent, referenceQueue);
        this.nativePtr = referent.getNativePtr();
        this.nativeFinalizerPtr = referent.getNativeFinalizerPtr();
        this.context = context;
        referencePool.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        NativeContext nativeContext = this.context;
        synchronized (nativeContext) {
            NativeObjectReference.nativeCleanUp(this.nativeFinalizerPtr, this.nativePtr);
        }
        referencePool.remove(this);
    }

    static native void nativeCleanUp(long var0, long var2);

    private static class ReferencePool {
        NativeObjectReference head;

        private ReferencePool() {
        }

        synchronized void add(NativeObjectReference ref) {
            ref.prev = null;
            ref.next = this.head;
            if (this.head != null) {
                this.head.prev = ref;
            }
            this.head = ref;
        }

        synchronized void remove(NativeObjectReference ref) {
            NativeObjectReference next = ref.next;
            NativeObjectReference prev = ref.prev;
            ref.next = null;
            ref.prev = null;
            if (prev != null) {
                prev.next = next;
            } else {
                this.head = next;
            }
            if (next != null) {
                next.prev = prev;
            }
        }
    }
}

