/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.internal.OsSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class SetIterator<E>
implements Iterator<E> {
    protected final OsSet osSet;
    protected final BaseRealm baseRealm;
    private int pos = -1;

    SetIterator(OsSet osSet, BaseRealm baseRealm) {
        this.osSet = osSet;
        this.baseRealm = baseRealm;
    }

    @Override
    public boolean hasNext() {
        return (long)(this.pos + 1) < this.osSet.size();
    }

    @Override
    public E next() {
        ++this.pos;
        long size = this.osSet.size();
        if ((long)this.pos >= size) {
            throw new NoSuchElementException("Cannot access index " + this.pos + " when size is " + size + ". Remember to check hasNext() before using next().");
        }
        return this.getValueAtIndex(this.pos);
    }

    protected E getValueAtIndex(int position) {
        return (E)this.osSet.getValueAtIndex(position);
    }
}

