/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.ManagedListOperator;
import io.realm.internal.OsList;
import java.util.Locale;
import javax.annotation.Nullable;

final class BooleanListOperator
extends ManagedListOperator<Boolean> {
    BooleanListOperator(BaseRealm realm, OsList osList, Class<Boolean> clazz) {
        super(realm, osList, clazz);
    }

    @Override
    public boolean forRealmModel() {
        return false;
    }

    @Override
    @Nullable
    public Boolean get(int index) {
        return (Boolean)this.osList.getValue(index);
    }

    @Override
    protected void checkValidValue(@Nullable Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unacceptable value type. Acceptable: %1$s, actual: %2$s .", "java.lang.Boolean", value.getClass().getName()));
        }
    }

    @Override
    public void appendValue(Object value) {
        this.osList.addBoolean((Boolean)value);
    }

    @Override
    public void insertValue(int index, Object value) {
        this.osList.insertBoolean(index, (Boolean)value);
    }

    @Override
    protected void setValue(int index, Object value) {
        this.osList.setBoolean(index, (Boolean)value);
    }
}

