/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.android;

import android.os.Looper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.realm.internal.Capabilities;
import javax.annotation.Nullable;

public class AndroidCapabilities
implements Capabilities {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL", "MS_CANNOT_BE_FINAL"})
    public static boolean EMULATE_MAIN_THREAD = false;
    private final Looper looper = Looper.myLooper();
    private final boolean isIntentServiceThread = AndroidCapabilities.isIntentServiceThread();

    @Override
    public boolean canDeliverNotification() {
        return this.hasLooper() && !this.isIntentServiceThread;
    }

    @Override
    public void checkCanDeliverNotification(@Nullable String exceptionMessage) {
        if (!this.hasLooper()) {
            throw new IllegalStateException(exceptionMessage == null ? "" : exceptionMessage + " " + "Realm cannot be automatically updated on a thread without a looper.");
        }
        if (this.isIntentServiceThread) {
            throw new IllegalStateException(exceptionMessage == null ? "" : exceptionMessage + " " + "Realm cannot be automatically updated on an IntentService thread.");
        }
    }

    @Override
    public boolean isMainThread() {
        return this.looper != null && (EMULATE_MAIN_THREAD || this.looper == Looper.getMainLooper());
    }

    private boolean hasLooper() {
        return this.looper != null;
    }

    private static boolean isIntentServiceThread() {
        String threadName = Thread.currentThread().getName();
        return threadName != null && threadName.startsWith("IntentService[");
    }
}

