/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.OrderedCollectionChangeSet;
import io.realm.internal.OsCollectionChangeSet;
import javax.annotation.Nullable;

public class StatefulCollectionChangeSet
implements OrderedCollectionChangeSet {
    private final OrderedCollectionChangeSet changeset;
    private final Throwable error;
    private final OrderedCollectionChangeSet.State state;

    public StatefulCollectionChangeSet(OsCollectionChangeSet backingChangeset) {
        this.changeset = backingChangeset;
        boolean isInitial = backingChangeset.isFirstAsyncCallback();
        this.error = backingChangeset.getError();
        this.state = this.error != null ? OrderedCollectionChangeSet.State.ERROR : (isInitial ? OrderedCollectionChangeSet.State.INITIAL : OrderedCollectionChangeSet.State.UPDATE);
    }

    @Override
    public OrderedCollectionChangeSet.State getState() {
        return this.state;
    }

    @Override
    public int[] getDeletions() {
        return this.changeset.getDeletions();
    }

    @Override
    public int[] getInsertions() {
        return this.changeset.getInsertions();
    }

    @Override
    public int[] getChanges() {
        return this.changeset.getChanges();
    }

    @Override
    public OrderedCollectionChangeSet.Range[] getDeletionRanges() {
        return this.changeset.getDeletionRanges();
    }

    @Override
    public OrderedCollectionChangeSet.Range[] getInsertionRanges() {
        return this.changeset.getInsertionRanges();
    }

    @Override
    public OrderedCollectionChangeSet.Range[] getChangeRanges() {
        return this.changeset.getChangeRanges();
    }

    @Override
    @Nullable
    public Throwable getError() {
        return this.error;
    }
}

