/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.annotation.SuppressLint;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.realm.BaseRealm;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.OrderedRealmCollectionImpl;
import io.realm.ProxyState;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmFieldType;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmObjectSchema;
import io.realm.RealmQuery;
import io.realm.Sort;
import io.realm.internal.OsResults;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import io.realm.internal.Util;
import io.realm.internal.android.JsonUtils;
import io.realm.log.RealmLog;
import io.realm.rx.CollectionChange;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class RealmResults<E>
extends OrderedRealmCollectionImpl<E> {
    @SuppressLint(value={"unused"})
    static <T extends RealmModel> RealmResults<T> createBacklinkResults(BaseRealm realm, Row row, Class<T> srcTableType, String srcFieldName) {
        UncheckedRow uncheckedRow = (UncheckedRow)row;
        Table srcTable = realm.getSchema().getTable(srcTableType);
        return new RealmResults<T>(realm, OsResults.createForBacklinks(realm.sharedRealm, uncheckedRow, srcTable, srcFieldName), srcTableType);
    }

    static RealmResults<DynamicRealmObject> createDynamicBacklinkResults(DynamicRealm realm, UncheckedRow row, Table srcTable, String srcFieldName) {
        String srcClassName = Table.getClassNameForTable(srcTable.getName());
        return new RealmResults<DynamicRealmObject>((BaseRealm)realm, OsResults.createForBacklinks(realm.sharedRealm, row, srcTable, srcFieldName), srcClassName);
    }

    RealmResults(BaseRealm realm, OsResults osResults, Class<E> clazz) {
        this(realm, osResults, clazz, false);
    }

    RealmResults(BaseRealm realm, OsResults osResults, Class<E> clazz, boolean forPrimitives) {
        super(realm, osResults, clazz, RealmResults.getCollectionOperator(forPrimitives, realm, osResults, clazz, null));
    }

    RealmResults(BaseRealm realm, OsResults osResults, String className) {
        this(realm, osResults, className, false);
    }

    RealmResults(BaseRealm realm, OsResults osResults, String className, boolean forPrimitives) {
        super(realm, osResults, className, RealmResults.getCollectionOperator(forPrimitives, realm, osResults, null, className));
    }

    @Override
    public RealmQuery<E> where() {
        this.baseRealm.checkIfValid();
        return RealmQuery.createQueryFromResult(this);
    }

    @Override
    public RealmResults<E> sort(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        return this.sort(new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    @Override
    public boolean isLoaded() {
        this.baseRealm.checkIfValid();
        return this.osResults.isLoaded();
    }

    @Override
    public boolean load() {
        this.baseRealm.checkIfValid();
        this.osResults.load();
        return true;
    }

    public void setValue(String fieldName, @Nullable Object value) {
        Class<?> valueClass;
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        boolean isString = value instanceof String;
        String strValue = isString ? (String)value : null;
        String className = this.osResults.getTable().getClassName();
        RealmObjectSchema schema = this.getRealm().getSchema().get(className);
        if (!schema.hasField(fieldName)) {
            throw new IllegalArgumentException(String.format("Field '%s' could not be found in class '%s'", fieldName, className));
        }
        if (value == null) {
            this.osResults.setNull(fieldName);
            return;
        }
        RealmFieldType type = schema.getFieldType(fieldName);
        if (isString && type != RealmFieldType.STRING) {
            switch (type) {
                case BOOLEAN: {
                    value = Boolean.parseBoolean(strValue);
                    break;
                }
                case INTEGER: {
                    value = Long.parseLong(strValue);
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(Float.parseFloat(strValue));
                    break;
                }
                case DOUBLE: {
                    value = Double.parseDouble(strValue);
                    break;
                }
                case DATE: {
                    value = JsonUtils.stringToDate(strValue);
                    break;
                }
                case DECIMAL128: {
                    value = Decimal128.parse((String)strValue);
                    break;
                }
                case OBJECT_ID: {
                    value = new ObjectId(strValue);
                    break;
                }
                case UUID: {
                    value = UUID.fromString(strValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.US, "Field %s is not a String field, and the provide value could not be automatically converted: %s. Use a typedsetter instead", fieldName, value));
                }
            }
        }
        if ((valueClass = value.getClass()) == Boolean.class) {
            this.setBoolean(fieldName, (Boolean)value);
        } else if (valueClass == Short.class) {
            this.setShort(fieldName, (Short)value);
        } else if (valueClass == Integer.class) {
            this.setInt(fieldName, (Integer)value);
        } else if (valueClass == Long.class) {
            this.setLong(fieldName, (Long)value);
        } else if (valueClass == Byte.class) {
            this.setByte(fieldName, (Byte)value);
        } else if (valueClass == Float.class) {
            this.setFloat(fieldName, ((Float)value).floatValue());
        } else if (valueClass == Double.class) {
            this.setDouble(fieldName, (Double)value);
        } else if (valueClass == String.class) {
            this.setString(fieldName, (String)value);
        } else if (value instanceof Date) {
            this.setDate(fieldName, (Date)value);
        } else if (value instanceof Decimal128) {
            this.setDecimal128(fieldName, (Decimal128)value);
        } else if (value instanceof ObjectId) {
            this.setObjectId(fieldName, (ObjectId)value);
        } else if (value instanceof UUID) {
            this.setUUID(fieldName, (UUID)value);
        } else if (value instanceof byte[]) {
            this.setBlob(fieldName, (byte[])value);
        } else if (value instanceof RealmModel) {
            this.setObject(fieldName, (RealmModel)value);
        } else if (valueClass == RealmList.class) {
            RealmList list = (RealmList)value;
            this.setList(fieldName, list);
        } else {
            throw new IllegalArgumentException("Value is of a type not supported: " + value.getClass());
        }
    }

    public void setNull(String fieldName) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        this.osResults.setNull(fieldName);
    }

    public void setBoolean(String fieldName, boolean value) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.BOOLEAN);
        this.osResults.setBoolean(fieldName, value);
    }

    public void setByte(String fieldName, byte value) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.INTEGER);
        this.osResults.setInt(fieldName, value);
    }

    public void setShort(String fieldName, short value) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.INTEGER);
        this.osResults.setInt(fieldName, value);
    }

    public void setInt(String fieldName, int value) {
        this.checkNonEmptyFieldName(fieldName);
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.INTEGER);
        this.baseRealm.checkIfValidAndInTransaction();
        this.osResults.setInt(fieldName, value);
    }

    public void setLong(String fieldName, long value) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.INTEGER);
        this.osResults.setInt(fieldName, value);
    }

    public void setFloat(String fieldName, float value) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.FLOAT);
        this.osResults.setFloat(fieldName, value);
    }

    public void setDouble(String fieldName, double value) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.DOUBLE);
        this.osResults.setDouble(fieldName, value);
    }

    public void setString(String fieldName, @Nullable String value) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.STRING);
        this.osResults.setString(fieldName, value);
    }

    public void setBlob(String fieldName, @Nullable byte[] value) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.BINARY);
        this.osResults.setBlob(fieldName, value);
    }

    public void setDate(String fieldName, @Nullable Date value) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.DATE);
        this.osResults.setDate(fieldName, value);
    }

    public void setObject(String fieldName, @Nullable RealmModel value) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.OBJECT);
        Row row = this.checkRealmObjectConstraints(fieldName, value);
        this.osResults.setObject(fieldName, row);
    }

    public void setDecimal128(String fieldName, @Nullable Decimal128 value) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.DECIMAL128);
        this.osResults.setDecimal128(fieldName, value);
    }

    public void setObjectId(String fieldName, @Nullable ObjectId value) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.OBJECT_ID);
        this.osResults.setObjectId(fieldName, value);
    }

    public void setUUID(String fieldName, @Nullable UUID value) {
        this.checkNonEmptyFieldName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.checkType(fieldName, RealmFieldType.UUID);
        this.osResults.setUUID(fieldName, value);
    }

    private Row checkRealmObjectConstraints(String fieldName, @Nullable RealmModel value) {
        if (value != null) {
            Table inputTable;
            long columnKey;
            if (!RealmObject.isManaged(value) || !RealmObject.isValid(value)) {
                throw new IllegalArgumentException("'value' is not a valid, managed Realm object.");
            }
            ProxyState proxyState = ((RealmObjectProxy)value).realmGet$proxyState();
            if (!proxyState.getRealm$realm().getPath().equals(this.baseRealm.getPath())) {
                throw new IllegalArgumentException("'value' does not belong to the same Realm as the RealmResults.");
            }
            Table currentTable = this.osResults.getTable();
            Table expectedTable = currentTable.getLinkTarget(columnKey = currentTable.getColumnKey(fieldName));
            if (!expectedTable.hasSameSchema(inputTable = proxyState.getRow$realm().getTable())) {
                throw new IllegalArgumentException(String.format(Locale.US, "Type of object is wrong. Was '%s', expected '%s'", inputTable.getClassName(), expectedTable.getClassName()));
            }
            return proxyState.getRow$realm();
        }
        return null;
    }

    public <T> void setList(String fieldName, RealmList<T> list) {
        this.checkNonEmptyFieldName(fieldName);
        fieldName = this.mapFieldNameToInternalName(fieldName);
        this.baseRealm.checkIfValidAndInTransaction();
        if (list == null) {
            throw new IllegalArgumentException("Non-null 'list' required");
        }
        RealmFieldType columnType = this.baseRealm.getSchema().getSchemaForClass(this.osResults.getTable().getClassName()).getFieldType(fieldName);
        switch (columnType) {
            case LIST: {
                this.checkTypeOfListElements(list, RealmModel.class);
                this.checkRealmObjectConstraints(fieldName, list.first(null));
                this.osResults.setModelList(fieldName, list);
                break;
            }
            case INTEGER_LIST: {
                Class<?> listType = this.getListType(list);
                if (listType.equals(Integer.class)) {
                    this.osResults.setIntegerList(fieldName, list);
                    break;
                }
                if (listType.equals(Long.class)) {
                    this.osResults.setLongList(fieldName, list);
                    break;
                }
                if (listType.equals(Short.class)) {
                    this.osResults.setShortList(fieldName, list);
                    break;
                }
                if (listType.equals(Byte.class)) {
                    this.osResults.setByteList(fieldName, list);
                    break;
                }
                throw new IllegalArgumentException(String.format("List contained the wrong type of elements. Elements that can be mapped to Integers was expected, but the actual type is '%s'", listType));
            }
            case BOOLEAN_LIST: {
                this.checkTypeOfListElements(list, Boolean.class);
                this.osResults.setBooleanList(fieldName, list);
                break;
            }
            case STRING_LIST: {
                this.checkTypeOfListElements(list, String.class);
                this.osResults.setStringList(fieldName, list);
                break;
            }
            case BINARY_LIST: {
                this.checkTypeOfListElements(list, byte[].class);
                this.osResults.setByteArrayList(fieldName, list);
                break;
            }
            case DATE_LIST: {
                this.checkTypeOfListElements(list, Date.class);
                this.osResults.setDateList(fieldName, list);
                break;
            }
            case DECIMAL128_LIST: {
                this.checkTypeOfListElements(list, Decimal128.class);
                this.osResults.setDecimal128List(fieldName, list);
                break;
            }
            case OBJECT_ID_LIST: {
                this.checkTypeOfListElements(list, ObjectId.class);
                this.osResults.setObjectIdList(fieldName, list);
                break;
            }
            case UUID_LIST: {
                this.checkTypeOfListElements(list, UUID.class);
                this.osResults.setUUIDList(fieldName, list);
                break;
            }
            case FLOAT_LIST: {
                this.checkTypeOfListElements(list, Float.class);
                this.osResults.setFloatList(fieldName, list);
                break;
            }
            case DOUBLE_LIST: {
                this.checkTypeOfListElements(list, Double.class);
                this.osResults.setDoubleList(fieldName, list);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Field '%s' is not a list but a %s", new Object[]{fieldName, columnType}));
            }
        }
    }

    @Override
    public boolean isFrozen() {
        return this.baseRealm != null && this.baseRealm.isFrozen();
    }

    @Override
    public RealmResults<E> freeze() {
        if (!this.isValid()) {
            throw new IllegalStateException("Only valid, managed RealmResults can be frozen.");
        }
        BaseRealm frozenRealm = this.baseRealm.freeze();
        OsResults frozenResults = this.osResults.freeze(frozenRealm.sharedRealm);
        if (this.className != null) {
            return new RealmResults<E>(frozenRealm, frozenResults, this.className);
        }
        return new RealmResults<E>(frozenRealm, frozenResults, this.classSpec);
    }

    private Class<?> getListType(RealmList list) {
        if (!list.isEmpty()) {
            return list.first().getClass();
        }
        return Long.class;
    }

    private <T> void checkTypeOfListElements(RealmList<T> list, Class<?> clazz) {
        T element;
        Class<?> elementType;
        if (!list.isEmpty() && !clazz.isAssignableFrom(elementType = (element = list.first()).getClass())) {
            throw new IllegalArgumentException(String.format("List contained the wrong type of elements. Elements of type '%s' was expected, but the actual type is '%s'", clazz, elementType));
        }
    }

    public void addChangeListener(RealmChangeListener<RealmResults<E>> listener) {
        this.checkForAddListener(listener);
        this.osResults.addListener(this, listener);
    }

    public void addChangeListener(OrderedRealmCollectionChangeListener<RealmResults<E>> listener) {
        this.checkForAddListener(listener);
        this.osResults.addListener(this, listener);
    }

    private void checkForAddListener(@Nullable Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        this.baseRealm.checkIfValid();
        this.baseRealm.sharedRealm.capabilities.checkCanDeliverNotification("Listeners cannot be used on current thread.");
    }

    private void checkForRemoveListener(@Nullable Object listener, boolean checkListener) {
        if (checkListener && listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        if (this.baseRealm.isClosed()) {
            RealmLog.warn("Calling removeChangeListener on a closed Realm %s, make sure to close all listeners before closing the Realm.", this.baseRealm.configuration.getPath());
        }
    }

    public void removeAllChangeListeners() {
        this.checkForRemoveListener(null, false);
        this.osResults.removeAllListeners();
    }

    public void removeChangeListener(RealmChangeListener<RealmResults<E>> listener) {
        this.checkForRemoveListener(listener, true);
        this.osResults.removeListener(this, listener);
    }

    public void removeChangeListener(OrderedRealmCollectionChangeListener<RealmResults<E>> listener) {
        this.checkForRemoveListener(listener, true);
        this.osResults.removeListener(this, listener);
    }

    public Flowable<RealmResults<E>> asFlowable() {
        if (this.baseRealm instanceof Realm) {
            return this.baseRealm.configuration.getRxFactory().from((Realm)this.baseRealm, this);
        }
        if (this.baseRealm instanceof DynamicRealm) {
            DynamicRealm dynamicRealm = (DynamicRealm)this.baseRealm;
            RealmResults dynamicResults = this;
            Flowable results = this.baseRealm.configuration.getRxFactory().from(dynamicRealm, dynamicResults);
            return results;
        }
        throw new UnsupportedOperationException(this.baseRealm.getClass() + " does not support RxJava2.");
    }

    public Observable<CollectionChange<RealmResults<E>>> asChangesetObservable() {
        if (this.baseRealm instanceof Realm) {
            return this.baseRealm.configuration.getRxFactory().changesetsFrom((Realm)this.baseRealm, this);
        }
        if (this.baseRealm instanceof DynamicRealm) {
            DynamicRealm dynamicRealm = (DynamicRealm)this.baseRealm;
            RealmResults dynamicResults = this;
            return this.baseRealm.configuration.getRxFactory().changesetsFrom(dynamicRealm, dynamicResults);
        }
        throw new UnsupportedOperationException(this.baseRealm.getClass() + " does not support RxJava2.");
    }

    public String asJSON() {
        return this.osResults.toJSON(-1);
    }

    private void checkNonEmptyFieldName(String fieldName) {
        if (Util.isEmptyString(fieldName)) {
            throw new IllegalArgumentException("Non-empty 'fieldname' required.");
        }
    }

    private void checkNotNull(@Nullable Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Non-null 'value' required. Use 'setNull(fieldName)' instead.");
        }
    }

    private void checkType(String fieldName, RealmFieldType expectedFieldType) {
        String className = this.osResults.getTable().getClassName();
        RealmFieldType fieldType = this.baseRealm.getSchema().get(className).getFieldType(fieldName);
        if (fieldType != expectedFieldType) {
            throw new IllegalArgumentException(String.format("The field '%s.%s' is not of the expected type. Actual: %s, Expected: %s", new Object[]{className, fieldName, fieldType, expectedFieldType}));
        }
    }

    private String mapFieldNameToInternalName(String fieldName) {
        if (this.baseRealm instanceof Realm) {
            String className = this.osResults.getTable().getClassName();
            String mappedFieldName = this.baseRealm.getSchema().getColumnInfo(className).getInternalFieldName(fieldName);
            if (mappedFieldName == null) {
                throw new IllegalArgumentException(String.format("Field '%s' does not exists.", fieldName));
            }
            fieldName = mappedFieldName;
        }
        return fieldName;
    }
}

