/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.FieldAttribute;
import io.realm.RealmAny;
import io.realm.RealmDictionary;
import io.realm.RealmFieldType;
import io.realm.RealmList;
import io.realm.RealmObject;
import io.realm.RealmSchema;
import io.realm.RealmSet;
import io.realm.internal.ColumnInfo;
import io.realm.internal.OsObjectStore;
import io.realm.internal.Table;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public abstract class RealmObjectSchema {
    static final Map<Class<?>, FieldMetaData> SUPPORTED_LIST_SIMPLE_FIELDS;
    static final Map<Class<?>, FieldMetaData> SUPPORTED_DICTIONARY_SIMPLE_FIELDS;
    static final Map<Class<?>, FieldMetaData> SUPPORTED_SET_SIMPLE_FIELDS;
    static final Map<Class<?>, FieldMetaData> SUPPORTED_LINKED_FIELDS;
    final RealmSchema schema;
    final BaseRealm realm;
    final Table table;
    final ColumnInfo columnInfo;

    RealmObjectSchema(BaseRealm realm, RealmSchema schema, Table table, ColumnInfo columnInfo) {
        this.schema = schema;
        this.realm = realm;
        this.table = table;
        this.columnInfo = columnInfo;
    }

    public String getClassName() {
        return this.table.getClassName();
    }

    public abstract RealmObjectSchema setClassName(String var1);

    public abstract RealmObjectSchema addField(String var1, Class<?> var2, FieldAttribute ... var3);

    public abstract RealmObjectSchema addRealmObjectField(String var1, RealmObjectSchema var2);

    public abstract RealmObjectSchema addRealmListField(String var1, RealmObjectSchema var2);

    public abstract RealmObjectSchema addRealmListField(String var1, Class<?> var2);

    public abstract RealmObjectSchema addRealmDictionaryField(String var1, RealmObjectSchema var2);

    public abstract RealmObjectSchema addRealmDictionaryField(String var1, Class<?> var2);

    public abstract RealmObjectSchema addRealmSetField(String var1, RealmObjectSchema var2);

    public abstract RealmObjectSchema addRealmSetField(String var1, Class<?> var2);

    public abstract RealmObjectSchema removeField(String var1);

    public abstract RealmObjectSchema renameField(String var1, String var2);

    public boolean hasField(String fieldName) {
        return this.table.getColumnKey(fieldName) != -1L;
    }

    public abstract RealmObjectSchema addIndex(String var1);

    public boolean hasIndex(String fieldName) {
        RealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldExists(fieldName);
        return this.table.hasSearchIndex(this.table.getColumnKey(fieldName));
    }

    public abstract RealmObjectSchema removeIndex(String var1);

    public abstract RealmObjectSchema addPrimaryKey(String var1);

    public abstract RealmObjectSchema removePrimaryKey();

    public abstract RealmObjectSchema setRequired(String var1, boolean var2);

    public abstract RealmObjectSchema setNullable(String var1, boolean var2);

    public boolean isRequired(String fieldName) {
        long columnIndex = this.getColumnKey(fieldName);
        return !this.table.isColumnNullable(columnIndex);
    }

    public boolean isNullable(String fieldName) {
        long columnIndex = this.getColumnKey(fieldName);
        return this.table.isColumnNullable(columnIndex);
    }

    public boolean isPrimaryKey(String fieldName) {
        this.checkFieldExists(fieldName);
        return fieldName.equals(OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName()));
    }

    public boolean hasPrimaryKey() {
        return OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName()) != null;
    }

    public String getPrimaryKey() {
        String pkField = OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName());
        if (pkField == null) {
            throw new IllegalStateException(this.getClassName() + " doesn't have a primary key.");
        }
        return pkField;
    }

    public Set<String> getFieldNames() {
        int columnCount = (int)this.table.getColumnCount();
        LinkedHashSet<String> columnNames = new LinkedHashSet<String>(columnCount);
        for (String column : this.table.getColumnNames()) {
            columnNames.add(column);
        }
        return columnNames;
    }

    public abstract RealmObjectSchema transform(Function var1);

    public RealmFieldType getFieldType(String fieldName) {
        long columnKey = this.getColumnKey(fieldName);
        return this.table.getColumnType(columnKey);
    }

    public boolean isEmbedded() {
        return this.table.isEmbedded();
    }

    public void setEmbedded(boolean embedded) {
        if (this.hasPrimaryKey()) {
            throw new IllegalStateException("Embedded classes cannot have primary keys. This class has a primary key defined so cannot be marked as embedded: " + this.getClassName());
        }
        boolean setEmbedded = this.table.setEmbedded(embedded);
        if (!setEmbedded && embedded) {
            throw new IllegalStateException("The class could not be marked as embedded as some objects of this type break some of the Embedded Objects invariants. In order to convert all objects to be embedded, they must have one and exactly one parent objectpointing to them.");
        }
    }

    abstract String getPropertyClassName(String var1);

    boolean isPropertyAcceptableForEmbeddedObject(RealmFieldType property) {
        return property == RealmFieldType.OBJECT || property == RealmFieldType.LIST;
    }

    RealmObjectSchema add(String name, RealmFieldType type, boolean primary, boolean indexed, boolean required) {
        long columnIndex = this.table.addColumn(type, name, !required);
        if (indexed) {
            this.table.addSearchIndex(columnIndex);
        }
        if (primary) {
            OsObjectStore.setPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName(), name);
        }
        return this;
    }

    RealmObjectSchema add(String name, RealmFieldType type, RealmObjectSchema linkedTo) {
        this.table.addColumnLink(type, name, this.realm.getSharedRealm().getTable(Table.getTableNameForClass(linkedTo.getClassName())));
        return this;
    }

    long getAndCheckFieldColumnKey(String fieldName) {
        long columnKey = this.columnInfo.getColumnKey(fieldName);
        if (columnKey < 0L) {
            throw new IllegalArgumentException("Field does not exist: " + fieldName);
        }
        return columnKey;
    }

    Table getTable() {
        return this.table;
    }

    long getFieldColumnKey(String fieldName) {
        return this.columnInfo.getColumnKey(fieldName);
    }

    static void checkLegalName(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException("Field name can not be null or empty");
        }
        if (fieldName.contains(".")) {
            throw new IllegalArgumentException("Field name can not contain '.'");
        }
        if (fieldName.length() > 63) {
            throw new IllegalArgumentException("Field name is currently limited to max 63 characters.");
        }
    }

    void checkFieldExists(String fieldName) {
        if (this.table.getColumnKey(fieldName) == -1L) {
            throw new IllegalArgumentException("Field name doesn't exist on object '" + this.getClassName() + "': " + fieldName);
        }
    }

    long getColumnKey(String fieldName) {
        long columnKey = this.table.getColumnKey(fieldName);
        if (columnKey == -1L) {
            throw new IllegalArgumentException(String.format(Locale.US, "Field name '%s' does not exist on schema for '%s'", fieldName, this.getClassName()));
        }
        return columnKey;
    }

    static {
        HashMap<Class<RealmAny>, FieldMetaData> listMap = new HashMap<Class<RealmAny>, FieldMetaData>();
        listMap.put(String.class, new FieldMetaData(RealmFieldType.STRING, RealmFieldType.STRING_LIST, true));
        listMap.put(Short.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, false));
        listMap.put(Short.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, true));
        listMap.put(Integer.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, false));
        listMap.put(Integer.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, true));
        listMap.put(Long.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, false));
        listMap.put(Long.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, true));
        listMap.put(Float.TYPE, new FieldMetaData(RealmFieldType.FLOAT, RealmFieldType.FLOAT_LIST, false));
        listMap.put(Float.class, new FieldMetaData(RealmFieldType.FLOAT, RealmFieldType.FLOAT_LIST, true));
        listMap.put(Double.TYPE, new FieldMetaData(RealmFieldType.DOUBLE, RealmFieldType.DOUBLE_LIST, false));
        listMap.put(Double.class, new FieldMetaData(RealmFieldType.DOUBLE, RealmFieldType.DOUBLE_LIST, true));
        listMap.put(Boolean.TYPE, new FieldMetaData(RealmFieldType.BOOLEAN, RealmFieldType.BOOLEAN_LIST, false));
        listMap.put(Boolean.class, new FieldMetaData(RealmFieldType.BOOLEAN, RealmFieldType.BOOLEAN_LIST, true));
        listMap.put(Byte.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, false));
        listMap.put(Byte.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, true));
        listMap.put(byte[].class, new FieldMetaData(RealmFieldType.BINARY, RealmFieldType.BINARY_LIST, true));
        listMap.put(Date.class, new FieldMetaData(RealmFieldType.DATE, RealmFieldType.DATE_LIST, true));
        listMap.put(ObjectId.class, new FieldMetaData(RealmFieldType.OBJECT_ID, RealmFieldType.OBJECT_ID_LIST, true));
        listMap.put(Decimal128.class, new FieldMetaData(RealmFieldType.DECIMAL128, RealmFieldType.DECIMAL128_LIST, true));
        listMap.put(UUID.class, new FieldMetaData(RealmFieldType.UUID, RealmFieldType.UUID_LIST, true));
        listMap.put(RealmAny.class, new FieldMetaData(RealmFieldType.MIXED, RealmFieldType.MIXED_LIST, true));
        SUPPORTED_LIST_SIMPLE_FIELDS = Collections.unmodifiableMap(listMap);
        HashMap<Class<RealmAny>, FieldMetaData> dictionaryMap = new HashMap<Class<RealmAny>, FieldMetaData>();
        dictionaryMap.put(String.class, new FieldMetaData(RealmFieldType.STRING, RealmFieldType.STRING_TO_STRING_MAP, true));
        dictionaryMap.put(Short.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.STRING_TO_INTEGER_MAP, false));
        dictionaryMap.put(Short.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.STRING_TO_INTEGER_MAP, true));
        dictionaryMap.put(Integer.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.STRING_TO_INTEGER_MAP, false));
        dictionaryMap.put(Integer.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.STRING_TO_INTEGER_MAP, true));
        dictionaryMap.put(Long.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.STRING_TO_INTEGER_MAP, false));
        dictionaryMap.put(Long.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.STRING_TO_INTEGER_MAP, true));
        dictionaryMap.put(Float.TYPE, new FieldMetaData(RealmFieldType.FLOAT, RealmFieldType.STRING_TO_FLOAT_MAP, false));
        dictionaryMap.put(Float.class, new FieldMetaData(RealmFieldType.FLOAT, RealmFieldType.STRING_TO_FLOAT_MAP, true));
        dictionaryMap.put(Double.TYPE, new FieldMetaData(RealmFieldType.DOUBLE, RealmFieldType.STRING_TO_DOUBLE_MAP, false));
        dictionaryMap.put(Double.class, new FieldMetaData(RealmFieldType.DOUBLE, RealmFieldType.STRING_TO_DOUBLE_MAP, true));
        dictionaryMap.put(Boolean.TYPE, new FieldMetaData(RealmFieldType.BOOLEAN, RealmFieldType.STRING_TO_BOOLEAN_MAP, false));
        dictionaryMap.put(Boolean.class, new FieldMetaData(RealmFieldType.BOOLEAN, RealmFieldType.STRING_TO_BOOLEAN_MAP, true));
        dictionaryMap.put(Byte.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.STRING_TO_INTEGER_MAP, false));
        dictionaryMap.put(Byte.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.STRING_TO_INTEGER_MAP, true));
        dictionaryMap.put(byte[].class, new FieldMetaData(RealmFieldType.BINARY, RealmFieldType.STRING_TO_BINARY_MAP, true));
        dictionaryMap.put(Date.class, new FieldMetaData(RealmFieldType.DATE, RealmFieldType.STRING_TO_DATE_MAP, true));
        dictionaryMap.put(ObjectId.class, new FieldMetaData(RealmFieldType.OBJECT_ID, RealmFieldType.STRING_TO_OBJECT_ID_MAP, true));
        dictionaryMap.put(Decimal128.class, new FieldMetaData(RealmFieldType.DECIMAL128, RealmFieldType.STRING_TO_DECIMAL128_MAP, true));
        dictionaryMap.put(UUID.class, new FieldMetaData(RealmFieldType.UUID, RealmFieldType.STRING_TO_UUID_MAP, true));
        dictionaryMap.put(RealmAny.class, new FieldMetaData(RealmFieldType.MIXED, RealmFieldType.STRING_TO_MIXED_MAP, true));
        SUPPORTED_DICTIONARY_SIMPLE_FIELDS = Collections.unmodifiableMap(dictionaryMap);
        HashMap<Class<RealmAny>, FieldMetaData> setMap = new HashMap<Class<RealmAny>, FieldMetaData>();
        setMap.put(String.class, new FieldMetaData(RealmFieldType.STRING, RealmFieldType.STRING_SET, true));
        setMap.put(Short.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_SET, false));
        setMap.put(Short.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_SET, true));
        setMap.put(Integer.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_SET, false));
        setMap.put(Integer.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_SET, true));
        setMap.put(Long.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_SET, false));
        setMap.put(Long.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_SET, true));
        setMap.put(Float.TYPE, new FieldMetaData(RealmFieldType.FLOAT, RealmFieldType.FLOAT_SET, false));
        setMap.put(Float.class, new FieldMetaData(RealmFieldType.FLOAT, RealmFieldType.FLOAT_SET, true));
        setMap.put(Double.TYPE, new FieldMetaData(RealmFieldType.DOUBLE, RealmFieldType.DOUBLE_SET, false));
        setMap.put(Double.class, new FieldMetaData(RealmFieldType.DOUBLE, RealmFieldType.DOUBLE_SET, true));
        setMap.put(Boolean.TYPE, new FieldMetaData(RealmFieldType.BOOLEAN, RealmFieldType.BOOLEAN_SET, false));
        setMap.put(Boolean.class, new FieldMetaData(RealmFieldType.BOOLEAN, RealmFieldType.BOOLEAN_SET, true));
        setMap.put(Byte.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_SET, false));
        setMap.put(Byte.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_SET, true));
        setMap.put(byte[].class, new FieldMetaData(RealmFieldType.BINARY, RealmFieldType.BINARY_SET, true));
        setMap.put(Date.class, new FieldMetaData(RealmFieldType.DATE, RealmFieldType.DATE_SET, true));
        setMap.put(ObjectId.class, new FieldMetaData(RealmFieldType.OBJECT_ID, RealmFieldType.OBJECT_ID_SET, true));
        setMap.put(Decimal128.class, new FieldMetaData(RealmFieldType.DECIMAL128, RealmFieldType.DECIMAL128_SET, true));
        setMap.put(UUID.class, new FieldMetaData(RealmFieldType.UUID, RealmFieldType.UUID_SET, true));
        setMap.put(RealmAny.class, new FieldMetaData(RealmFieldType.MIXED, RealmFieldType.MIXED_SET, true));
        SUPPORTED_SET_SIMPLE_FIELDS = Collections.unmodifiableMap(setMap);
        HashMap<Class, FieldMetaData> m = new HashMap<Class, FieldMetaData>();
        m.put(RealmObject.class, new FieldMetaData(RealmFieldType.OBJECT, null, false));
        m.put(RealmList.class, new FieldMetaData(RealmFieldType.LIST, null, false));
        m.put(RealmDictionary.class, new FieldMetaData(RealmFieldType.STRING_TO_LINK_MAP, null, false));
        m.put(RealmSet.class, new FieldMetaData(RealmFieldType.LINK_SET, null, false));
        SUPPORTED_LINKED_FIELDS = Collections.unmodifiableMap(m);
    }

    static final class FieldMetaData {
        final RealmFieldType fieldType;
        final RealmFieldType collectionType;
        final boolean defaultNullable;

        FieldMetaData(RealmFieldType fieldType, @Nullable RealmFieldType collectionType, boolean defaultNullable) {
            this.fieldType = fieldType;
            this.collectionType = collectionType;
            this.defaultNullable = defaultNullable;
        }
    }

    static final class DynamicColumnIndices
    extends ColumnInfo {
        private final Table table;

        DynamicColumnIndices(Table table) {
            super(null, false);
            this.table = table;
        }

        @Override
        public long getColumnKey(String columnName) {
            return this.table.getColumnKey(columnName);
        }

        @Override
        public ColumnInfo.ColumnDetails getColumnDetails(String columnName) {
            throw new UnsupportedOperationException("DynamicColumnIndices do not support 'getColumnDetails'");
        }

        @Override
        public void copyFrom(ColumnInfo src) {
            throw new UnsupportedOperationException("DynamicColumnIndices cannot be copied");
        }

        @Override
        protected ColumnInfo copy(boolean immutable) {
            throw new UnsupportedOperationException("DynamicColumnIndices cannot be copied");
        }

        @Override
        protected void copy(ColumnInfo src, ColumnInfo dst) {
            throw new UnsupportedOperationException("DynamicColumnIndices cannot copy");
        }
    }

    public static interface Function {
        public void apply(DynamicRealmObject var1);
    }
}

