/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.ManagedListOperator;
import io.realm.internal.OsList;
import java.util.Locale;
import javax.annotation.Nullable;
import org.bson.types.ObjectId;

final class ObjectIdListOperator
extends ManagedListOperator<ObjectId> {
    ObjectIdListOperator(BaseRealm realm, OsList osList, Class<ObjectId> clazz) {
        super(realm, osList, clazz);
    }

    @Override
    public boolean forRealmModel() {
        return false;
    }

    @Override
    @Nullable
    public ObjectId get(int index) {
        return (ObjectId)this.osList.getValue(index);
    }

    @Override
    protected void checkValidValue(@Nullable Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof ObjectId)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unacceptable value type. Acceptable: %1$s, actual: %2$s .", "org.bson.types.ObjectId", value.getClass().getName()));
        }
    }

    @Override
    public void appendValue(Object value) {
        this.osList.addObjectId((ObjectId)value);
    }

    @Override
    public void insertValue(int index, Object value) {
        this.osList.insertObjectId(index, (ObjectId)value);
    }

    @Override
    protected void setValue(int index, Object value) {
        this.osList.setObjectId(index, (ObjectId)value);
    }
}

