/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.FieldAttribute;
import io.realm.MutableRealmObjectSchema;
import io.realm.RealmFieldType;
import io.realm.RealmObjectSchema;
import io.realm.RealmSchema;
import io.realm.internal.OsObjectStore;
import io.realm.internal.Table;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

class MutableRealmSchema
extends RealmSchema {
    MutableRealmSchema(BaseRealm realm) {
        super(realm, null);
    }

    @Override
    public RealmObjectSchema get(String className) {
        this.checkNotEmpty(className, "Null or empty class names are not allowed");
        String internalClassName = Table.getTableNameForClass(className);
        if (!this.realm.getSharedRealm().hasTable(internalClassName)) {
            return null;
        }
        Table table = this.realm.getSharedRealm().getTable(internalClassName);
        return new MutableRealmObjectSchema(this.realm, this, table);
    }

    @Override
    public Set<RealmObjectSchema> getAll() {
        String[] names = this.realm.getSharedRealm().getTablesNames();
        int tableCount = names.length;
        LinkedHashSet<RealmObjectSchema> schemas = new LinkedHashSet<RealmObjectSchema>(tableCount);
        for (int i = 0; i < tableCount; ++i) {
            RealmObjectSchema objectSchema = this.get(Table.getClassNameForTable(names[i]));
            if (objectSchema == null) continue;
            schemas.add(objectSchema);
        }
        return schemas;
    }

    @Override
    public RealmObjectSchema create(String className) {
        this.checkNotEmpty(className, "Null or empty class names are not allowed");
        String internalTableName = Table.getTableNameForClass(className);
        if (className.length() > Table.CLASS_NAME_MAX_LENGTH) {
            throw new IllegalArgumentException(String.format(Locale.US, "Class name is too long. Limit is %1$d characters: %2$s", Table.CLASS_NAME_MAX_LENGTH, className.length()));
        }
        return new MutableRealmObjectSchema(this.realm, this, this.realm.getSharedRealm().createTable(internalTableName));
    }

    @Override
    public RealmObjectSchema createWithPrimaryKeyField(String className, String primaryKeyFieldName, Class<?> fieldType, FieldAttribute ... attributes) {
        this.checkNotEmpty(className, "Null or empty class names are not allowed");
        RealmObjectSchema.checkLegalName(primaryKeyFieldName);
        String internalTableName = this.checkAndGetTableNameFromClassName(className);
        RealmObjectSchema.FieldMetaData metadata = RealmObjectSchema.SUPPORTED_LIST_SIMPLE_FIELDS.get(fieldType);
        if (metadata == null || metadata.fieldType != RealmFieldType.STRING && metadata.fieldType != RealmFieldType.INTEGER && metadata.fieldType != RealmFieldType.OBJECT_ID) {
            throw new IllegalArgumentException(String.format("Realm doesn't support primary key field type '%s'.", fieldType));
        }
        boolean nullable = metadata.defaultNullable;
        if (MutableRealmObjectSchema.containsAttribute(attributes, FieldAttribute.REQUIRED)) {
            nullable = false;
        }
        return new MutableRealmObjectSchema(this.realm, this, this.realm.getSharedRealm().createTableWithPrimaryKey(internalTableName, primaryKeyFieldName, metadata.fieldType, nullable));
    }

    @Override
    public void remove(String className) {
        this.realm.checkNotInSync();
        this.checkNotEmpty(className, "Null or empty class names are not allowed");
        String internalTableName = Table.getTableNameForClass(className);
        if (!OsObjectStore.deleteTableForObject(this.realm.getSharedRealm(), className)) {
            throw new IllegalArgumentException("Cannot remove class because it is not in this Realm: " + className);
        }
        this.removeFromClassNameToSchemaMap(internalTableName);
    }

    @Override
    public RealmObjectSchema rename(String oldClassName, String newClassName) {
        this.realm.checkNotInSync();
        this.checkNotEmpty(oldClassName, "Class names cannot be empty or null");
        this.checkNotEmpty(newClassName, "Class names cannot be empty or null");
        String oldInternalName = Table.getTableNameForClass(oldClassName);
        String newInternalName = Table.getTableNameForClass(newClassName);
        this.checkHasTable(oldClassName, "Cannot rename class because it doesn't exist in this Realm: " + oldClassName);
        if (this.realm.getSharedRealm().hasTable(newInternalName)) {
            throw new IllegalArgumentException(oldClassName + " cannot be renamed because the new class already exists: " + newClassName);
        }
        this.realm.getSharedRealm().renameTable(oldInternalName, newInternalName);
        Table table = this.realm.getSharedRealm().getTable(newInternalName);
        RealmObjectSchema objectSchema = this.removeFromClassNameToSchemaMap(oldInternalName);
        if (objectSchema == null || !objectSchema.getTable().isValid() || !objectSchema.getClassName().equals(newClassName)) {
            objectSchema = new MutableRealmObjectSchema(this.realm, this, table);
        }
        this.putToClassNameToSchemaMap(newInternalName, objectSchema);
        return objectSchema;
    }

    private String checkAndGetTableNameFromClassName(String className) {
        if (className.length() > Table.CLASS_NAME_MAX_LENGTH) {
            throw new IllegalArgumentException(String.format(Locale.US, "Class name is too long. Limit is %1$d characters: %2$s", Table.CLASS_NAME_MAX_LENGTH, className.length()));
        }
        return Table.getTableNameForClass(className);
    }
}

