/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.CollectionUtils;
import io.realm.DynamicRealmObject;
import io.realm.Realm;
import io.realm.RealmDictionary;
import io.realm.RealmResults;
import io.realm.TypeSelectorForMap;
import io.realm.internal.OsMap;
import io.realm.internal.OsResults;
import io.realm.internal.Table;
import io.realm.internal.util.Pair;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class DynamicSelectorForMap<K>
extends TypeSelectorForMap<K, DynamicRealmObject> {
    private final String className;

    DynamicSelectorForMap(BaseRealm baseRealm, OsMap osMap, String className) {
        super(baseRealm, osMap);
        this.className = className;
    }

    @Override
    public DynamicRealmObject getRealmModel(BaseRealm baseRealm, long realmModelKey) {
        return baseRealm.get(DynamicRealmObject.class, this.className, realmModelKey);
    }

    @Override
    public DynamicRealmObject putRealmModel(BaseRealm baseRealm, OsMap osMap, K key, @Nullable DynamicRealmObject value) {
        long rowModelKey = osMap.getModelRowKey(key);
        if (value == null) {
            osMap.put(key, null);
        } else {
            boolean isEmbedded = baseRealm.getSchema().getSchemaForClass(this.className).isEmbedded();
            if (isEmbedded) {
                long objKey = osMap.createAndPutEmbeddedObject(key);
                CollectionUtils.updateEmbeddedObject((Realm)baseRealm, value, objKey);
            } else {
                boolean copyObject = CollectionUtils.checkCanObjectBeCopied(baseRealm, value, this.className, "dictionary");
                DynamicRealmObject proxy = copyObject ? CollectionUtils.copyToRealm(baseRealm, value) : value;
                osMap.putRow(key, proxy.realmGet$proxyState().getRow$realm().getObjectKey());
            }
        }
        if (rowModelKey == -1L) {
            return null;
        }
        return baseRealm.get(DynamicRealmObject.class, this.className, rowModelKey);
    }

    private <T> RealmResults<T> produceResults(BaseRealm baseRealm, Pair<Table, Long> tableAndValuesPtr, String className) {
        Long valuesPtr = (Long)tableAndValuesPtr.second;
        OsResults osResults = OsResults.createFromMap(baseRealm.sharedRealm, valuesPtr);
        return new RealmResults(baseRealm, osResults, className, false);
    }

    @Override
    public Map.Entry<K, DynamicRealmObject> getModelEntry(BaseRealm baseRealm, long objRow, K key) {
        DynamicRealmObject realmModel = baseRealm.get(DynamicRealmObject.class, this.className, objRow);
        return new AbstractMap.SimpleImmutableEntry<K, DynamicRealmObject>(key, realmModel);
    }

    @Override
    public Set<K> keySet() {
        return new HashSet(this.produceResults(this.baseRealm, this.osMap.tableAndKeyPtrs(), this.className));
    }

    @Override
    public Collection<DynamicRealmObject> getValues() {
        return this.produceResults(this.baseRealm, this.osMap.tableAndValuePtrs(), this.className);
    }

    @Override
    public RealmDictionary<DynamicRealmObject> freeze(BaseRealm frozenBaseRealm) {
        return new RealmDictionary<DynamicRealmObject>(frozenBaseRealm, this.osMap, this.className);
    }

    @Override
    Class<DynamicRealmObject> getValueClass() {
        return DynamicRealmObject.class;
    }

    @Override
    String getValueClassName() {
        return this.className;
    }
}

