/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.reactivex.Flowable;
import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.MutableRealmSchema;
import io.realm.RealmAsyncTask;
import io.realm.RealmCache;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmObject;
import io.realm.RealmObjectSchema;
import io.realm.RealmQuery;
import io.realm.RealmSchema;
import io.realm.exceptions.RealmException;
import io.realm.internal.CheckedRow;
import io.realm.internal.OsObject;
import io.realm.internal.OsObjectStore;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.RealmNotifier;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.Util;
import io.realm.internal.async.RealmAsyncTaskImpl;
import io.realm.log.RealmLog;
import java.util.Locale;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public class DynamicRealm
extends BaseRealm {
    private final RealmSchema schema;

    private DynamicRealm(final RealmCache cache, OsSharedRealm.VersionID version) {
        super(cache, null, version);
        RealmCache.invokeWithGlobalRefCount(cache.getConfiguration(), new RealmCache.Callback(){

            @Override
            public void onResult(int count) {
                if (count > 0) {
                    return;
                }
                if (cache.getConfiguration().isReadOnly()) {
                    return;
                }
                if (OsObjectStore.getSchemaVersion(DynamicRealm.this.sharedRealm) != -1L) {
                    return;
                }
                DynamicRealm.this.sharedRealm.beginTransaction();
                if (OsObjectStore.getSchemaVersion(DynamicRealm.this.sharedRealm) == -1L) {
                    OsObjectStore.setSchemaVersion(DynamicRealm.this.sharedRealm, -1L);
                }
                DynamicRealm.this.sharedRealm.commitTransaction();
            }
        });
        this.schema = new MutableRealmSchema(this);
    }

    private DynamicRealm(OsSharedRealm sharedRealm) {
        super(sharedRealm);
        this.schema = new MutableRealmSchema(this);
    }

    public static DynamicRealm getInstance(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        return RealmCache.createRealmOrGetFromCache(configuration, DynamicRealm.class);
    }

    public static RealmAsyncTask getInstanceAsync(RealmConfiguration configuration, Callback callback) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        return RealmCache.createRealmOrGetFromCacheAsync(configuration, callback, DynamicRealm.class);
    }

    public DynamicRealmObject createObject(String className) {
        this.checkIfValid();
        Table table = this.schema.getTable(className);
        String pkField = OsObjectStore.getPrimaryKeyForObject(this.sharedRealm, className);
        if (pkField != null) {
            throw new RealmException(String.format(Locale.US, "'%s' has a primary key field '%s', use  'createObject(String, Object)' instead.", className, pkField));
        }
        return new DynamicRealmObject(this, CheckedRow.getFromRow(OsObject.create(table)));
    }

    public DynamicRealmObject createObject(String className, Object primaryKeyValue) {
        Table table = this.schema.getTable(className);
        return new DynamicRealmObject(this, CheckedRow.getFromRow(OsObject.createWithPrimaryKey(table, primaryKeyValue)));
    }

    public DynamicRealmObject createEmbeddedObject(String className, DynamicRealmObject parentObject, String parentProperty) {
        this.checkIfValid();
        Util.checkNull(parentObject, "parentObject");
        Util.checkEmpty(parentProperty, "parentProperty");
        if (!RealmObject.isManaged(parentObject) || !RealmObject.isValid(parentObject)) {
            throw new IllegalArgumentException("Only valid, managed objects can be a parent to an embedded object.");
        }
        String pkField = OsObjectStore.getPrimaryKeyForObject(this.sharedRealm, className);
        if (pkField != null) {
            throw new RealmException(String.format(Locale.US, "'%s' has a primary key field '%s', embedded objects cannot have primary keys.", className, pkField));
        }
        String parentClassName = parentObject.getType();
        RealmObjectSchema parentObjectSchema = this.schema.get(parentClassName);
        if (parentObjectSchema == null) {
            throw new IllegalStateException(String.format("No schema found for '%s'.", parentClassName));
        }
        Row embeddedObject = this.getEmbeddedObjectRow(className, parentObject, parentProperty, this.schema, parentObjectSchema);
        return new DynamicRealmObject(this, embeddedObject);
    }

    public RealmQuery<DynamicRealmObject> where(String className) {
        this.checkIfValid();
        if (!this.sharedRealm.hasTable(Table.getTableNameForClass(className))) {
            throw new IllegalArgumentException("Class does not exist in the Realm and cannot be queried: " + className);
        }
        return RealmQuery.createDynamicQuery(this, className);
    }

    public void addChangeListener(RealmChangeListener<DynamicRealm> listener) {
        this.addListener(listener);
    }

    public void removeChangeListener(RealmChangeListener<DynamicRealm> listener) {
        this.removeListener(listener);
    }

    public void removeAllChangeListeners() {
        this.removeAllListeners();
    }

    public void delete(String className) {
        this.checkIfValid();
        this.checkIfInTransaction();
        this.schema.getTable(className).clear();
    }

    public void executeTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        this.checkAllowWritesOnUiThread();
        this.beginTransaction();
        try {
            transaction.execute(this);
            this.commitTransaction();
        }
        catch (RuntimeException e) {
            if (this.isInTransaction()) {
                this.cancelTransaction();
            } else {
                RealmLog.warn("Could not cancel transaction, not currently in a transaction.", new Object[0]);
            }
            throw e;
        }
    }

    public RealmAsyncTask executeTransactionAsync(Transaction transaction) {
        return this.executeTransactionAsync(transaction, null, null);
    }

    public RealmAsyncTask executeTransactionAsync(Transaction transaction, Transaction.OnSuccess onSuccess) {
        if (onSuccess == null) {
            throw new IllegalArgumentException("onSuccess callback can't be null");
        }
        return this.executeTransactionAsync(transaction, onSuccess, null);
    }

    public RealmAsyncTask executeTransactionAsync(Transaction transaction, Transaction.OnError onError) {
        if (onError == null) {
            throw new IllegalArgumentException("onError callback can't be null");
        }
        return this.executeTransactionAsync(transaction, null, onError);
    }

    public RealmAsyncTask executeTransactionAsync(final Transaction transaction, final @Nullable Transaction.OnSuccess onSuccess, final @Nullable Transaction.OnError onError) {
        this.checkIfValid();
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        if (this.isFrozen()) {
            throw new IllegalStateException("Write transactions on a frozen Realm is not allowed.");
        }
        final boolean canDeliverNotification = this.sharedRealm.capabilities.canDeliverNotification();
        if (onSuccess != null || onError != null) {
            this.sharedRealm.capabilities.checkCanDeliverNotification("Callback cannot be delivered on current thread.");
        }
        final RealmConfiguration realmConfiguration = this.getConfiguration();
        final RealmNotifier realmNotifier = this.sharedRealm.realmNotifier;
        Future<?> pendingTransaction = asyncTaskExecutor.submitTransaction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                OsSharedRealm.VersionID versionID = null;
                Throwable exception = null;
                DynamicRealm bgRealm = DynamicRealm.getInstance(realmConfiguration);
                bgRealm.beginTransaction();
                try {
                    transaction.execute(bgRealm);
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    bgRealm.commitTransaction();
                    versionID = bgRealm.sharedRealm.getVersionID();
                }
                catch (Throwable e) {
                    exception = e;
                }
                finally {
                    try {
                        if (bgRealm.isInTransaction()) {
                            bgRealm.cancelTransaction();
                        }
                    }
                    finally {
                        bgRealm.close();
                    }
                }
                final Throwable backgroundException = exception;
                final OsSharedRealm.VersionID backgroundVersionID = versionID;
                if (canDeliverNotification) {
                    if (backgroundVersionID != null && onSuccess != null) {
                        realmNotifier.post(new Runnable(){

                            @Override
                            public void run() {
                                if (DynamicRealm.this.isClosed()) {
                                    onSuccess.onSuccess();
                                    return;
                                }
                                if (DynamicRealm.this.sharedRealm.getVersionID().compareTo(backgroundVersionID) < 0) {
                                    DynamicRealm.this.sharedRealm.realmNotifier.addTransactionCallback(new Runnable(){

                                        @Override
                                        public void run() {
                                            onSuccess.onSuccess();
                                        }
                                    });
                                } else {
                                    onSuccess.onSuccess();
                                }
                            }
                        });
                    } else if (backgroundException != null) {
                        realmNotifier.post(new Runnable(){

                            @Override
                            public void run() {
                                if (onError == null) {
                                    throw new RealmException("Async transaction failed", backgroundException);
                                }
                                onError.onError(backgroundException);
                            }
                        });
                    }
                } else if (backgroundException != null) {
                    throw new RealmException("Async transaction failed", backgroundException);
                }
            }
        });
        return new RealmAsyncTaskImpl(pendingTransaction, asyncTaskExecutor);
    }

    static DynamicRealm createInstance(RealmCache cache, OsSharedRealm.VersionID version) {
        return new DynamicRealm(cache, version);
    }

    static DynamicRealm createInstance(OsSharedRealm sharedRealm) {
        return new DynamicRealm(sharedRealm);
    }

    public Flowable<DynamicRealm> asFlowable() {
        return this.configuration.getRxFactory().from(this);
    }

    @Override
    public boolean isEmpty() {
        this.checkIfValid();
        return this.sharedRealm.isEmpty();
    }

    @Override
    public RealmSchema getSchema() {
        return this.schema;
    }

    @Override
    public DynamicRealm freeze() {
        OsSharedRealm.VersionID version;
        try {
            version = this.sharedRealm.getVersionID();
        }
        catch (IllegalStateException e) {
            this.getVersion();
            version = this.sharedRealm.getVersionID();
        }
        return RealmCache.createRealmOrGetFromCache(this.configuration, DynamicRealm.class, version);
    }

    void setVersion(long version) {
        OsObjectStore.setSchemaVersion(this.sharedRealm, version);
    }

    public static abstract class Callback
    extends BaseRealm.InstanceCallback<DynamicRealm> {
        @Override
        public abstract void onSuccess(DynamicRealm var1);

        @Override
        public void onError(Throwable exception) {
            super.onError(exception);
        }
    }

    public static interface Transaction {
        public void execute(DynamicRealm var1);

        public static interface OnError {
            public void onError(Throwable var1);
        }

        public static interface OnSuccess {
            public void onSuccess();
        }

        public static class Callback {
            public void onSuccess() {
            }

            public void onError(Exception ignore) {
            }
        }
    }
}

