/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.widget.BaseAdapter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.realm.OrderedRealmCollection;
import io.realm.RealmChangeListener;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmResults;

public abstract class RealmBaseAdapter<T extends RealmModel>
extends BaseAdapter {
    @Nullable
    protected OrderedRealmCollection<T> adapterData;
    private final RealmChangeListener<OrderedRealmCollection<T>> listener;

    public RealmBaseAdapter(@Nullable OrderedRealmCollection<T> data) {
        if (data != null && !data.isManaged()) {
            throw new IllegalStateException("Only use this adapter with managed list, for un-managed lists you can just use the BaseAdapter");
        }
        this.adapterData = data;
        this.listener = new RealmChangeListener<OrderedRealmCollection<T>>(){

            public void onChange(OrderedRealmCollection<T> results) {
                RealmBaseAdapter.this.notifyDataSetChanged();
            }
        };
        if (this.isDataValid()) {
            this.addListener(data);
        }
    }

    private void addListener(@NonNull OrderedRealmCollection<T> data) {
        if (data instanceof RealmResults) {
            RealmResults results = (RealmResults)data;
            results.addChangeListener(this.listener);
        } else if (data instanceof RealmList) {
            RealmList list = (RealmList)data;
            list.addChangeListener(this.listener);
        } else {
            throw new IllegalArgumentException("RealmCollection not supported: " + data.getClass());
        }
    }

    private void removeListener(@NonNull OrderedRealmCollection<T> data) {
        if (data instanceof RealmResults) {
            RealmResults results = (RealmResults)data;
            results.removeChangeListener(this.listener);
        } else if (data instanceof RealmList) {
            RealmList list = (RealmList)data;
            list.removeChangeListener(this.listener);
        } else {
            throw new IllegalArgumentException("RealmCollection not supported: " + data.getClass());
        }
    }

    public int getCount() {
        return this.isDataValid() ? this.adapterData.size() : 0;
    }

    @Nullable
    public T getItem(int position) {
        return (T)(this.isDataValid() ? (RealmModel)this.adapterData.get(position) : null);
    }

    public long getItemId(int position) {
        return position;
    }

    public void updateData(@Nullable OrderedRealmCollection<T> data) {
        if (this.listener != null) {
            if (this.isDataValid()) {
                this.removeListener(this.adapterData);
            }
            if (data != null && data.isValid()) {
                this.addListener(data);
            }
        }
        this.adapterData = data;
        this.notifyDataSetChanged();
    }

    private boolean isDataValid() {
        return this.adapterData != null && this.adapterData.isValid();
    }
}

