/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.widget.BaseAdapter;
import io.realm.BaseRealm;
import io.realm.OrderedRealmCollection;
import io.realm.RealmChangeListener;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmResults;

public abstract class RealmBaseAdapter<T extends RealmModel>
extends BaseAdapter {
    protected LayoutInflater inflater;
    @Nullable
    protected OrderedRealmCollection<T> adapterData;
    @NonNull
    protected Context context;
    private final RealmChangeListener listener;

    public RealmBaseAdapter(@NonNull Context context, @Nullable OrderedRealmCollection<T> data) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        this.context = context;
        this.adapterData = data;
        this.inflater = LayoutInflater.from((Context)context);
        this.listener = new RealmChangeListener<BaseRealm>(){

            public void onChange(BaseRealm results) {
                RealmBaseAdapter.this.notifyDataSetChanged();
            }
        };
        if (data != null) {
            this.addListener(data);
        }
    }

    private void addListener(@NonNull OrderedRealmCollection<T> data) {
        if (data instanceof RealmResults) {
            RealmResults realmResults = (RealmResults)data;
            realmResults.realm.handlerController.addChangeListenerAsWeakReference(this.listener);
        } else if (data instanceof RealmList) {
            RealmList realmList = (RealmList)data;
            realmList.realm.handlerController.addChangeListenerAsWeakReference(this.listener);
        } else {
            throw new IllegalArgumentException("RealmCollection not supported: " + data.getClass());
        }
    }

    private void removeListener(@NonNull OrderedRealmCollection<T> data) {
        if (data instanceof RealmResults) {
            RealmResults realmResults = (RealmResults)data;
            realmResults.realm.handlerController.removeWeakChangeListener(this.listener);
        } else if (data instanceof RealmList) {
            RealmList realmList = (RealmList)data;
            realmList.realm.handlerController.removeWeakChangeListener(this.listener);
        } else {
            throw new IllegalArgumentException("RealmCollection not supported: " + data.getClass());
        }
    }

    public int getCount() {
        if (this.adapterData == null) {
            return 0;
        }
        return this.adapterData.size();
    }

    @Nullable
    public T getItem(int position) {
        if (this.adapterData == null) {
            return null;
        }
        return (T)((RealmModel)this.adapterData.get(position));
    }

    public long getItemId(int position) {
        return position;
    }

    public void updateData(@Nullable OrderedRealmCollection<T> data) {
        if (this.listener != null) {
            if (this.adapterData != null) {
                this.removeListener(this.adapterData);
            }
            if (data != null) {
                this.addListener(data);
            }
        }
        this.adapterData = data;
        this.notifyDataSetChanged();
    }
}

