/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import io.realm.BaseRealm;
import io.realm.OrderedRealmCollection;
import io.realm.RealmChangeListener;
import io.realm.RealmList;
import io.realm.RealmObject;
import io.realm.RealmResults;

public abstract class RealmRecyclerViewAdapter<T extends RealmObject, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    protected final LayoutInflater inflater;
    protected final Context context;
    private final boolean hasAutoUpdates;
    private final RealmChangeListener<BaseRealm> listener;
    private OrderedRealmCollection<T> adapterData;

    public RealmRecyclerViewAdapter(Context context, OrderedRealmCollection<T> data, boolean autoUpdate) {
        if (context == null) {
            throw new IllegalArgumentException("Context can not be null");
        }
        this.context = context;
        this.adapterData = data;
        this.inflater = LayoutInflater.from((Context)context);
        this.hasAutoUpdates = autoUpdate;
        this.listener = this.hasAutoUpdates ? new RealmChangeListener<BaseRealm>(){

            public void onChange(BaseRealm results) {
                RealmRecyclerViewAdapter.this.notifyDataSetChanged();
            }
        } : null;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        if (this.hasAutoUpdates && this.isDataValid()) {
            this.addListener(this.adapterData);
        }
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        if (this.hasAutoUpdates && this.isDataValid()) {
            this.removeListener(this.adapterData);
        }
    }

    public long getItemId(int index) {
        return index;
    }

    public int getItemCount() {
        return this.isDataValid() ? this.adapterData.size() : 0;
    }

    public T getItem(int index) {
        return (T)(this.isDataValid() ? (RealmObject)this.adapterData.get(index) : null);
    }

    public OrderedRealmCollection<T> getData() {
        return this.adapterData;
    }

    public void updateData(OrderedRealmCollection<T> data) {
        if (this.hasAutoUpdates) {
            if (this.adapterData != null) {
                this.removeListener(this.adapterData);
            }
            if (data != null) {
                this.addListener(data);
            }
        }
        this.adapterData = data;
        this.notifyDataSetChanged();
    }

    private void addListener(OrderedRealmCollection<T> data) {
        if (data instanceof RealmResults) {
            RealmResults realmResults = (RealmResults)data;
            realmResults.addChangeListener(this.listener);
        } else if (data instanceof RealmList) {
            RealmList realmList = (RealmList)data;
            realmList.realm.handlerController.addChangeListenerAsWeakReference(this.listener);
        } else {
            throw new IllegalArgumentException("RealmCollection not supported: " + data.getClass());
        }
    }

    private void removeListener(OrderedRealmCollection<T> data) {
        if (data instanceof RealmResults) {
            RealmResults realmResults = (RealmResults)data;
            realmResults.removeChangeListener(this.listener);
        } else if (data instanceof RealmList) {
            RealmList realmList = (RealmList)data;
            realmList.realm.handlerController.removeWeakChangeListener(this.listener);
        } else {
            throw new IllegalArgumentException("RealmCollection not supported: " + data.getClass());
        }
    }

    private boolean isDataValid() {
        return this.adapterData != null && this.adapterData.isValid();
    }
}

