/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.BackpressureKind;
import io.reactivex.rxjava3.annotations.BackpressureSupport;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.SchedulerSupport;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.fuseable.QueueSubscription;
import io.reactivex.rxjava3.internal.fuseable.SimpleQueue;
import io.reactivex.rxjava3.internal.queue.SpscArrayQueue;
import io.reactivex.rxjava3.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@BackpressureSupport(value=BackpressureKind.FULL)
@SchedulerSupport(value="none")
public final class MulticastProcessor<T>
extends FlowableProcessor<T> {
    final AtomicInteger wip;
    final AtomicReference<Subscription> upstream;
    final AtomicReference<MulticastSubscription<T>[]> subscribers;
    final AtomicBoolean once;
    final int bufferSize;
    final int limit;
    final boolean refcount;
    volatile SimpleQueue<T> queue;
    volatile boolean done;
    volatile Throwable error;
    int consumed;
    int fusionMode;
    static final MulticastSubscription[] EMPTY = new MulticastSubscription[0];
    static final MulticastSubscription[] TERMINATED = new MulticastSubscription[0];

    @CheckReturnValue
    @NonNull
    public static <T> MulticastProcessor<T> create() {
        return new MulticastProcessor<T>(MulticastProcessor.bufferSize(), false);
    }

    @CheckReturnValue
    @NonNull
    public static <T> MulticastProcessor<T> create(boolean refCount) {
        return new MulticastProcessor<T>(MulticastProcessor.bufferSize(), refCount);
    }

    @CheckReturnValue
    @NonNull
    public static <T> MulticastProcessor<T> create(int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return new MulticastProcessor<T>(bufferSize, false);
    }

    @CheckReturnValue
    @NonNull
    public static <T> MulticastProcessor<T> create(int bufferSize, boolean refCount) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return new MulticastProcessor<T>(bufferSize, refCount);
    }

    MulticastProcessor(int bufferSize, boolean refCount) {
        this.bufferSize = bufferSize;
        this.limit = bufferSize - (bufferSize >> 2);
        this.wip = new AtomicInteger();
        this.subscribers = new AtomicReference<MulticastSubscription[]>(EMPTY);
        this.upstream = new AtomicReference();
        this.refcount = refCount;
        this.once = new AtomicBoolean();
    }

    public void start() {
        if (SubscriptionHelper.setOnce(this.upstream, EmptySubscription.INSTANCE)) {
            this.queue = new SpscArrayQueue<T>(this.bufferSize);
        }
    }

    public void startUnbounded() {
        if (SubscriptionHelper.setOnce(this.upstream, EmptySubscription.INSTANCE)) {
            this.queue = new SpscLinkedArrayQueue(this.bufferSize);
        }
    }

    @Override
    public void onSubscribe(@NonNull Subscription s) {
        if (SubscriptionHelper.setOnce(this.upstream, s)) {
            if (s instanceof QueueSubscription) {
                QueueSubscription qs = (QueueSubscription)s;
                int m = qs.requestFusion(3);
                if (m == 1) {
                    this.fusionMode = m;
                    this.queue = qs;
                    this.done = true;
                    this.drain();
                    return;
                }
                if (m == 2) {
                    this.fusionMode = m;
                    this.queue = qs;
                    s.request((long)this.bufferSize);
                    return;
                }
            }
            this.queue = new SpscArrayQueue<T>(this.bufferSize);
            s.request((long)this.bufferSize);
        }
    }

    public void onNext(@NonNull T t) {
        if (this.once.get()) {
            return;
        }
        if (this.fusionMode == 0) {
            ExceptionHelper.nullCheck(t, "onNext called with a null value.");
            if (!this.queue.offer(t)) {
                SubscriptionHelper.cancel(this.upstream);
                this.onError(new MissingBackpressureException());
                return;
            }
        }
        this.drain();
    }

    @CheckReturnValue
    public boolean offer(@NonNull T t) {
        ExceptionHelper.nullCheck(t, "offer called with a null value.");
        if (this.once.get()) {
            return false;
        }
        if (this.fusionMode == 0) {
            if (this.queue.offer(t)) {
                this.drain();
                return true;
            }
            return false;
        }
        throw new IllegalStateException("offer() should not be called in fusion mode!");
    }

    public void onError(@NonNull Throwable t) {
        ExceptionHelper.nullCheck(t, "onError called with a null Throwable.");
        if (this.once.compareAndSet(false, true)) {
            this.error = t;
            this.done = true;
            this.drain();
        } else {
            RxJavaPlugins.onError(t);
        }
    }

    public void onComplete() {
        if (this.once.compareAndSet(false, true)) {
            this.done = true;
            this.drain();
        }
    }

    @Override
    @CheckReturnValue
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        return this.once.get() && this.error != null;
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        return this.once.get() && this.error == null;
    }

    @Override
    @CheckReturnValue
    public Throwable getThrowable() {
        return this.once.get() ? this.error : null;
    }

    @Override
    protected void subscribeActual(@NonNull @NonNull Subscriber<@NonNull ? super T> s) {
        MulticastSubscription<T> ms = new MulticastSubscription<T>(s, this);
        s.onSubscribe(ms);
        if (this.add(ms)) {
            if (ms.get() == Long.MIN_VALUE) {
                this.remove(ms);
            } else {
                this.drain();
            }
        } else {
            Throwable ex;
            if ((this.once.get() || !this.refcount) && (ex = this.error) != null) {
                s.onError(ex);
                return;
            }
            s.onComplete();
        }
    }

    boolean add(MulticastSubscription<T> inner) {
        MulticastSubscription[] b;
        MulticastSubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new MulticastSubscription[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void remove(MulticastSubscription<T> inner) {
        MulticastSubscription<T>[] a;
        int n;
        while ((n = (a = this.subscribers.get()).length) != 0) {
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) return;
            if (n == 1) {
                if (this.refcount) {
                    if (!this.subscribers.compareAndSet(a, TERMINATED)) continue;
                    SubscriptionHelper.cancel(this.upstream);
                    this.once.set(true);
                    return;
                }
                if (!this.subscribers.compareAndSet(a, EMPTY)) continue;
                return;
            }
            MulticastSubscription[] b = new MulticastSubscription[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
            if (this.subscribers.compareAndSet(a, b)) return;
        }
        return;
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        AtomicReference<MulticastSubscription<T>[]> subs = this.subscribers;
        int c = this.consumed;
        int lim = this.limit;
        int fm = this.fusionMode;
        block2: while (true) {
            MulticastSubscription<T>[] as;
            int n;
            SimpleQueue<T> q;
            if ((q = this.queue) != null && (n = (as = subs.get()).length) != 0) {
                MulticastSubscription<T>[] bs;
                long r = -1L;
                for (MulticastSubscription<T> a : as) {
                    long ra = a.get();
                    if (ra < 0L) continue;
                    r = r == -1L ? ra - a.emitted : Math.min(r, ra - a.emitted);
                }
                while (r > 0L) {
                    boolean empty;
                    T v;
                    bs = subs.get();
                    if (bs == TERMINATED) {
                        q.clear();
                        return;
                    }
                    if (as != bs) continue block2;
                    boolean d = this.done;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        SubscriptionHelper.cancel(this.upstream);
                        d = true;
                        v = null;
                        this.error = ex;
                        this.done = true;
                    }
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onError(ex);
                            }
                        } else {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onComplete();
                            }
                        }
                        return;
                    }
                    if (empty) break;
                    for (MulticastSubscription<T> inner : as) {
                        inner.onNext(v);
                    }
                    --r;
                    if (fm == 1 || ++c != lim) continue;
                    c = 0;
                    this.upstream.get().request((long)lim);
                }
                if (r == 0L) {
                    bs = subs.get();
                    if (bs == TERMINATED) {
                        q.clear();
                        return;
                    }
                    if (as != bs) continue;
                    if (this.done && q.isEmpty()) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onError(ex);
                            }
                        } else {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onComplete();
                            }
                        }
                        return;
                    }
                }
            }
            this.consumed = c;
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
        }
    }

    static final class MulticastSubscription<T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = -363282618957264509L;
        final Subscriber<@NonNull ? super T> downstream;
        final MulticastProcessor<T> parent;
        long emitted;

        MulticastSubscription(Subscriber<@NonNull ? super T> actual, MulticastProcessor<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                long r;
                while ((r = this.get()) != Long.MIN_VALUE && r != Long.MAX_VALUE) {
                    long u = r + n;
                    if (u < 0L) {
                        u = Long.MAX_VALUE;
                    }
                    if (!this.compareAndSet(r, u)) continue;
                    this.parent.drain();
                    break;
                }
            }
        }

        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
            }
        }

        void onNext(T t) {
            if (this.get() != Long.MIN_VALUE) {
                ++this.emitted;
                this.downstream.onNext(t);
            }
        }

        void onError(Throwable t) {
            if (this.get() != Long.MIN_VALUE) {
                this.downstream.onError(t);
            }
        }

        void onComplete() {
            if (this.get() != Long.MIN_VALUE) {
                this.downstream.onComplete();
            }
        }
    }
}

