/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.functions.Supplier;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.BasicFuseableObserver;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Collection;

public final class ObservableDistinct<T, K>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super T, K> keySelector;
    final Supplier<? extends Collection<? super K>> collectionSupplier;

    public ObservableDistinct(ObservableSource<T> source, Function<? super T, K> keySelector, Supplier<? extends Collection<? super K>> collectionSupplier) {
        super(source);
        this.keySelector = keySelector;
        this.collectionSupplier = collectionSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        Collection<? super K> collection;
        try {
            collection = ObjectHelper.requireNonNull(this.collectionSupplier.get(), "The collectionSupplier returned a null collection. Null values are generally not allowed in 2.x operators and sources.");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        this.source.subscribe(new DistinctObserver<T, K>(observer, this.keySelector, collection));
    }

    static final class DistinctObserver<T, K>
    extends BasicFuseableObserver<T, T> {
        final Collection<? super K> collection;
        final Function<? super T, K> keySelector;

        DistinctObserver(Observer<? super T> actual, Function<? super T, K> keySelector, Collection<? super K> collection) {
            super(actual);
            this.keySelector = keySelector;
            this.collection = collection;
        }

        @Override
        public void onNext(T value) {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 0) {
                boolean b;
                try {
                    K key = ObjectHelper.requireNonNull(this.keySelector.apply(value), "The keySelector returned a null key");
                    b = this.collection.add(key);
                }
                catch (Throwable ex) {
                    this.fail(ex);
                    return;
                }
                if (b) {
                    this.downstream.onNext(value);
                }
            } else {
                this.downstream.onNext(null);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError(e);
            } else {
                this.done = true;
                this.collection.clear();
                this.downstream.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.collection.clear();
                this.downstream.onComplete();
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v;
            while ((v = this.qd.poll()) != null && !this.collection.add(ObjectHelper.requireNonNull(this.keySelector.apply(v), "The keySelector returned a null key"))) {
            }
            return v;
        }

        @Override
        public void clear() {
            this.collection.clear();
            super.clear();
        }
    }
}

