/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableRefCount<T>
extends Observable<T> {
    final ConnectableObservable<T> source;
    final int n;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    RefConnection connection;

    public ObservableRefCount(ConnectableObservable<T> source) {
        this(source, 1, 0L, TimeUnit.NANOSECONDS, null);
    }

    public ObservableRefCount(ConnectableObservable<T> source, int n, long timeout, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.n = n;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        RefConnection conn;
        boolean connect = false;
        ObservableRefCount observableRefCount = this;
        synchronized (observableRefCount) {
            long c;
            conn = this.connection;
            if (conn == null) {
                this.connection = conn = new RefConnection(this);
            }
            if ((c = conn.subscriberCount) == 0L && conn.timer != null) {
                conn.timer.dispose();
            }
            conn.subscriberCount = c + 1L;
            if (!conn.connected && c + 1L == (long)this.n) {
                connect = true;
                conn.connected = true;
            }
        }
        this.source.subscribe(new RefCountObserver<T>(observer, this, conn));
        if (connect) {
            this.source.connect(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(RefConnection rc) {
        SequentialDisposable sd;
        ObservableRefCount observableRefCount = this;
        synchronized (observableRefCount) {
            long c;
            if (this.connection == null || this.connection != rc) {
                return;
            }
            rc.subscriberCount = c = rc.subscriberCount - 1L;
            if (c != 0L || !rc.connected) {
                return;
            }
            if (this.timeout == 0L) {
                this.timeout(rc);
                return;
            }
            sd = new SequentialDisposable();
            rc.timer = sd;
        }
        sd.replace(this.scheduler.scheduleDirect(rc, this.timeout, this.unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminated(RefConnection rc) {
        ObservableRefCount observableRefCount = this;
        synchronized (observableRefCount) {
            if (this.connection != null && this.connection == rc) {
                this.connection = null;
                if (rc.timer != null) {
                    rc.timer.dispose();
                }
            }
            if (--rc.subscriberCount == 0L) {
                this.source.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeout(RefConnection rc) {
        ObservableRefCount observableRefCount = this;
        synchronized (observableRefCount) {
            if (rc.subscriberCount == 0L && rc == this.connection) {
                this.connection = null;
                Disposable connectionObject = (Disposable)rc.get();
                DisposableHelper.dispose(rc);
                if (connectionObject == null) {
                    rc.disconnectedEarly = true;
                } else {
                    this.source.reset();
                }
            }
        }
    }

    static final class RefCountObserver<T>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -7419642935409022375L;
        final Observer<? super T> downstream;
        final ObservableRefCount<T> parent;
        final RefConnection connection;
        Disposable upstream;

        RefCountObserver(Observer<? super T> downstream, ObservableRefCount<T> parent, RefConnection connection) {
            this.downstream = downstream;
            this.parent = parent;
            this.connection = connection;
        }

        @Override
        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            if (this.compareAndSet(false, true)) {
                this.parent.cancel(this.connection);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }
    }

    static final class RefConnection
    extends AtomicReference<Disposable>
    implements Runnable,
    Consumer<Disposable> {
        private static final long serialVersionUID = -4552101107598366241L;
        final ObservableRefCount<?> parent;
        Disposable timer;
        long subscriberCount;
        boolean connected;
        boolean disconnectedEarly;

        RefConnection(ObservableRefCount<?> parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            this.parent.timeout(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Disposable t) throws Exception {
            DisposableHelper.replace(this, t);
            ObservableRefCount<?> observableRefCount = this.parent;
            synchronized (observableRefCount) {
                if (this.disconnectedEarly) {
                    this.parent.source.reset();
                }
            }
        }
    }
}

