/*
 * Decompiled with CFR 0.152.
 */
package rx.joins;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observer;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action4;
import rx.functions.Func4;
import rx.joins.ActivePlan0;
import rx.joins.ActivePlan4;
import rx.joins.JoinObserver;
import rx.joins.JoinObserver1;
import rx.joins.Pattern4;
import rx.joins.Plan0;

public final class Plan4<T1, T2, T3, T4, R>
extends Plan0<R> {
    protected final Pattern4<T1, T2, T3, T4> expression;
    protected final Func4<T1, T2, T3, T4, R> selector;

    public Plan4(Pattern4<T1, T2, T3, T4> expression, Func4<T1, T2, T3, T4, R> selector) {
        this.expression = expression;
        this.selector = selector;
    }

    @Override
    public ActivePlan0 activate(Map<Object, JoinObserver> externalSubscriptions, final Observer<R> observer, final Action1<ActivePlan0> deactivate) {
        Action1<Throwable> onError = Plan4.onErrorFrom(observer);
        final JoinObserver1<T1> jo1 = Plan4.createObserver(externalSubscriptions, this.expression.o1(), onError);
        final JoinObserver1<T2> jo2 = Plan4.createObserver(externalSubscriptions, this.expression.o2(), onError);
        final JoinObserver1<T3> jo3 = Plan4.createObserver(externalSubscriptions, this.expression.o3(), onError);
        final JoinObserver1<T4> jo4 = Plan4.createObserver(externalSubscriptions, this.expression.o4(), onError);
        final AtomicReference<ActivePlan4<T1, T2, T3, T4>> self = new AtomicReference<ActivePlan4<T1, T2, T3, T4>>();
        ActivePlan4<T1, T2, T3, T4> activePlan = new ActivePlan4<T1, T2, T3, T4>(jo1, jo2, jo3, jo4, new Action4<T1, T2, T3, T4>(){

            public void call(T1 t1, T2 t2, T3 t3, T4 t4) {
                Object result;
                try {
                    result = Plan4.this.selector.call(t1, t2, t3, t4);
                }
                catch (Throwable t) {
                    observer.onError(t);
                    return;
                }
                observer.onNext(result);
            }
        }, new Action0(){

            public void call() {
                ActivePlan0 ap = (ActivePlan0)self.get();
                jo1.removeActivePlan(ap);
                jo2.removeActivePlan(ap);
                jo3.removeActivePlan(ap);
                jo4.removeActivePlan(ap);
                deactivate.call((Object)ap);
            }
        });
        self.set(activePlan);
        jo1.addActivePlan(activePlan);
        jo2.addActivePlan(activePlan);
        jo3.addActivePlan(activePlan);
        jo4.addActivePlan(activePlan);
        return activePlan;
    }
}

