/*
 * Decompiled with CFR 0.152.
 */
package rx.joins;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observer;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action3;
import rx.functions.Func3;
import rx.joins.ActivePlan0;
import rx.joins.ActivePlan3;
import rx.joins.JoinObserver;
import rx.joins.JoinObserver1;
import rx.joins.Pattern3;
import rx.joins.Plan0;

public final class Plan3<T1, T2, T3, R>
extends Plan0<R> {
    protected final Pattern3<T1, T2, T3> expression;
    protected final Func3<T1, T2, T3, R> selector;

    public Plan3(Pattern3<T1, T2, T3> expression, Func3<T1, T2, T3, R> selector) {
        this.expression = expression;
        this.selector = selector;
    }

    @Override
    public ActivePlan0 activate(Map<Object, JoinObserver> externalSubscriptions, final Observer<R> observer, final Action1<ActivePlan0> deactivate) {
        Action1<Throwable> onError = Plan3.onErrorFrom(observer);
        final JoinObserver1<T1> jo1 = Plan3.createObserver(externalSubscriptions, this.expression.o1(), onError);
        final JoinObserver1<T2> jo2 = Plan3.createObserver(externalSubscriptions, this.expression.o2(), onError);
        final JoinObserver1<T3> jo3 = Plan3.createObserver(externalSubscriptions, this.expression.o3(), onError);
        final AtomicReference<ActivePlan3<T1, T2, T3>> self = new AtomicReference<ActivePlan3<T1, T2, T3>>();
        ActivePlan3<T1, T2, T3> activePlan = new ActivePlan3<T1, T2, T3>(jo1, jo2, jo3, new Action3<T1, T2, T3>(){

            public void call(T1 t1, T2 t2, T3 t3) {
                Object result;
                try {
                    result = Plan3.this.selector.call(t1, t2, t3);
                }
                catch (Throwable t) {
                    observer.onError(t);
                    return;
                }
                observer.onNext(result);
            }
        }, new Action0(){

            public void call() {
                ActivePlan0 ap = (ActivePlan0)self.get();
                jo1.removeActivePlan(ap);
                jo2.removeActivePlan(ap);
                jo3.removeActivePlan(ap);
                deactivate.call((Object)ap);
            }
        });
        self.set(activePlan);
        jo1.addActivePlan(activePlan);
        jo2.addActivePlan(activePlan);
        jo3.addActivePlan(activePlan);
        return activePlan;
    }
}

