/*
 * Decompiled with CFR 0.152.
 */
package rx.joins;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observer;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Func2;
import rx.joins.ActivePlan0;
import rx.joins.ActivePlan2;
import rx.joins.JoinObserver;
import rx.joins.JoinObserver1;
import rx.joins.Pattern2;
import rx.joins.Plan0;

public final class Plan2<T1, T2, R>
extends Plan0<R> {
    protected final Pattern2<T1, T2> expression;
    protected final Func2<T1, T2, R> selector;

    public Plan2(Pattern2<T1, T2> expression, Func2<T1, T2, R> selector) {
        this.expression = expression;
        this.selector = selector;
    }

    @Override
    public ActivePlan0 activate(Map<Object, JoinObserver> externalSubscriptions, final Observer<R> observer, final Action1<ActivePlan0> deactivate) {
        Action1<Throwable> onError = Plan2.onErrorFrom(observer);
        final JoinObserver1<T1> jo1 = Plan2.createObserver(externalSubscriptions, this.expression.o1(), onError);
        final JoinObserver1<T2> jo2 = Plan2.createObserver(externalSubscriptions, this.expression.o2(), onError);
        final AtomicReference<ActivePlan2<T1, T2>> self = new AtomicReference<ActivePlan2<T1, T2>>();
        ActivePlan2<T1, T2> activePlan = new ActivePlan2<T1, T2>(jo1, jo2, new Action2<T1, T2>(){

            public void call(T1 t1, T2 t2) {
                Object result;
                try {
                    result = Plan2.this.selector.call(t1, t2);
                }
                catch (Throwable t) {
                    observer.onError(t);
                    return;
                }
                observer.onNext(result);
            }
        }, new Action0(){

            public void call() {
                ActivePlan0 ap = (ActivePlan0)self.get();
                jo1.removeActivePlan(ap);
                jo2.removeActivePlan(ap);
                deactivate.call((Object)ap);
            }
        });
        self.set(activePlan);
        jo1.addActivePlan(activePlan);
        jo2.addActivePlan(activePlan);
        return activePlan;
    }
}

