/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.junit5.web;

import io.reactiverse.junit5.web.WebClientOptionsInject;
import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.junit5.ParameterClosingConsumer;
import io.vertx.junit5.ScopedObject;
import io.vertx.junit5.VertxExtensionParameterProvider;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

public class WebClientParameterProvider
implements VertxExtensionParameterProvider<WebClient> {
    public Class<WebClient> type() {
        return WebClient.class;
    }

    public String key() {
        return "WebClient";
    }

    public WebClient newInstance(ExtensionContext extensionContext, ParameterContext parameterContext) {
        ExtensionContext.Store store = extensionContext.getStore(ExtensionContext.Namespace.GLOBAL);
        ScopedObject scopedObject = (ScopedObject)store.get((Object)"Vertx", ScopedObject.class);
        Objects.requireNonNull(scopedObject, "A Vertx instance must exist, try adding the Vertx parameter as the first method argument");
        Vertx vertx = (Vertx)scopedObject.get();
        WebClientOptions webClientOptions = WebClientParameterProvider.getWebClientOptions(extensionContext).orElse(new WebClientOptions());
        return WebClient.create((Vertx)vertx, (WebClientOptions)webClientOptions);
    }

    public ParameterClosingConsumer<WebClient> parameterClosingConsumer() {
        return WebClient::close;
    }

    public static Optional<WebClientOptions> getWebClientOptions(ExtensionContext context) {
        Optional thisTestClass = context.getTestClass();
        if (!thisTestClass.isPresent()) {
            return Optional.empty();
        }
        List webClientOptionsField = AnnotationUtils.findPublicAnnotatedFields((Class)((Class)thisTestClass.get()), WebClientOptions.class, WebClientOptionsInject.class);
        if (webClientOptionsField.isEmpty()) {
            return Optional.empty();
        }
        return ReflectionUtils.tryToReadFieldValue((Field)((Field)webClientOptionsField.get(0)), context.getTestInstance().get()).toOptional().map(o -> (WebClientOptions)o);
    }
}

