/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.internal;

import java.util.Objects;
import ratpack.api.Nullable;
import ratpack.session.SessionKey;

public class DefaultSessionKey<T>
implements SessionKey<T> {
    @Nullable
    private final String name;
    @Nullable
    private final Class<T> type;

    public DefaultSessionKey(@Nullable String name, @Nullable Class<T> type) {
        if (name == null && type == null) {
            throw new IllegalArgumentException("one of name or type must not be null");
        }
        this.name = name;
        this.type = type;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSessionKey that = (DefaultSessionKey)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SessionKey[name='" + this.name + '\'' + ", type=" + (this.type == null ? null : this.type.getName()) + ']';
    }
}

